/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.note;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class AddWorkflowNotesAction
extends AbstractAtsAction {
    private static final AttributeTypeString notesAttrType = AtsAttributeTypes.WorkflowNotes;
    private final IAtsWorkItem workItem;
    private boolean emulate = false;

    public AddWorkflowNotesAction(IAtsWorkItem workItem) {
        this.workItem = workItem;
        this.setText("Add/Update Workflow Notes");
        this.setToolTipText(this.getText());
    }

    @Override
    public void runWithException() {
        String noteText = "";
        noteText = this.emulate ? this.performEmulate() : this.performUi();
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getText());
        if (Strings.isValid((String)noteText)) {
            changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)notesAttrType, noteText);
        } else {
            changes.deleteAttributes((IAtsObject)this.workItem, (AttributeTypeToken)notesAttrType);
        }
        changes.execute();
    }

    private String getNoteText() {
        return (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)notesAttrType, (Object)"");
    }

    private String performEmulate() {
        return "this is the note";
    }

    private String performUi() {
        EntryDialog ed = new EntryDialog("Add/Update Workflow Notes", "Enter Workflow Notes");
        ed.setFillVertically(true);
        ed.setEntry(this.getNoteText());
        String noteTxt = "";
        if (ed.open() == 0) {
            noteTxt = ed.getEntry();
        }
        return noteTxt;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.NOTE);
    }

    public void setEmulateUi(boolean emulate) {
        this.emulate = emulate;
    }
}

