/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Date;
import java.util.HashSet;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class StartDateColumn
extends XViewerAtsAttributeValueColumn {
    public static StartDateColumn instance = new StartDateColumn();

    public static StartDateColumn getInstance() {
        return instance;
    }

    private StartDateColumn() {
        super((AttributeTypeToken)AtsAttributeTypes.StartDate, "ats.column.startDate", AtsAttributeTypes.StartDate.getUnqualifiedName(), 80, XViewerAlign.Left, false, SortDataType.Date, true, "");
    }

    @Override
    public StartDateColumn copy() {
        StartDateColumn newXCol = new StartDateColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            return StartDateColumn.getDateStr(element);
        }
        catch (OseeCoreException ex) {
            LogUtil.getCellExceptionString((Exception)((Object)ex));
            return "";
        }
    }

    public static Date getDate(Object object) {
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            return StartDateColumn.getDate(AtsApiService.get().getWorkItemService().getFirstTeam(object));
        }
        if (object instanceof AbstractWorkflowArtifact) {
            return (Date)((AbstractWorkflowArtifact)((Object)object)).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.StartDate, null);
        }
        return null;
    }

    public static String getDateStr(Object object) {
        HashSet<String> strs = new HashSet<String>();
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                Date date = StartDateColumn.getDate(team);
                if (date == null) {
                    strs.add("");
                    continue;
                }
                strs.add(DateUtil.getMMDDYY((Date)StartDateColumn.getDate(team)));
            }
            return Collections.toString((String)";", strs);
        }
        return DateUtil.getMMDDYY((Date)StartDateColumn.getDate(object));
    }

    @Override
    public Object getBackingData(Object element, XViewerColumn xCol, int columnIndex) throws Exception {
        return StartDateColumn.getDate(element);
    }
}

