/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.populate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoCscis;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.workflow.transition.TeamWorkFlowManager;
import org.eclipse.osee.ats.ide.demo.config.DemoDbUtil;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.demo.populate.IPopulateDemoDatabase;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class Pdd22CreateUnCommittedConflictedAction
implements IPopulateDemoDatabase {
    private ActionResult actionResult;

    @Override
    public void run() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getClass().getName());
        Collection<IAtsActionableItem> aias = DemoDbUtil.getActionableItems(new ArtifactToken[]{DemoArtifactToken.SAW_Requirements_AI});
        Date createdDate = new Date();
        AtsUser createdBy = AtsApiService.get().getUserService().getCurrentUser();
        String priority = "3";
        this.actionResult = AtsApiService.get().getActionService().createAction(null, DemoArtifactToken.SAW_UnCommitedConflicted_Req_TeamWf.getName(), "Problem with the Diagram View", ChangeTypes.Problem, priority, false, null, aias, createdDate, createdBy, Arrays.asList(new ArtifactTokenActionListener()), changes);
        for (IAtsTeamWorkflow teamWf : this.actionResult.getTeamWfs()) {
            TeamWorkFlowManager dtwm = new TeamWorkFlowManager(teamWf, (AtsApi)AtsApiService.get(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck, TransitionOption.OverrideTransitionValidityCheck});
            Result result = dtwm.transitionTo(toState, (AtsUser)teamWf.getAssignees().iterator().next(), false, changes);
            if (result.isFalse()) {
                throw new OseeCoreException("Error transitioning [%s] to state [%s]: [%s]", new Object[]{teamWf.toStringWithId(), toState.getName(), result.getText()});
            }
            if (!teamWf.isCompletedOrCancelled()) {
                teamWf.getStateMgr().setAssignees(AtsApiService.get().getTeamDefinitionService().getLeads(teamWf.getTeamDefinition()));
            }
            this.setVersion(teamWf, (ArtifactToken)DemoArtifactToken.SAW_Bld_2, changes);
            changes.add((Object)teamWf);
        }
        changes.execute();
        TeamWorkFlowArtifact reqTeamArt = null;
        for (IAtsTeamWorkflow teamWf : this.actionResult.getTeamWfs()) {
            if (!teamWf.getTeamDefinition().getName().contains("Req")) continue;
            reqTeamArt = (TeamWorkFlowArtifact)teamWf.getStoreObject();
        }
        if (reqTeamArt == null) {
            throw new OseeArgumentException("Can't locate Req team.", new Object[0]);
        }
        Result result = AtsApiService.get().getBranchServiceIde().createWorkingBranch_Validate(reqTeamArt);
        if (result.isFalse()) {
            throw new OseeArgumentException("Error creating working branch: " + result.getText(), new Object[0]);
        }
        AtsApiService.get().getBranchServiceIde().createWorkingBranch_Create((IAtsTeamWorkflow)reqTeamArt, true);
        Artifact branchArtifact = DemoDbUtil.getArtTypeRequirements(this.isDebug(), CoreArtifactTypes.SoftwareRequirementMsWord, DemoDbUtil.HAPTIC_CONSTRAINTS_REQ, (BranchId)reqTeamArt.getWorkingBranch()).iterator().next();
        branchArtifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.CSCI, (Object)DemoCscis.Interface.name());
        branchArtifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
        Artifact comArt = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.Component, (String)DemoSubsystems.Robot_API.name(), (BranchId)reqTeamArt.getWorkingBranch());
        branchArtifact.addRelation(CoreRelationTypes.Allocation_Component, comArt);
        branchArtifact.persist(this.getClass().getSimpleName());
        Artifact parentArtifact = DemoDbUtil.getArtTypeRequirements(this.isDebug(), CoreArtifactTypes.SoftwareRequirementMsWord, DemoDbUtil.HAPTIC_CONSTRAINTS_REQ, (BranchId)reqTeamArt.getWorkingBranch()).iterator().next();
        parentArtifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.CSCI, (Object)DemoCscis.Navigation.name());
        parentArtifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Cognitive_Decision_Aiding.name());
        parentArtifact.persist(this.getClass().getSimpleName());
    }

    private class ArtifactTokenActionListener
    implements INewActionListener {
        private ArtifactTokenActionListener() {
        }

        public ArtifactToken getArtifactToken(List<IAtsActionableItem> applicableAis) {
            return DemoArtifactToken.SAW_UnCommitedConflicted_Req_TeamWf;
        }
    }
}

