/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.blam;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.define.ide.traceability.ResourceIdentifier;
import org.eclipse.osee.define.ide.traceability.TestUnitTagger;
import org.eclipse.osee.define.ide.utility.IResourceHandler;
import org.eclipse.osee.define.ide.utility.IResourceLocator;
import org.eclipse.osee.define.ide.utility.UriResourceContentFinder;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class RemoveObjectIdsFromTraceUnits
extends AbstractBlam {
    public String getName() {
        return "Remove ObjectIds from Tests";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.TRACE);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.TRACE);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.TRACE);
    }

    public String getDescriptionUsage() {
        return "Removes ObjectIds from files/folders selected.";
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select File Or Folder (file can have a list of folders separated by newlines)\"/>");
        builder.append("<XWidget xwidgetType=\"XFileSelectionDialog\" displayName=\"Select File\" />");
        builder.append("<XWidget xwidgetType=\"XDirectorySelectionDialog\" displayName=\"Select Folder\" />");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Include Sub-Folders\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"File With Embedded Paths\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    private void checkPath(String filePath, String type) {
        if (!Strings.isValid((String)filePath)) {
            throw new OseeArgumentException("Please enter a valid %s path", new Object[]{type});
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new OseeArgumentException("%s path [%s] is not accessible", new Object[]{type, filePath});
        }
    }

    private URI getSourceURI(VariableMap variableMap) {
        String filePath = variableMap.getString("Select File");
        String folderPath = variableMap.getString("Select Folder");
        String pathToUse = null;
        if (Strings.isValid((String)folderPath) && Strings.isValid((String)filePath)) {
            throw new OseeArgumentException("Enter file or folder but not both", new Object[0]);
        }
        if (Strings.isValid((String)folderPath)) {
            this.checkPath(folderPath, "folder");
            pathToUse = folderPath;
        } else {
            this.checkPath(filePath, "file");
            pathToUse = filePath;
        }
        return new File(pathToUse).toURI();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        URI source = this.getSourceURI(variableMap);
        boolean isRecursionAllowed = variableMap.getBoolean("Include Sub-Folders");
        boolean isFileWithMultiplePaths = variableMap.getBoolean("File With Embedded Paths");
        monitor.beginTask(this.getName(), Integer.MAX_VALUE);
        UriResourceContentFinder resourceFinder = new UriResourceContentFinder(Arrays.asList(source), isRecursionAllowed, isFileWithMultiplePaths);
        resourceFinder.addLocator(new IResourceLocator(){

            @Override
            public boolean isValidDirectory(IFileStore fileStore) {
                return true;
            }

            @Override
            public boolean isValidFile(IFileStore fileStore) {
                return fileStore.getName().endsWith(".java");
            }

            @Override
            public boolean hasValidContent(CharBuffer fileBuffer) {
                return true;
            }

            @Override
            public ResourceIdentifier getIdentifier(IFileStore fileStore, CharBuffer fileBuffer) throws Exception {
                return new ResourceIdentifier(fileStore.getName());
            }
        }, new TraceRemover());
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, Integer.MAX_VALUE);
        resourceFinder.execute((IProgressMonitor)subMonitor);
        monitor.done();
    }

    private static final class TraceRemover
    implements IResourceHandler {
        private final TestUnitTagger tagger = TestUnitTagger.getInstance();

        private TraceRemover() {
        }

        @Override
        public void onResourceFound(URI uriPath, String name, CharBuffer fileBuffer) {
            try {
                this.tagger.removeSourceTag(uriPath);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }
}

