/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.word;

import java.util.Collection;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.framework.jdk.core.util.xml.SimpleNamespaceContext;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UpdateBookmarkIds {
    private static final String WORD_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><?mso-application progid=\"Word.Document\"?><w:wordDocument xmlns:aml=\"http://schemas.microsoft.com/aml/2001/core\" xmlns:dt=\"uuid:C2F41010-65B3-11d1-A29F-00AA00C14882\" xmlns:ve=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.microsoft.com/office/word/2003/wordml\" xmlns:wx=\"http://schemas.microsoft.com/office/word/2003/auxHint\" xmlns:wsp=\"http://schemas.microsoft.com/office/word/2003/wordml/sp2\" xmlns:sl=\"http://schemas.microsoft.com/schemaLibrary/2003/core\" w:macrosPresent=\"no\" w:embeddedObjPresent=\"no\" w:ocxPresent=\"no\" xml:space=\"preserve\">";
    private static final String WORD_BOOKMARK_START = "Word.Bookmark.Start";
    private static final String WORD_BOOKMARK_END = "Word.Bookmark.End";
    private static final String WORD_BODY_START = "<w:body>";
    private static final String WORD_BODY_END = "</w:body>";
    private static final String WORD_DOC_END = "</w:wordDocument>";
    private static final String WORD_AML_ID_ATTRIBUTE = "aml:id";
    private static final String XPATH_EXPRESSION = "//aml:annotation[@w:type='Word.Bookmark.End' or @w:type='Word.Bookmark.Start']";
    private int bookMarkId;

    public UpdateBookmarkIds(int startBookMarkId) {
        this.bookMarkId = startBookMarkId;
    }

    private boolean isStartNode(Node node) {
        return this.isNode(WORD_BOOKMARK_START, node);
    }

    private boolean isEndNode(Node node) {
        return this.isNode(WORD_BOOKMARK_END, node);
    }

    private boolean isNode(String typeToCheck, Node node) {
        boolean result = false;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String typeName = element.getAttribute("w:type");
            result = Strings.isValid((String)typeName) && typeToCheck.equals(typeName);
        }
        return result;
    }

    private String stripOffBodyTag(String original) {
        int startIndex = original.indexOf(WORD_BODY_START);
        startIndex = startIndex < 0 ? 0 : (startIndex += WORD_BODY_START.length());
        int stopIndex = original.indexOf(WORD_BODY_END);
        if (stopIndex < 0) {
            stopIndex = original.length();
        }
        return original.substring(startIndex, stopIndex);
    }

    public String fixTags(String content) {
        String toReturn = content;
        boolean changesMade = false;
        try {
            Document document = Jaxp.readXmlDocumentNamespaceAware((String)("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><?mso-application progid=\"Word.Document\"?><w:wordDocument xmlns:aml=\"http://schemas.microsoft.com/aml/2001/core\" xmlns:dt=\"uuid:C2F41010-65B3-11d1-A29F-00AA00C14882\" xmlns:ve=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.microsoft.com/office/word/2003/wordml\" xmlns:wx=\"http://schemas.microsoft.com/office/word/2003/auxHint\" xmlns:wsp=\"http://schemas.microsoft.com/office/word/2003/wordml/sp2\" xmlns:sl=\"http://schemas.microsoft.com/schemaLibrary/2003/core\" w:macrosPresent=\"no\" w:embeddedObjPresent=\"no\" w:ocxPresent=\"no\" xml:space=\"preserve\"><w:body>" + content + WORD_BODY_END + WORD_DOC_END));
            Element element = document.getDocumentElement();
            XPath xPath = Jaxp.createXPath();
            SimpleNamespaceContext context = new SimpleNamespaceContext();
            Xml.addNamespacesForWordMarkupLanguage((XPath)xPath, (SimpleNamespaceContext)context);
            Collection nodes = Jaxp.selectNodesViaXPath((XPath)xPath, (Node)element, (String)XPATH_EXPRESSION);
            HashMap<Integer, Integer> oldToNewAmlIds = new HashMap<Integer, Integer>();
            for (Node node : nodes) {
                if (!this.isStartNode(node) && !this.isEndNode(node)) continue;
                changesMade = true;
                Node amlIdNode = node.getAttributes().getNamedItem(WORD_AML_ID_ATTRIBUTE);
                if (amlIdNode == null) continue;
                String amlIdStr = amlIdNode.getNodeValue();
                Integer oldAmlId = Integer.valueOf(amlIdStr);
                Integer newAmlId = (Integer)oldToNewAmlIds.get(oldAmlId);
                if (newAmlId == null) {
                    newAmlId = this.incrementBookmarkId();
                    oldToNewAmlIds.put(oldAmlId, newAmlId);
                }
                ((Element)node).setAttribute(WORD_AML_ID_ATTRIBUTE, String.valueOf(newAmlId));
            }
            if (changesMade) {
                toReturn = this.stripOffBodyTag(Jaxp.xmlToString((Document)document, (boolean)false));
            }
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return toReturn;
    }

    private int incrementBookmarkId() {
        ++this.bookMarkId;
        if (this.bookMarkId >= Integer.MAX_VALUE) {
            this.bookMarkId = 0;
        }
        return this.bookMarkId;
    }
}

