/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.transaction;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitorImpl;

public final class TxMonitorCache<K> {
    private final Map<K, Map<String, WeakReference<TxMonitorImpl.MonitoredTx>>> txMap = new ConcurrentHashMap<K, Map<String, WeakReference<TxMonitorImpl.MonitoredTx>>>();

    public boolean contains(K key) {
        return this.txMap.containsKey(key);
    }

    public boolean contains(K key, String uuid) {
        return this.getTx(key, uuid) != null;
    }

    public void putTx(K key, TxMonitorImpl.MonitoredTx tx) {
        Map<String, WeakReference<TxMonitorImpl.MonitoredTx>> data = this.txMap.get(key);
        if (data == null) {
            data = new ConcurrentHashMap<String, WeakReference<TxMonitorImpl.MonitoredTx>>();
            this.txMap.put(key, data);
        }
        data.put(tx.getUuid(), new WeakReference<TxMonitorImpl.MonitoredTx>(tx));
        this.manageReferences();
    }

    public void removeTx(K key, String uuid) {
        Map<String, WeakReference<TxMonitorImpl.MonitoredTx>> data = this.txMap.get(key);
        if (data != null) {
            data.remove(uuid);
        }
        this.manageReferences();
    }

    private void manageReferences() {
        HashSet<K> toRemove = new HashSet<K>();
        for (Map.Entry<K, Map<String, WeakReference<TxMonitorImpl.MonitoredTx>>> entry : this.txMap.entrySet()) {
            Map<String, WeakReference<TxMonitorImpl.MonitoredTx>> data = entry.getValue();
            this.manageReferences(data);
            if (!data.isEmpty()) continue;
            toRemove.add(entry.getKey());
        }
        for (Map.Entry<K, Map<String, WeakReference<TxMonitorImpl.MonitoredTx>>> item : toRemove) {
            this.txMap.remove(item);
        }
    }

    private void manageReferences(Map<?, WeakReference<TxMonitorImpl.MonitoredTx>> data) {
        HashSet toRemove = new HashSet();
        for (Map.Entry<?, WeakReference<TxMonitorImpl.MonitoredTx>> entry : data.entrySet()) {
            WeakReference<TxMonitorImpl.MonitoredTx> reference = entry.getValue();
            if (reference != null && reference.get() != null) continue;
            toRemove.add(entry.getKey());
        }
        for (Map.Entry<Object, WeakReference<TxMonitorImpl.MonitoredTx>> item : toRemove) {
            data.remove(item);
        }
    }

    public TxMonitorImpl.MonitoredTx getTx(K key, String uuid) {
        TxMonitorImpl.MonitoredTx toReturn = null;
        Map<String, WeakReference<TxMonitorImpl.MonitoredTx>> data = this.txMap.get(key);
        if (data != null) {
            WeakReference<TxMonitorImpl.MonitoredTx> reference = data.get(uuid);
            if (reference != null) {
                toReturn = (TxMonitorImpl.MonitoredTx)reference.get();
            }
            if (toReturn == null) {
                data.remove(uuid);
            }
            if (data.isEmpty()) {
                this.txMap.remove(key);
            }
        }
        return toReturn;
    }

    public List<TxMonitorImpl.MonitoredTx> getTxs(K key) {
        ArrayList<TxMonitorImpl.MonitoredTx> txs = new ArrayList<TxMonitorImpl.MonitoredTx>();
        Map<String, WeakReference<TxMonitorImpl.MonitoredTx>> data = this.txMap.get(key);
        if (data != null) {
            HashSet<String> toRemove = new HashSet<String>();
            for (Map.Entry<String, WeakReference<TxMonitorImpl.MonitoredTx>> entry : data.entrySet()) {
                WeakReference<TxMonitorImpl.MonitoredTx> reference = entry.getValue();
                if (reference != null) {
                    TxMonitorImpl.MonitoredTx tx = (TxMonitorImpl.MonitoredTx)reference.get();
                    if (tx != null) {
                        txs.add(tx);
                        continue;
                    }
                    toRemove.add(entry.getKey());
                    continue;
                }
                toRemove.add(entry.getKey());
            }
            for (Map.Entry<String, WeakReference<TxMonitorImpl.MonitoredTx>> entry : toRemove) {
                data.remove(entry);
            }
            if (data.isEmpty()) {
                this.txMap.remove(key);
            }
        }
        return txs;
    }
}

