/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;

public class DeleteBranchOperation
extends AbstractOperation {
    private final BranchId branch;

    public DeleteBranchOperation(BranchId branch) {
        super("Delete Branch: " + branch, "org.eclipse.osee.framework.skynet.core");
        this.branch = branch;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        BranchState originalState = BranchManager.getState(this.branch);
        boolean originalArchivedState = BranchManager.isArchived(this.branch);
        ArtifactCache.deCache(this.branch);
        BranchEndpoint proxy = ServiceUtil.getOseeClient().getBranchEndpoint();
        try {
            BranchManager.setState(this.branch, BranchState.DELETE_IN_PROGRESS);
            BranchManager.archiveUnArchiveBranch(this.branch, BranchArchivedState.ARCHIVED);
            OseeEventManager.kickBranchEvent((Object)this, new BranchEvent(BranchEventType.Deleting, this.branch));
            BranchManager.setState(this.branch, BranchState.DELETED);
            OseeEventManager.kickBranchEvent((Object)this, new BranchEvent(BranchEventType.Deleted, this.branch));
            Response res = proxy.logBranchActivity(String.format("Branch Operation Branch State Changed {branchId: %s prevState: %s newState: %s ", this.branch.getId(), originalState, BranchState.DELETED));
            res.close();
        }
        catch (Exception ex) {
            try {
                BranchManager.setState(this.branch, originalState);
                BranchManager.archiveUnArchiveBranch(this.branch, BranchArchivedState.fromBoolean((boolean)originalArchivedState));
            }
            catch (Exception ex2) {
                this.log(ex2);
            }
            throw ex;
        }
    }
}

