/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.impl;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.SocketAddress;
import java.security.KeyPair;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClientFactory;
import org.apache.sshd.client.subsystem.sftp.SimpleSftpClient;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SimpleSftpClientImpl
extends AbstractLoggingBean
implements SimpleSftpClient {
    private SimpleClient clientInstance;
    private SftpClientFactory sftpClientFactory;

    public SimpleSftpClientImpl() {
        this(null);
    }

    public SimpleSftpClientImpl(SimpleClient client) {
        this(client, null);
    }

    public SimpleSftpClientImpl(SimpleClient client, SftpClientFactory sftpClientFactory) {
        this.clientInstance = client;
        this.setSftpClientFactory(sftpClientFactory);
    }

    public SimpleClient getClient() {
        return this.clientInstance;
    }

    public void setClient(SimpleClient client) {
        this.clientInstance = client;
    }

    public SftpClientFactory getSftpClientFactory() {
        return this.sftpClientFactory;
    }

    public void setSftpClientFactory(SftpClientFactory sftpClientFactory) {
        this.sftpClientFactory = sftpClientFactory != null ? sftpClientFactory : SftpClientFactory.instance();
    }

    @Override
    public SftpClient sftpLogin(SocketAddress target, String username, String password) throws IOException {
        return this.createSftpClient((IOFunction<? super SimpleClient, ? extends ClientSession>)((IOFunction)client -> client.sessionLogin(target, username, password)));
    }

    @Override
    public SftpClient sftpLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.createSftpClient((IOFunction<? super SimpleClient, ? extends ClientSession>)((IOFunction)client -> client.sessionLogin(target, username, identity)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SftpClient createSftpClient(IOFunction<? super SimpleClient, ? extends ClientSession> sessionProvider) throws IOException {
        SimpleClient client = this.getClient();
        try (ClientSession session = (ClientSession)sessionProvider.apply((Object)client);){
            SftpClient sftp = this.createSftpClient(session);
            session = null;
            SftpClient sftpClient = sftp;
            return sftpClient;
        }
    }

    protected SftpClient createSftpClient(ClientSession session) throws IOException {
        Exception err = null;
        try {
            SftpClient client = this.sftpClientFactory.createSftpClient(session);
            try {
                return this.createSftpClient(session, client);
            }
            catch (Exception e) {
                err = (Exception)GenericUtils.accumulateException((Throwable)err, (Throwable)e);
                try {
                    client.close();
                }
                catch (Exception t) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("createSftpClient({}) failed ({}) to close client: {}", new Object[]{session, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("createSftpClient(" + session + ") client close failure details", (Throwable)t);
                    }
                    err = (Exception)GenericUtils.accumulateException((Throwable)err, (Throwable)t);
                }
            }
        }
        catch (Exception e) {
            err = (Exception)GenericUtils.accumulateException(err, (Throwable)e);
        }
        this.log.warn("createSftpClient({}) failed ({}) to create session: {}", new Object[]{session, err.getClass().getSimpleName(), err.getMessage()});
        try {
            session.close();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createSftpClient({}) failed ({}) to close session: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("createSftpClient(" + session + ") session close failure details", (Throwable)e);
            }
            err = (Exception)GenericUtils.accumulateException((Throwable)err, (Throwable)e);
        }
        if (err instanceof IOException) {
            throw (IOException)err;
        }
        throw new IOException(err);
    }

    protected SftpClient createSftpClient(ClientSession session, SftpClient client) throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        Class[] interfaces = new Class[]{SftpClient.class};
        return (SftpClient)Proxy.newProxyInstance(loader, interfaces, (proxy, method, args) -> {
            Throwable err = null;
            Object result = null;
            String name = method.getName();
            try {
                result = method.invoke((Object)client, args);
            }
            catch (Throwable t) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("invoke(SftpClient#{}) failed ({}) to execute: {}", new Object[]{name, t.getClass().getSimpleName(), t.getMessage()});
                }
                err = GenericUtils.accumulateException(err, (Throwable)t);
            }
            if ("close".equals(name) && GenericUtils.isEmpty((Object[])args)) {
                try {
                    session.close();
                }
                catch (Throwable t) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("invoke(ClientSession#{}) failed ({}) to execute: {}", new Object[]{name, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    err = GenericUtils.accumulateException((Throwable)err, (Throwable)t);
                }
            }
            if (err != null) {
                throw err;
            }
            return result;
        });
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

