/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal;

import java.util.Map;
import javax.naming.NamingException;
import org.eclipse.osee.authentication.ldap.internal.util.LdapEntry;
import org.eclipse.osee.authentication.ldap.internal.util.VariablePattern;

public class LdapGroup {
    private final LdapEntry ldapEntry;
    private final VariablePattern groupNamePattern;

    public LdapGroup(LdapEntry ldapEntry, VariablePattern groupNamePattern) {
        this.ldapEntry = ldapEntry;
        this.groupNamePattern = groupNamePattern;
    }

    public String getDistinguishedName() throws NamingException {
        return this.ldapEntry.getDistinguishedName();
    }

    public String getGroupName() throws NamingException {
        return LdapGroup.getEntry(this.ldapEntry, this.groupNamePattern);
    }

    public String toString() {
        try {
            return "LdapGroup [groupnName=" + this.getGroupName() + "]";
        }
        catch (NamingException namingException) {
            return "LdapGroup ";
        }
    }

    private static String getEntry(LdapEntry entry, VariablePattern pattern) throws NamingException {
        String toReturn = null;
        if (pattern != null) {
            Map<String, String> values = entry.asMap();
            String value = pattern.expandVariables(values);
            toReturn = value.isEmpty() ? null : value;
        }
        return toReturn;
    }
}

