/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.osgi.framework.ServiceReference;

public final class JaxRsUtils {
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final List<MediaType> HTML_MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList(MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_XHTML_XML_TYPE));

    private JaxRsUtils() {
    }

    public static boolean isHtmlSupported(List<MediaType> acceptableMediaTypes) {
        return !JAXRSUtils.intersectMimeTypes(acceptableMediaTypes, HTML_MEDIA_TYPES, (boolean)false).isEmpty();
    }

    public static String asTemplateValue(String value) {
        String toReturn = "N/A";
        if (Strings.isValid((String)value)) {
            toReturn = value.trim();
            toReturn = toReturn.replaceAll("\r?\n", "<br/>");
        }
        return toReturn;
    }

    public static String getComponentName(ServiceReference<?> reference) {
        return (String)reference.getProperty("component.name");
    }

    public static void checkValid(Application application) throws Exception {
        if (application == null) {
            throw new IllegalStateException("javax.ws.rs.Application service was null");
        }
        if (!JaxRsUtils.hasResources(application)) {
            throw new IllegalStateException("javax.ws.rs.Application had no resources declared");
        }
    }

    public static String getApplicationPath(String componentName, Application application) {
        String applicationPath = JaxRsUtils.getApplicationPath(application);
        return Strings.isValid((String)applicationPath) ? applicationPath : JaxRsUtils.normalize(componentName);
    }

    public static String getApplicationPath(Application application) {
        String toReturn = null;
        Class<?> clazz = application.getClass();
        ApplicationPath applicationPath = clazz.getAnnotation(ApplicationPath.class);
        if (applicationPath != null) {
            toReturn = JaxRsUtils.normalize(applicationPath.value());
        }
        return toReturn;
    }

    public static boolean hasPath(String value) {
        String toCheck = value;
        if (toCheck != null && (toCheck = toCheck.trim()).startsWith("/")) {
            toCheck = toCheck.substring(1);
        }
        return Strings.isValid((String)toCheck);
    }

    private static boolean hasResources(Application app) {
        return !JaxRsUtils.isNullOrEmpty(app.getClasses()) || !JaxRsUtils.isNullOrEmpty(app.getSingletons());
    }

    public static String normalize(String contextName) {
        return contextName != null && !contextName.startsWith("/") ? "/" + contextName : contextName;
    }

    private static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int getInt(Map<String, Object> props, String key, int defaultValue) {
        int toReturn = defaultValue;
        String value = JaxRsUtils.get(props, key, null);
        if (value != null && Strings.isNumeric((String)value)) {
            toReturn = Integer.parseInt(value);
        }
        return toReturn;
    }

    public static long getLong(Map<String, Object> props, String key, long defaultValue) {
        long toReturn = defaultValue;
        String value = JaxRsUtils.get(props, key, null);
        if (value != null && Strings.isNumeric((String)value)) {
            toReturn = Long.parseLong(value);
        }
        return toReturn;
    }

    public static boolean getBoolean(Map<String, Object> props, String key, boolean defaultValue) {
        boolean toReturn = defaultValue;
        String value = JaxRsUtils.get(props, key, null);
        if (value != null) {
            toReturn = Boolean.parseBoolean(value);
        }
        return toReturn;
    }

    public static String get(Map<String, Object> props, String key, String defaultValue) {
        Object object;
        String toReturn = defaultValue;
        Object object2 = object = props != null ? props.get(key) : null;
        if (object != null) {
            toReturn = String.valueOf(object);
        }
        return toReturn;
    }

    public static Response.StatusType newStatusType(final int code, final Response.Status.Family family, final String reason) {
        return new Response.StatusType(){

            public int getStatusCode() {
                return code;
            }

            public Response.Status.Family getFamily() {
                return family;
            }

            public String getReasonPhrase() {
                return reason;
            }
        };
    }
}

