/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.Transaction;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TransactionEndpointImpl
implements TransactionEndpoint {
    private final OrcsApi orcsApi;
    @Context
    private UriInfo uriInfo;

    public TransactionEndpointImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public List<Transaction> getAllTxs() {
        return OrcsRestUtil.asTransactions((ResultSet<? extends TransactionReadable>)this.orcsApi.getTransactionFactory().getAllTxs());
    }

    public Transaction getTx(TransactionId tx) {
        return OrcsRestUtil.asTransaction(this.orcsApi.getTransactionFactory().getTx(tx));
    }

    public TransactionResult create(TransactionBuilder tx) {
        TransactionToken token = tx.commit();
        TransactionResult result = new TransactionResult();
        result.setTx(token);
        XResultData resultData = new XResultData();
        resultData.setTxId(token.getIdString());
        resultData.setIds(tx.getTxDataReadables().stream().map(readable -> readable.getIdString()).collect(Collectors.toList()));
        result.setResults(resultData);
        return result;
    }

    public List<ChangeItem> compareTxs(TransactionId txId1, TransactionId txId2) {
        return this.orcsApi.getTransactionFactory().compareTxs(txId1, txId2);
    }

    public Response setTxComment(TransactionId txId, String comment) {
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().setTxComment(txId, comment));
    }

    public Response purgeTxs(String txIds) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().purgeTxs(txIds));
    }

    public Response purgeUnusedBackingDataAndTransactions() {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        this.orcsApi.getTransactionFactory().purgeUnusedBackingDataAndTransactions();
        return Response.ok().build();
    }

    public Response replaceWithBaselineTxVersion(UserId userId, BranchId branchId, TransactionId txId, ArtifactId artId, String comment) {
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().replaceWithBaselineTxVersion(userId, branchId, txId, artId, comment));
    }

    public List<ChangeItem> getArtifactHistory(ArtifactId artifact, BranchId branch) {
        return this.orcsApi.getTransactionFactory().getArtifactHistory(artifact, branch);
    }
}

