/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.workflow.IAtsTask;

public class TaskNameData {
    private String codeTest = "";
    private String partition = "";
    private String reqName = "";
    private String wcafeType = "";
    private String addDetails = "";
    private boolean cdb = false;
    private boolean isWcafe = false;
    private boolean deleted = false;
    private static final Map<IAtsTask, TaskNameData> taskNameDataCache = new HashMap<IAtsTask, TaskNameData>();
    private static final Pattern requirementPattern = Pattern.compile("^(.*?) +\"(.*?)\" +for +\"(.*?)\"(.*)");
    private static final Pattern wcafeRequirementPattern_newFormat = Pattern.compile("^(.*?) +\"(.*?)\" +for (Warning|Caution|Advisory|Fault|Exceedance) +\"(.*?)\"");
    private static final Pattern wcaCdbFaultsPattern = Pattern.compile("^(.*?) +\"(.*?)\" +for +(.*?)$");

    public TaskNameData(IAtsTask task) {
        boolean didMatchWcafeReqPattern = false;
        Matcher m = wcafeRequirementPattern_newFormat.matcher(task.getName());
        if (m.find()) {
            this.codeTest = m.group(1);
            this.partition = m.group(2);
            this.wcafeType = m.group(3);
            this.reqName = m.group(4);
            didMatchWcafeReqPattern = true;
            this.isWcafe = true;
        }
        if ((m = requirementPattern.matcher(task.getName())).find() && !didMatchWcafeReqPattern) {
            this.codeTest = m.group(1);
            this.partition = m.group(2);
            this.reqName = m.group(3);
            this.setAddDetails(m.group(4));
        }
        if ((m = wcaCdbFaultsPattern.matcher(task.getName())).find()) {
            this.codeTest = m.group(1);
            this.partition = m.group(2);
            String str = m.group(3);
            if (str.equals("CDB")) {
                this.cdb = true;
            }
        }
    }

    public static TaskNameData get(IAtsTask task) {
        if (!taskNameDataCache.containsKey(task)) {
            TaskNameData tnd = new TaskNameData(task);
            taskNameDataCache.put(task, tnd);
        }
        return taskNameDataCache.get(task);
    }

    public String toString() {
        return "Type: " + this.getCodeTest() + "\nPartition: " + this.getPartition() + "\nReq: " + this.getReqName();
    }

    public boolean isRequirement() {
        return !this.cdb && !this.reqName.equals("");
    }

    public boolean isWcafe() {
        return this.isWcafe;
    }

    public String getWcafeType() {
        return this.wcafeType;
    }

    public boolean isCdb() {
        return this.cdb;
    }

    public void setCdb(boolean cdb) {
        this.cdb = cdb;
    }

    public String getCodeTest() {
        return this.codeTest;
    }

    public void setCodeTest(String codeTest) {
        this.codeTest = codeTest;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getReqName() {
        return this.reqName;
    }

    public void setReqName(String reqName) {
        this.reqName = reqName;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getAddDetails() {
        return this.addDetails;
    }

    public void setAddDetails(String addDetails) {
        this.addDetails = addDetails;
    }
}

