/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.osee.framework.jdk.core.type.IVariantData;
import org.eclipse.osee.framework.jdk.core.type.VariantData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.internal.JdbcConnectionImpl;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;
import org.eclipse.osee.jdbc.internal.JdbcConnectionProvider;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public final class JdbcStatementImpl
implements JdbcStatement {
    private final JdbcConnectionInfo dbInfo;
    private ResultSet rSet;
    private PreparedStatement preparedStatement;
    private CallableStatement callableStatement;
    private JdbcConnectionImpl connection;
    private final boolean autoClose;
    private final JdbcConnectionProvider connectionProvider;
    private final int resultSetType;
    private final int resultSetConcurrency;

    public JdbcStatementImpl(JdbcConnectionInfo dbInfo, JdbcConnectionProvider connectionProvider, JdbcConnectionImpl connection) {
        this(dbInfo, connectionProvider, connection, connection == null);
    }

    public JdbcStatementImpl(JdbcConnectionInfo dbInfo, JdbcConnectionProvider connectionProvider, JdbcConnectionImpl connection, boolean autoClose) {
        this(dbInfo, connectionProvider, connection, autoClose, 1003, 1007);
    }

    public JdbcStatementImpl(JdbcConnectionInfo dbInfo, JdbcConnectionProvider connectionProvider) {
        this(dbInfo, connectionProvider, null);
    }

    public JdbcStatementImpl(JdbcConnectionInfo dbInfo, JdbcConnectionProvider connectionProvider, int resultSetType, int resultSetConcurrency) {
        this(dbInfo, connectionProvider, null, true, resultSetType, resultSetConcurrency);
    }

    public JdbcStatementImpl(JdbcConnectionInfo dbInfo, JdbcConnectionProvider connectionProvider, JdbcConnectionImpl connection, boolean autoClose, int resultSetType, int resultSetConcurrency) {
        this.dbInfo = dbInfo;
        this.autoClose = autoClose;
        this.connection = connection;
        this.connectionProvider = connectionProvider;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    @Override
    public void runPreparedQuery(String query, Object ... data) throws JdbcException {
        this.runPreparedQuery(1000, query, data);
    }

    @Override
    public void runPreparedQueryWithMaxFetchSize(String query, Object ... data) {
        this.runPreparedQuery(10000, query, data);
    }

    @Override
    public void runPreparedQuery(int fetchSize, String query, Object ... data) throws JdbcException {
        try {
            this.allowReuse();
            this.preparedStatement = this.connection.prepareStatement(query, this.resultSetType, this.resultSetConcurrency);
            this.preparedStatement.setFetchSize(Math.min(fetchSize, 10000));
            JdbcUtil.setInputParametersForStatement(this.preparedStatement, data);
            this.rSet = this.preparedStatement.executeQuery();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public boolean next() throws JdbcException {
        if (this.rSet != null) {
            try {
                return this.rSet.next();
            }
            catch (SQLException ex) {
                throw JdbcException.newJdbcException(ex);
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.closePreviousResources();
        if (this.autoClose && this.connection != null) {
            try {
                try {
                    if (!this.connection.isClosed()) {
                        this.connection.close();
                    }
                }
                catch (Exception exception) {
                    this.connection = null;
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    private void allowReuse() throws JdbcException {
        this.closePreviousResources();
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection(this.dbInfo);
        }
    }

    private void closePreviousResources() {
        block19: {
            block17: {
                try {
                    try {
                        if (this.rSet != null) {
                            this.rSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.rSet = null;
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    this.rSet = null;
                    throw throwable;
                }
                this.rSet = null;
            }
            try {
                try {
                    if (this.preparedStatement != null && !this.preparedStatement.isClosed()) {
                        this.preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    this.preparedStatement = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                this.preparedStatement = null;
                throw throwable;
            }
            this.preparedStatement = null;
        }
        try {
            try {
                if (this.callableStatement != null && !this.callableStatement.isClosed()) {
                    this.callableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                this.callableStatement = null;
            }
        }
        finally {
            this.callableStatement = null;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws JdbcException {
        try {
            return this.rSet.getBinaryStream(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws JdbcException {
        try {
            return this.rSet.getAsciiStream(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public String getString(String columnName) throws JdbcException {
        try {
            return this.rSet.getString(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public float getFloat(String columnName) throws JdbcException {
        try {
            return this.rSet.getFloat(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public long getLong(String columnName) throws JdbcException {
        try {
            return this.rSet.getLong(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public int getInt(String columnName) throws JdbcException {
        try {
            return this.rSet.getInt(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws JdbcException {
        try {
            return this.rSet.getBoolean(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public int getInt(int columnIndex) throws JdbcException {
        try {
            return this.rSet.getInt(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public int getCallableInt(int columnIndex) throws JdbcException {
        try {
            return this.callableStatement.getInt(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public double getCallableDouble(int columnIndex) throws JdbcException {
        try {
            return this.callableStatement.getDouble(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public long getLong(int columnIndex) throws JdbcException {
        try {
            return this.rSet.getLong(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public String getString(int columnIndex) throws JdbcException {
        try {
            return this.rSet.getString(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws JdbcException {
        try {
            return this.rSet.getTimestamp(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws JdbcException {
        try {
            return this.rSet.getBigDecimal(name);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public Time getTime(String name) throws JdbcException {
        try {
            return this.rSet.getTime(name);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public double getDouble(String columnName) throws JdbcException {
        try {
            return this.rSet.getDouble(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public Date getDate(String columnName) throws JdbcException {
        try {
            return this.rSet.getDate(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public boolean wasNull() throws JdbcException {
        try {
            return this.rSet.wasNull();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public int getColumnCount() throws JdbcException {
        try {
            return this.rSet.getMetaData().getColumnCount();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public String getColumnName(int columnIndex) throws JdbcException {
        try {
            return this.rSet.getMetaData().getColumnName(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public int getColumnType(int columnIndex) throws JdbcException {
        try {
            return this.rSet.getMetaData().getColumnType(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws JdbcException {
        try {
            return this.rSet.getMetaData().getColumnTypeName(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws JdbcException {
        try {
            return this.rSet.getObject(columnIndex);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public Object getObject(String columnName) throws JdbcException {
        try {
            return this.rSet.getObject(columnName);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public int getRowCount() throws JdbcException {
        try {
            this.rSet.last();
            return this.rSet.getRow();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public boolean isNullable(int columnIndex) throws JdbcException {
        try {
            return this.rSet.getMetaData().isNullable(columnIndex) == 1;
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public void updateObject(String columnName, Object value) throws JdbcException {
        try {
            this.rSet.updateObject(columnName, value);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public void updateRow() throws JdbcException {
        try {
            this.rSet.updateRow();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public void cancel() throws JdbcException {
        try {
            if (this.preparedStatement != null && !this.preparedStatement.isClosed()) {
                this.preparedStatement.cancel();
            }
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
        try {
            if (this.callableStatement != null && !this.callableStatement.isClosed()) {
                this.callableStatement.cancel();
            }
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public IVariantData parse() {
        VariantData toReturn = new VariantData();
        int numberOfColumns = this.getColumnCount() + 1;
        int index = 1;
        while (index < numberOfColumns) {
            int type = this.getColumnType(index);
            String name = this.getColumnName(index);
            String upperCasedName = name.toUpperCase();
            switch (type) {
                case -2: 
                case 2005: {
                    InputStream inputStream = this.getAsciiStream(name);
                    toReturn.put(upperCasedName, JdbcStatementImpl.streamToByteArray(inputStream));
                    break;
                }
                case 2004: {
                    InputStream blobStream = this.getBinaryStream(name);
                    toReturn.put(upperCasedName, JdbcStatementImpl.streamToByteArray(blobStream));
                    break;
                }
                case 93: {
                    Timestamp timeStamp = this.getTimestamp(name);
                    if (timeStamp == null) break;
                    toReturn.put(upperCasedName, timeStamp.getTime());
                    break;
                }
                case 91: {
                    Date date = this.getDate(name);
                    if (date == null) break;
                    toReturn.put(upperCasedName, date.getTime());
                    break;
                }
                default: {
                    String value = this.getString(name);
                    if (Strings.isValid((String)value)) {
                        value = value.trim();
                    }
                    toReturn.put(upperCasedName, this.getString(name));
                }
            }
            ++index;
        }
        return toReturn;
    }

    private static byte[] streamToByteArray(InputStream inputStream) {
        byte[] toReturn;
        if (inputStream != null) {
            try {
                toReturn = Lib.inputStreamToBytes((InputStream)inputStream);
            }
            catch (IOException ex) {
                throw JdbcException.newJdbcException(ex);
            }
        } else {
            toReturn = new byte[]{};
        }
        return toReturn;
    }
}

