/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization.util;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.osee.define.rest.synchronization.util.HierarchyTreeNode;

public class HierarchyTree<K, V> {
    Map<K, HierarchyTreeNode<K, V>> nodeMap = new HashMap<K, HierarchyTreeNode<K, V>>();
    HierarchyTreeNode<K, V> rootNode = null;
    HierarchyTreeNode<K, V> currNode = null;

    public boolean containsKey(K key) {
        assert (Objects.nonNull(key));
        return this.nodeMap.containsKey(key);
    }

    public boolean containsKey(K parentKey, K childKey) {
        assert (Objects.nonNull(parentKey) && Objects.nonNull(childKey));
        HierarchyTreeNode<K, V> child = this.nodeMap.get(childKey);
        return Objects.nonNull(child) ? (child.hasParent() ? child.getParent().getKey().equals(parentKey) : false) : false;
    }

    public V get(K key) {
        assert (Objects.nonNull(key));
        HierarchyTreeNode<K, V> hierarchyTreeNode = this.nodeMap.get(key);
        if (hierarchyTreeNode == null) {
            return null;
        }
        return hierarchyTreeNode.getValue();
    }

    public Optional<V> get(K parentKey, K childKey) {
        assert (Objects.nonNull(parentKey) && Objects.nonNull(childKey));
        HierarchyTreeNode<K, V> child = this.nodeMap.get(childKey);
        return child.hasParent() ? (child.getParent().getKey().equals(parentKey) ? Optional.of(child.getValue()) : Optional.empty()) : Optional.empty();
    }

    public void setCurrent(K key) {
        assert (Objects.nonNull(key));
        HierarchyTreeNode<K, V> hierarchyTreeNode = this.nodeMap.get(key);
        if (hierarchyTreeNode == null) {
            throw new RuntimeException("HierarchyTree::setCurrent: Node not found.");
        }
        this.currNode = hierarchyTreeNode;
        hierarchyTreeNode.setCurrent();
    }

    public void forEachChildKey(Consumer<? super K> action) {
        this.currNode.iteratorKeys().forEachRemaining(action);
    }

    public void forEachChildValue(Consumer<? super V> action) {
        this.currNode.iteratorValues().forEachRemaining(action);
    }

    public void put(K key, HierarchyTreeNode<K, V> node) {
        this.nodeMap.put(key, node);
    }

    public void setRoot(K key, V value) {
        if (this.rootNode != null) {
            throw new RuntimeException("Root node is already set");
        }
        HierarchyTreeNode<K, V> rootNode = new HierarchyTreeNode<K, V>(this, key, value);
        this.rootNode = rootNode;
        this.nodeMap.put(key, rootNode);
    }

    public void insertFirst(K parentKey, K key, V value) {
        HierarchyTreeNode<K, V> parent = this.nodeMap.get(parentKey);
        if (parent == null) {
            throw new RuntimeException("Parent node not found");
        }
        parent.insertFirst(key, value);
    }

    public void insertLast(K parentKey, K key, V value) {
        HierarchyTreeNode<K, V> parentNode = this.nodeMap.get(parentKey);
        if (parentNode == null) {
            throw new RuntimeException("Parent node not found");
        }
        parentNode.insertLast(key, value);
    }

    public void insertBefore(K parentKey, K key, V value) {
        HierarchyTreeNode<K, V> parent = this.nodeMap.get(parentKey);
        if (parent == null) {
            throw new RuntimeException("Parent node not found");
        }
        parent.insertBefore(key, value);
    }

    public void insertAfter(K parentKey, K key, V value) {
        HierarchyTreeNode<K, V> parent = this.nodeMap.get(parentKey);
        if (parent == null) {
            throw new RuntimeException("Parent node not found");
        }
        parent.insertAfter(key, value);
    }

    public HierarchyTreeNode<K, V> root() {
        return this.rootNode;
    }

    public HierarchyTreeNode<K, V> getAssertNotNull(K key) {
        HierarchyTreeNode<K, V> node = this.nodeMap.get(key);
        if (node == null) {
            throw new RuntimeException("Node not found");
        }
        return node;
    }

    public HierarchyTreeNode<K, V> getFirstChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getFirstChild();
    }

    public HierarchyTreeNode<K, V> getLastChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getLastChild();
    }

    public HierarchyTreeNode<K, V> getCurrentChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getCurrentChild();
    }

    public HierarchyTreeNode<K, V> getPreviousChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getPreviousChild();
    }

    public HierarchyTreeNode<K, V> getNextChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getNextChild();
    }

    public Iterator<HierarchyTreeNode<K, V>> iterator() {
        this.currNode = this.rootNode;
        return new Iterator<HierarchyTreeNode<K, V>>(){

            @Override
            public boolean hasNext() {
                return HierarchyTree.this.currNode.hasChildren() ? true : (HierarchyTree.this.currNode.hasNext() ? true : HierarchyTree.this.currNode.getParent().hasNext());
            }

            @Override
            public HierarchyTreeNode<K, V> next() {
                HierarchyTree.this.currNode = HierarchyTree.this.currNode.hasChildren() ? HierarchyTree.this.currNode.getFirstChild() : (HierarchyTree.this.currNode.hasNext() ? HierarchyTree.this.currNode.getNext() : HierarchyTree.this.currNode.getParent().getNext());
                return HierarchyTree.this.currNode;
            }
        };
    }

    public void forEach(BiConsumer<K, K> biConsumer) {
        this.iterator().forEachRemaining(hierarchyTreeNode -> {
            HierarchyTreeNode parent = hierarchyTreeNode.getParent();
            Object parentKey = parent != null ? (Object)parent.getKey() : null;
            Object key = hierarchyTreeNode.getKey();
            biConsumer.accept(parentKey, key);
        });
    }

    public Spliterator<HierarchyTreeNode<K, V>> spliterator() {
        this.currNode = this.rootNode;
        return new Spliterator<HierarchyTreeNode<K, V>>(){
            int index = 0;
            int size;
            {
                this.size = HierarchyTree.this.nodeMap.size();
            }

            @Override
            public int characteristics() {
                return 272;
            }

            @Override
            public long estimateSize() {
                return this.size - this.index;
            }

            @Override
            public boolean tryAdvance(Consumer<? super HierarchyTreeNode<K, V>> action) {
                HierarchyTreeNode nextNode = HierarchyTree.this.currNode.getFirstChild();
                if (nextNode == null) {
                    nextNode = HierarchyTree.this.currNode.getNext();
                }
                if (nextNode == null) {
                    return false;
                }
                action.accept(nextNode);
                ++this.index;
                HierarchyTree.this.currNode = nextNode;
                return true;
            }

            @Override
            public Spliterator<HierarchyTreeNode<K, V>> trySplit() {
                return null;
            }
        };
    }

    public Stream<V> streamValuesDeep() {
        return this.nodeMap.values().stream().map(HierarchyTreeNode::getValue);
    }

    public Stream<V> streamValuesShallow(K parentKey) {
        assert (Objects.nonNull(parentKey));
        HierarchyTreeNode<K, V> hierarchyTreeNode = this.nodeMap.get(parentKey);
        if (hierarchyTreeNode == null) {
            return Stream.empty();
        }
        return hierarchyTreeNode.stream();
    }

    public Stream<K> streamKeysDeep() {
        return this.nodeMap.keySet().stream();
    }

    public Stream<K> streamKeysDeep(K parentKey) {
        assert (Objects.nonNull(parentKey));
        HierarchyTreeNode<K, V> hierarchyTreeNode = this.nodeMap.get(parentKey);
        if (hierarchyTreeNode == null) {
            return Stream.empty();
        }
        return hierarchyTreeNode.streamChildKeysDeep();
    }

    public Stream<K> streamKeysShallow(K parentKey) {
        assert (Objects.nonNull(parentKey));
        HierarchyTreeNode<K, V> hierarchyTreeNode = this.nodeMap.get(parentKey);
        if (hierarchyTreeNode == null) {
            return Stream.empty();
        }
        return hierarchyTreeNode.streamChildKeys();
    }

    public Stream<K> streamCurrentNodeKeysShallow() {
        return Objects.nonNull(this.currNode) ? this.currNode.streamChildKeys() : Stream.empty();
    }

    public Stream<K[]> streamKeySetsDeep() {
        return this.nodeMap.values().stream().map(hierarchyTreeNode -> {
            Object parentKey = hierarchyTreeNode.hasParent() ? hierarchyTreeNode.getParent().getKey() : hierarchyTreeNode.getKey();
            Object childKey = hierarchyTreeNode.getKey();
            Class<?> keyClass = childKey.getClass();
            Object[] keyArray = (Object[])Array.newInstance(keyClass, 2);
            keyArray[0] = parentKey;
            keyArray[1] = childKey;
            return keyArray;
        });
    }

    public Stream<K[]> streamKeySetsDeep(K parentKey) {
        HierarchyTreeNode<K, V> parent = this.nodeMap.get(parentKey);
        if (parent == null) {
            return Stream.empty();
        }
        return parent.streamChildKeysDeep().map(childKey -> {
            Class<?> keyClass = childKey.getClass();
            Object[] keyArray = (Object[])Array.newInstance(keyClass, 2);
            keyArray[0] = parentKey;
            keyArray[1] = childKey;
            return keyArray;
        });
    }

    public Stream<K[]> streamKeySetsShallow(K parentKey) {
        HierarchyTreeNode<K, V> parent = this.nodeMap.get(parentKey);
        if (parent == null) {
            return Stream.empty();
        }
        return parent.streamChildKeys().map(childKey -> {
            Class<?> keyClass = childKey.getClass();
            Object[] keyArray = (Object[])Array.newInstance(keyClass, 2);
            keyArray[0] = parentKey;
            keyArray[1] = childKey;
            return keyArray;
        });
    }

    public int size() {
        return this.nodeMap.size();
    }
}

