/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osee.define.rest.synchronization.IdentifierType;
import org.eclipse.osee.define.rest.synchronization.IdentifierTypeGroup;
import org.eclipse.osee.define.rest.synchronization.IsSynchronizationArtifactBuilder;
import org.eclipse.osee.define.rest.synchronization.SynchronizationArtifact;
import org.eclipse.osee.define.rest.synchronization.SynchronizationArtifactBuilder;
import org.eclipse.osee.define.rest.synchronization.SynchronizationArtifactParseException;
import org.eclipse.osee.define.rest.synchronization.forest.Forest;
import org.eclipse.osee.define.rest.synchronization.forest.Grove;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThing;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.NativeDataType;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.NativeDataTypeKey;
import org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder.AttributeDefinitionConverter;
import org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder.AttributeValueConverter;
import org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder.DataTypeDefinitionConverter;
import org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder.EnumValueConverter;
import org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder.HeaderConverter;
import org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder.SpecElementWithAttributesConverter;
import org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder.SpecTypeConverter;
import org.eclipse.osee.framework.jdk.core.util.EnumBiConsumerMap;
import org.eclipse.osee.framework.jdk.core.util.EnumConsumerMap;
import org.eclipse.osee.framework.jdk.core.util.ParameterArray;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;
import org.eclipse.rmf.reqif10.DatatypeDefinitionDate;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.ReqIFHeader;
import org.eclipse.rmf.reqif10.ReqIFToolExtension;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecRelationType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceFactoryImpl;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceImpl;
import org.xml.sax.SAXParseException;

@IsSynchronizationArtifactBuilder(artifactType="reqif")
public class ReqIFSynchronizationArtifactBuilder
implements SynchronizationArtifactBuilder {
    private static final EnumConsumerMap<IdentifierType, GroveThing> converterMap = EnumConsumerMap.ofEntries(IdentifierType.class, (Map.Entry[])new Map.Entry[]{Map.entry(IdentifierType.ATTRIBUTE_DEFINITION, AttributeDefinitionConverter::convert), Map.entry(IdentifierType.ATTRIBUTE_VALUE, AttributeValueConverter::convert), Map.entry(IdentifierType.DATA_TYPE_DEFINITION, DataTypeDefinitionConverter::convert), Map.entry(IdentifierType.ENUM_VALUE, EnumValueConverter::convert), Map.entry(IdentifierType.HEADER, HeaderConverter::convert), Map.entry(IdentifierType.SPECIFICATION, SpecElementWithAttributesConverter::convert), Map.entry(IdentifierType.SPECIFICATION_TYPE, SpecTypeConverter::convert), Map.entry(IdentifierType.SPECTER_SPEC_OBJECT, SpecElementWithAttributesConverter::convert), Map.entry(IdentifierType.SPEC_OBJECT, SpecElementWithAttributesConverter::convert), Map.entry(IdentifierType.SPEC_OBJECT_TYPE, SpecTypeConverter::convert), Map.entry(IdentifierType.SPEC_RELATION_TYPE, SpecTypeConverter::convert), Map.entry(IdentifierType.SPEC_RELATION, SpecElementWithAttributesConverter::convert)});
    private static final ZoneId zoneIdZ = ZoneId.of("Z");
    static final GregorianCalendar lastChangeEpoch = GregorianCalendar.from(ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, zoneIdZ));
    private static final EnumBiConsumerMap<NativeDataType, ? super AttributeValue, ? super AttributeDefinition> reqifAttachAttributeDefinitionToAttributeValueMap = EnumBiConsumerMap.ofEntries(NativeDataType.class, (Map.Entry[])new Map.Entry[]{Map.entry(NativeDataType.ARTIFACT_IDENTIFIER, (attributeValue, attributeDefinition) -> ((AttributeValueInteger)attributeValue).setDefinition((AttributeDefinitionInteger)attributeDefinition)), Map.entry(NativeDataType.BRANCH_IDENTIFIER, (attributeValue, attributeDefinition) -> ((AttributeValueInteger)attributeValue).setDefinition((AttributeDefinitionInteger)attributeDefinition)), Map.entry(NativeDataType.BOOLEAN, (attributeValue, attributeDefinition) -> ((AttributeValueBoolean)attributeValue).setDefinition((AttributeDefinitionBoolean)attributeDefinition)), Map.entry(NativeDataType.DATE, (attributeValue, attributeDefinition) -> ((AttributeValueDate)attributeValue).setDefinition((AttributeDefinitionDate)attributeDefinition)), Map.entry(NativeDataType.DOUBLE, (attributeValue, attributeDefinition) -> ((AttributeValueReal)attributeValue).setDefinition((AttributeDefinitionReal)attributeDefinition)), Map.entry(NativeDataType.ENUMERATED, (attributeValue, attributeDefinition) -> ((AttributeValueEnumeration)attributeValue).setDefinition((AttributeDefinitionEnumeration)attributeDefinition)), Map.entry(NativeDataType.INPUT_STREAM, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition)), Map.entry(NativeDataType.INTEGER, (attributeValue, attributeDefinition) -> ((AttributeValueInteger)attributeValue).setDefinition((AttributeDefinitionInteger)attributeDefinition)), Map.entry(NativeDataType.JAVA_OBJECT, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition)), Map.entry(NativeDataType.LONG, (attributeValue, attributeDefinition) -> ((AttributeValueInteger)attributeValue).setDefinition((AttributeDefinitionInteger)attributeDefinition)), Map.entry(NativeDataType.STRING, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition)), Map.entry(NativeDataType.STRING_WORD_ML, (attributeValue, attributeDefinition) -> ((AttributeValueXHTML)attributeValue).setDefinition((AttributeDefinitionXHTML)attributeDefinition)), Map.entry(NativeDataType.URI, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition))});
    private static final EnumBiConsumerMap<NativeDataType, ? super AttributeDefinition, ? super DatatypeDefinition> reqifAttachDatatypeDefinitionToAttributeDefinitionMap = EnumBiConsumerMap.ofEntries(NativeDataType.class, (Map.Entry[])new Map.Entry[]{Map.entry(NativeDataType.ARTIFACT_IDENTIFIER, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition)), Map.entry(NativeDataType.BRANCH_IDENTIFIER, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition)), Map.entry(NativeDataType.BOOLEAN, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionBoolean)attributeDefinition).setType((DatatypeDefinitionBoolean)datatypeDefinition)), Map.entry(NativeDataType.DATE, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionDate)attributeDefinition).setType((DatatypeDefinitionDate)datatypeDefinition)), Map.entry(NativeDataType.DOUBLE, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionReal)attributeDefinition).setType((DatatypeDefinitionReal)datatypeDefinition)), Map.entry(NativeDataType.ENUMERATED, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionEnumeration)attributeDefinition).setType((DatatypeDefinitionEnumeration)datatypeDefinition)), Map.entry(NativeDataType.INPUT_STREAM, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition)), Map.entry(NativeDataType.INTEGER, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition)), Map.entry(NativeDataType.JAVA_OBJECT, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition)), Map.entry(NativeDataType.LONG, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition)), Map.entry(NativeDataType.STRING, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition)), Map.entry(NativeDataType.STRING_WORD_ML, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionXHTML)attributeDefinition).setType((DatatypeDefinitionXHTML)datatypeDefinition)), Map.entry(NativeDataType.URI, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition))});
    static final String version = "0.0";
    ReqIF reqIf = ReqIF10Factory.eINSTANCE.createReqIF();

    @Override
    public Optional<Consumer<GroveThing>> getConverter(IdentifierType identifierType) {
        return converterMap.getFunction((Enum)identifierType);
    }

    @Override
    public boolean build(SynchronizationArtifact synchronizationArtifact) {
        Forest forest = synchronizationArtifact.getForest();
        Grove attributeValueGrove = forest.getGrove(IdentifierType.ATTRIBUTE_VALUE);
        Grove datatypeDefinitionGrove = forest.getGrove(IdentifierType.DATA_TYPE_DEFINITION);
        Grove headerGrove = forest.getGrove(IdentifierType.HEADER);
        Grove specificationGrove = forest.getGrove(IdentifierType.SPECIFICATION);
        Grove specObjectGrove = forest.getGrove(IdentifierType.SPEC_OBJECT);
        Grove specRelationGrove = forest.getGrove(IdentifierType.SPEC_RELATION);
        headerGrove.stream(new IdentifierType.Identifier[0]).forEach(headerGroveThing -> this.reqIf.setTheHeader((ReqIFHeader)headerGroveThing.getForeignThing()));
        ReqIFContent reqifContent = ReqIF10Factory.eINSTANCE.createReqIFContent();
        this.reqIf.setCoreContent(reqifContent);
        EList reqifDatatypeDefinitionList = reqifContent.getDatatypes();
        datatypeDefinitionGrove.stream(new IdentifierType.Identifier[0]).forEach(dataTypeDefinitionGroveThing -> {
            DatatypeDefinition reqifDatatypeDefinition = (DatatypeDefinition)dataTypeDefinitionGroveThing.getForeignThing();
            if (((NativeDataTypeKey)dataTypeDefinitionGroveThing.getNativeThing()).isEnumerated()) {
                DatatypeDefinitionEnumeration reqifDatatypeDefinitionEnumeration = (DatatypeDefinitionEnumeration)reqifDatatypeDefinition;
                EList reqifSpecifiedValues = reqifDatatypeDefinitionEnumeration.getSpecifiedValues();
                dataTypeDefinitionGroveThing.streamLinks(IdentifierType.ENUM_VALUE).forEach(enumValueGroveThing -> {
                    EnumValue reqifEnumValue = (EnumValue)enumValueGroveThing.getForeignThing();
                    reqifSpecifiedValues.add((Object)reqifEnumValue);
                });
            }
            reqifDatatypeDefinitionList.add((Object)reqifDatatypeDefinition);
        });
        EList reqifSpecTypeList = reqifContent.getSpecTypes();
        Arrays.stream(new IdentifierType[]{IdentifierType.SPECIFICATION_TYPE, IdentifierType.SPEC_OBJECT_TYPE, IdentifierType.SPEC_RELATION_TYPE}).map(forest::getGrove).flatMap(grove -> grove.stream(new IdentifierType.Identifier[0])).forEach(groveThing -> {
            SpecType reqifSpecType = (SpecType)groveThing.getForeignThing();
            reqifSpecTypeList.add((Object)reqifSpecType);
            EList reqifAttributeDefinitionList = reqifSpecType.getSpecAttributes();
            groveThing.streamLinks(IdentifierType.ATTRIBUTE_DEFINITION).forEach(attributeDefinition -> {
                reqifAttributeDefinitionList.add((Object)((AttributeDefinition)attributeDefinition.getForeignThing()));
                AttributeDefinition reqifAttributeDefinition = (AttributeDefinition)attributeDefinition.getForeignThing();
                GroveThing datatypeDefinition = attributeDefinition.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
                NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
                DatatypeDefinition reqifDatatypeDefinition = (DatatypeDefinition)datatypeDefinition.getForeignThing();
                reqifAttachDatatypeDefinitionToAttributeDefinitionMap.accept((Enum)nativeDataType, (Object)reqifAttributeDefinition, (Object)reqifDatatypeDefinition);
            });
        });
        EList reqifSpecificationList = reqifContent.getSpecifications();
        specificationGrove.stream(new IdentifierType.Identifier[0]).forEach(specificationGroveThing -> {
            Specification reqifSpecification = (Specification)specificationGroveThing.getForeignThing();
            GroveThing commonObjectType = specificationGroveThing.getLinkScalar(IdentifierType.SPECIFICATION_TYPE).get();
            SpecificationType reqifSpecificationType = (SpecificationType)commonObjectType.getForeignThing();
            reqifSpecification.setType(reqifSpecificationType);
            reqifSpecificationList.add((Object)reqifSpecification);
        });
        EList reqifSpecObjectList = reqifContent.getSpecObjects();
        Arrays.stream(new IdentifierType[]{IdentifierType.SPEC_OBJECT, IdentifierType.SPECTER_SPEC_OBJECT}).map(forest::getGrove).flatMap(grove -> grove.stream(new IdentifierType.Identifier[0])).filter(groveThing -> groveThing.isType(IdentifierType.SPEC_OBJECT) || groveThing.isType(IdentifierType.SPECTER_SPEC_OBJECT)).forEach(specObjectGroveThing -> {
            SpecObject reqifSpecObject = (SpecObject)specObjectGroveThing.getForeignThing();
            GroveThing commonObjectType = specObjectGroveThing.getLinkScalar(IdentifierType.SPEC_OBJECT_TYPE).get();
            SpecObjectType reqifSpecObjectType = (SpecObjectType)commonObjectType.getForeignThing();
            reqifSpecObject.setType(reqifSpecObjectType);
            reqifSpecObjectList.add((Object)reqifSpecObject);
        });
        EList reqifSpecRelationList = reqifContent.getSpecRelations();
        specRelationGrove.stream(new IdentifierType.Identifier[0]).forEach(specRelationGroveThing -> {
            SpecRelation reqifSpecRelation = (SpecRelation)specRelationGroveThing.getForeignThing();
            GroveThing commonObjectType = specRelationGroveThing.getLinkScalar(IdentifierType.SPEC_RELATION_TYPE).get();
            SpecRelationType reqifSpecRelationType = (SpecRelationType)commonObjectType.getForeignThing();
            reqifSpecRelation.setType(reqifSpecRelationType);
            GroveThing sideASpecObjectGroveThing = specRelationGroveThing.getLinkVectorElement(IdentifierTypeGroup.RELATABLE_OBJECT, 0).get();
            GroveThing sideBSpecObjectGroveThing = specRelationGroveThing.getLinkVectorElement(IdentifierTypeGroup.RELATABLE_OBJECT, 1).get();
            Object reqifSideAThing = sideASpecObjectGroveThing.getForeignThing();
            Object reqifSideBThing = sideBSpecObjectGroveThing.getForeignThing();
            if (reqifSideAThing instanceof SpecObject) {
                reqifSpecRelation.setSource((SpecObject)reqifSideAThing);
            }
            if (reqifSideBThing instanceof SpecObject) {
                reqifSpecRelation.setTarget((SpecObject)reqifSideBThing);
            }
            reqifSpecRelationList.add((Object)reqifSpecRelation);
        });
        attributeValueGrove.stream(new IdentifierType.Identifier[0]).forEach(attributeValueGroveThing -> {
            AttributeValue reqifAttributeValue = (AttributeValue)attributeValueGroveThing.getForeignThing();
            GroveThing commonObject = attributeValueGroveThing.getParent(-1).get();
            SpecElementWithAttributes reqifSpecElementWithAttributes = (SpecElementWithAttributes)commonObject.getForeignThing();
            EList reqifAttributeValueList = reqifSpecElementWithAttributes.getValues();
            reqifAttributeValueList.add((Object)reqifAttributeValue);
            GroveThing attributeDefinition = attributeValueGroveThing.getLinkScalar(IdentifierType.ATTRIBUTE_DEFINITION).get();
            GroveThing datatypeDefinition = attributeDefinition.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
            NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
            AttributeDefinition reqifAttributeDefinition = (AttributeDefinition)attributeDefinition.getForeignThing();
            reqifAttachAttributeDefinitionToAttributeValueMap.accept((Enum)nativeDataType, (Object)reqifAttributeValue, (Object)reqifAttributeDefinition);
        });
        specObjectGrove.streamIdentifiersShallow(new IdentifierType.Identifier[0]).forEach(specificationIdentifier -> {
            GroveThing specificationGroveThing = specObjectGrove.getByPrimaryKeys((IdentifierType.Identifier)specificationIdentifier, (IdentifierType.Identifier)specificationIdentifier).get();
            Specification reqifSpecification = (Specification)specificationGroveThing.getForeignThing();
            EList reqifSpecificationChildren = reqifSpecification.getChildren();
            specificationGroveThing.setForeignHierarchy(reqifSpecificationChildren);
            specObjectGrove.streamKeySets((IdentifierType.Identifier)specificationIdentifier).filter(keySet -> keySet[2].getType().equals(IdentifierType.SPEC_OBJECT)).forEach(keySet -> {
                assert (ParameterArray.validateNonNullAndSize((Object[])keySet, (int)3, (int)3));
                IdentifierType.Identifier specObjectIdentifier = keySet[2];
                GroveThing specObjectGroveThing = specObjectGrove.getByPrimaryKeys((IdentifierType.Identifier)specificationIdentifier, specObjectIdentifier).get();
                SpecObject reqifSpecObject = (SpecObject)specObjectGroveThing.getForeignThing();
                SpecHierarchy reqifSpecHierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
                EList reqifChildren = reqifSpecHierarchy.getChildren();
                reqifSpecHierarchy.setObject(reqifSpecObject);
                specObjectGroveThing.setForeignHierarchy(reqifChildren);
                IdentifierType.Identifier parentIdentifier = keySet[1];
                GroveThing parentGroveThing = specificationIdentifier.equals(parentIdentifier) ? specObjectGrove.getByPrimaryKeys((IdentifierType.Identifier)specificationIdentifier, (IdentifierType.Identifier)specificationIdentifier).get() : specObjectGrove.getByPrimaryKeys((IdentifierType.Identifier)specificationIdentifier, parentIdentifier).get();
                EList parentReqifChildren = (EList)parentGroveThing.getForeignHierarchy();
                parentReqifChildren.add((Object)reqifSpecHierarchy);
            });
        });
        ReqIFToolExtension reqifToolExtension = ReqIF10Factory.eINSTANCE.createReqIFToolExtension();
        this.reqIf.getToolExtensions().add((Object)reqifToolExtension);
        return false;
    }

    @Override
    public void deserialize(InputStream inputStream) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl());
        URI uri = URI.createFileURI((String)"i.reqif");
        Resource resource = resourceSet.createResource(uri);
        try {
            resource.load(inputStream, null);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SAXParseException) {
                throw new SynchronizationArtifactParseException((SAXParseException)cause);
            }
            throw new RuntimeException("Resource Load Failed", e);
        }
        EList errorList = resource.getErrors();
        EList warningList = resource.getWarnings();
        if (errorList.size() > 0 || warningList.size() > 0) {
            throw new SynchronizationArtifactParseException((List<Resource.Diagnostic>)errorList, (List<Resource.Diagnostic>)warningList);
        }
        EList eObjectList = resource.getContents();
        if (Objects.isNull(eObjectList)) {
            throw new SynchronizationArtifactParseException("Failed to get ReqIF contents.");
        }
        EObject rootEObject = (EObject)eObjectList.get(0);
        if (Objects.isNull(rootEObject)) {
            throw new SynchronizationArtifactParseException("Failed to get root ReqIF object.");
        }
        ReqIF cfr_ignored_0 = (ReqIF)rootEObject;
    }

    @Override
    public InputStream serialize() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                return new ReqIF10ResourceImpl(uri){

                    protected boolean useUUIDs() {
                        return false;
                    }
                };
            }
        });
        URI uri = URI.createFileURI((String)"o.reqif");
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)this.reqIf);
        var outputStream = new ByteArrayOutputStream(){

            byte[] getBuffer() {
                return this.buf;
            }
        };
        try {
            resource.save((OutputStream)outputStream, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Resource Save Failed", e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.getBuffer(), 0, outputStream.size());
        return inputStream;
    }
}

