/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization.forest.morphology;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThing;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.Store;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.StoreType;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ParameterArray;
import org.eclipse.osee.framework.jdk.core.util.RankHashMap;
import org.eclipse.osee.framework.jdk.core.util.RankMap;

class StoreRankN
implements Store {
    private final RankMap<GroveThing> primaryMap;
    private final StoreType storeType;

    public StoreRankN(StoreType storeType, int rank, Predicate<Object>[] keyValidators) {
        assert (Objects.nonNull((Object)storeType) && rank >= 0 && ParameterArray.validateNonNullAndSize((Object[])keyValidators, (int)rank, (int)rank));
        this.storeType = Objects.requireNonNull(storeType);
        this.primaryMap = new RankHashMap(null, rank, 1024, 0.75f, (Predicate[])keyValidators);
    }

    @Override
    public void add(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing));
        this.storeType.getKeys(groveThing).ifPresent(keys -> {
            Optional optional = this.primaryMap.associate((Object)groveThing, keys);
        });
    }

    @Override
    public boolean contains(Object ... keys) {
        return this.primaryMap.containsKeys(keys);
    }

    @Override
    public Optional<GroveThing> get(Object ... keys) {
        return this.primaryMap.get(keys);
    }

    @Override
    public StoreType getType() {
        return this.storeType;
    }

    @Override
    public int rank() {
        return this.primaryMap.rank();
    }

    @Override
    public int size() {
        return this.primaryMap.size();
    }

    @Override
    public Stream<GroveThing> stream(Object ... keys) {
        return this.primaryMap.stream(keys);
    }

    @Override
    public Stream<Object> streamKeysAtAndBelow(Object ... keys) {
        return this.primaryMap.streamKeysAtAndBelow(keys);
    }

    @Override
    public Stream<Object> streamKeysAt(Object ... keys) {
        return this.primaryMap.streamKeysAt(keys);
    }

    @Override
    public Stream<Object[]> streamKeySets(Object ... keys) {
        return this.primaryMap.stream(keys).map(value -> this.storeType == StoreType.PRIMARY ? value.getPrimaryKeys() : value.getNativeKeys()).filter(Optional::isPresent).map(Optional::get);
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)(indent + 0));
        String indent1 = IndentedString.indentString((int)(indent + 1));
        outMessage.append(indent0).append(this.getClass().getName()).append("\n").append(indent1).append("Rank:         ").append(this.rank()).append("\n").append(indent1).append("Store Type:   ").append((Object)this.storeType).append("\n").append(indent1).append("Current Size: ").append(this.size()).append("\n");
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

