/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.osee.define.rest.synchronization.IdentifierType;
import org.eclipse.osee.define.rest.synchronization.IdentifierTypeGroup;
import org.eclipse.osee.define.rest.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.rest.synchronization.UnexpectedIdentifierTypeException;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThing;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.DoubleHashMap;
import org.eclipse.osee.framework.jdk.core.util.DoubleMap;

class CommonObjectTypeContainerMap {
    private final DoubleMap<Long, IdentifierType, GroveThing> map = new DoubleHashMap(256, 0.75f, IdentifierType.size(), 1.0f);

    CommonObjectTypeContainerMap() {
    }

    Optional<GroveThing> get(ArtifactTypeToken artifactTypeToken, IdentifierType identifierType) {
        assert (Objects.nonNull(artifactTypeToken)) : "CommonObjectTypeContainerMap::get, artifactTypeToken is null.";
        assert (Objects.nonNull(identifierType)) : "CommonObjectTypeContainerMap::get, identifierType is null.";
        assert (identifierType.isInGroup(IdentifierTypeGroup.TYPE)) : UnexpectedIdentifierTypeException.buildMessage(identifierType, IdentifierTypeGroup.TYPE);
        return this.map.get((Object)artifactTypeToken.getId(), (Object)identifierType);
    }

    void put(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing)) : "CommonObjectTypeContainerMap::put, groveThing is null.";
        assert (groveThing.getType().isInGroup(IdentifierTypeGroup.TYPE)) : UnexpectedGroveThingTypeException.buildMessage(groveThing, IdentifierTypeGroup.TYPE);
        assert (Objects.nonNull(groveThing.getNativeThing())) : "CommonObjectTypeContainerMap::put, groveThing has a null native thing.";
        assert (groveThing.getNativeThing() instanceof ArtifactTypeToken) : "CommonObjectTypeContainerMap::put, the groveThing's native thing is not an ArtifactTypeToken.";
        assert (!this.map.containsKey((Object)((Id)groveThing.getNativeThing()).getId(), (Object)groveThing.getType())) : "CommonObjectTypeContainerMap::put, map already has an entry for the artifact type token and grove thing type.";
        this.map.put((Object)((Id)groveThing.getNativeThing()).getId(), (Object)groveThing.getType(), (Object)groveThing);
        assert (((Map)this.map.get((Object)((Id)groveThing.getNativeThing()).getId()).orElseThrow()).values().stream().map(GroveThing::getNativeThing).distinct().count() == 1L) : "CommonObjectTypeContainerMap::put, not all GroveThings under the primay key have the same native thing ArtifactTypeToken";
    }

    Stream<GroveThing> stream() {
        return this.map.values().stream();
    }
}

