/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUtilities;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.model.type.LinkType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;

public class WordTemplateContentRendererHandler {
    public static final String PGNUMTYPE_START_1 = "<w:pgNumType [^>]*w:start=\"1\"/>";
    public static final String PL_STYLE_WITH_RETURN = "<w:rPr><w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>)).*?</w:rPr>";
    public static final String PL_STYLE = "<w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>))";
    public static final String PL_HIGHLIGHT = "<w:highlight w:val=\"light-gray\"></w:highlight><w:shd w:color=\"auto\" w:fill=\"BFBFBF\" w:val=\"clear\"></w:shd>";
    public static final String EMPTY_PARAGRAPHS = "<w:r wsp:rsidRPr=\"\\d+\"><w:t></w:t></w:r>";
    public static final String EXTRA_SPACES = "<w:r><w:t> </w:t></w:r>";
    private final OrcsApi orcsApi;
    private final Log logger;
    private WordMLApplicabilityHandler applicHandler;
    private final QueryFactory queryFactory;

    public WordTemplateContentRendererHandler(OrcsApi orcsApi, Log logger) {
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.logger = logger;
    }

    public Pair<String, Set<String>> renderWordML(WordTemplateContentData wtcData) {
        TransactionId txId = wtcData.getTxId();
        if (txId == null || txId.isInvalid()) {
            txId = TransactionId.SENTINEL;
        }
        ArtifactReadable artifact = null;
        artifact = txId.equals(TransactionId.SENTINEL) ? (ArtifactReadable)this.queryFactory.fromBranch(wtcData.getBranch()).andId(ArtifactId.valueOf((Id)wtcData.getArtId())).includeDeletedArtifacts().includeDeletedAttributes().getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL) : (ArtifactReadable)this.queryFactory.fromBranch(wtcData.getBranch()).fromTransaction(txId).andId(ArtifactId.valueOf((Id)wtcData.getArtId())).includeDeletedArtifacts().includeDeletedAttributes().getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (artifact.isValid()) {
            HashSet<String> unknownGuids = new HashSet<String>();
            String data = (String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, DeletionFlag.EXCLUDE_DELETED, null);
            if (data == null && wtcData.getIsEdit()) {
                data = (String)CoreArtifactTypes.MsWordTemplate.getAttributeDefault((AttributeTypeGeneric)CoreAttributeTypes.WordTemplateContent);
            }
            if (data != null) {
                int lastIndex;
                data = WordUtilities.reassignBinDataID(data);
                if (wtcData.getArtIsChanged()) {
                    data = WordUtilities.appendInlineChangeTag(data);
                }
                data = WordUtilities.removeNewLines(data);
                LinkType link = wtcData.getLinkType() != null ? LinkType.valueOf((String)wtcData.getLinkType()) : null;
                data = WordMlLinkHandler.link(this.queryFactory, link, artifact, data, wtcData.getTxId(), unknownGuids, wtcData.getPresentationType(), wtcData.getPermanentLinkUrl());
                data = WordUtilities.reassignBookMarkID(data);
                data = data.replaceAll("<w:p[^>]*><w:pPr>(<w:spacing w:after=\"[\\d]*\"[^>]*>)*(</w:spacing>)*<w:sectPr[^>]*>(<w:r><w:t>)?<w:ftr[^>]*>[\\s\\S]+</w:ftr>[\\s\\S]+</w:sectPr></w:pPr></w:p>", "");
                data = data.replaceAll("<w:sectPr[^>]*><w:ftr[\\s\\S]+?</w:ftr>[\\s\\S]+?</w:sectPr>", "");
                data = data.replaceAll("<w:sectPr[^>]*>(<w:type[^>]*>(</w:type>)*)*<w:pgSz[^>]*>(</w:pgSz>)*<w:pgMar[^>]*>(</w:pgMar>)*<w:cols[^>]*>(</w:cols>)*</w:sectPr>", "<w:r><w:br w:type=\"page\"/></w:r>");
                data = data.replaceAll("<w:p>[\\s||\\S]+?<w:r><w:t>NO DATA RIGHTS ARTIFACT FOUND</w:t></w:r>[\\s\\S]+?</w:p>", "");
                if (wtcData.getIsEdit() && !data.contains("<w:tbl>") && (lastIndex = data.lastIndexOf("<w:p wsp:rsidR=")) != -1) {
                    String temp = data.substring(lastIndex);
                    temp = temp.replaceAll("<w:p\\s[^>]*>(<w:pPr><w:spacing[^>]*></w:spacing></w:pPr>)?</w:p>", "");
                    data = String.valueOf(data.substring(0, lastIndex)) + temp;
                }
                if (!wtcData.getIsEdit() && (wtcData.getBranch().getViewId().notEqual((Id)ArtifactId.SENTINEL) || this.isWtcViewIdValid(wtcData))) {
                    if (this.applicHandler == null) {
                        this.applicHandler = new WordMLApplicabilityHandler(this.orcsApi, this.logger, wtcData.getBranch(), wtcData.getViewId());
                    }
                    data = data.replaceAll(PL_STYLE_WITH_RETURN, "");
                    data = data.replaceAll(PL_STYLE, "");
                    data = data.replaceAll(PL_HIGHLIGHT, "");
                    data = this.applicHandler.previewValidApplicabilityContent(data);
                    data = data.replaceAll(EMPTY_PARAGRAPHS, "");
                }
                data = data.concat(wtcData.getFooter());
                if (!wtcData.getIsEdit()) {
                    data = data.replaceAll(PGNUMTYPE_START_1, "");
                }
                return new Pair((Object)data, unknownGuids);
            }
            if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                data = "";
                LinkType link = wtcData.getLinkType() != null ? LinkType.valueOf((String)wtcData.getLinkType()) : null;
                data = WordMlLinkHandler.link(this.queryFactory, link, artifact, data, wtcData.getTxId(), unknownGuids, wtcData.getPresentationType(), wtcData.getPermanentLinkUrl());
                data = WordUtilities.reassignBookMarkID(data);
                data = WordUtilities.removeNewLines(data);
                return new Pair((Object)data, unknownGuids);
            }
        }
        return null;
    }

    private boolean isWtcViewIdValid(WordTemplateContentData wtcData) {
        return wtcData.getViewId() != null && wtcData.getViewId().notEqual((Id)ArtifactId.SENTINEL);
    }
}

