/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import org.eclipse.osee.orcs.db.internal.exchange.handler.IExportItem;

public enum ExportItem implements IExportItem
{
    EXPORT_MANIFEST(""),
    EXPORT_TYPE_MODEL("osee_type_model"),
    EXPORT_DB_SCHEMA("db.metadata"),
    OSEE_BRANCH_DATA("osee_branch"),
    OSEE_TX_DETAILS_DATA("osee_tx_details"),
    OSEE_TXS_DATA("osee_txs"),
    OSEE_TXS_ARCHIVED_DATA("osee_txs_archived"),
    OSEE_ARTIFACT_DATA("osee_artifact"),
    OSEE_ATTRIBUTE_DATA("osee_attribute"),
    OSEE_RELATION_LINK_DATA("osee_relation_link"),
    OSEE_MERGE_DATA("osee_merge"),
    OSEE_CONFLICT_DATA("osee_conflict"),
    OSEE_BRANCH_ACL_DATA("osee_branch_acl"),
    OSEE_ARTIFACT_ACL_DATA("osee_artifact_acl");

    private final String source;

    private ExportItem(String source) {
        this.source = source;
    }

    public String toString() {
        return this.name().toLowerCase().replace('_', '.');
    }

    @Override
    public String getFileName() {
        String extension = this != EXPORT_TYPE_MODEL ? ".xml" : ".osee";
        return this + extension;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getPriority() {
        return this.ordinal();
    }

    public boolean matches(ExportItem ... exportItems) {
        ExportItem[] exportItemArray = exportItems;
        int n = exportItems.length;
        int n2 = 0;
        while (n2 < n) {
            ExportItem exportItem = exportItemArray[n2];
            if (this == exportItem) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

