/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.ConflictType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.IOseeExchangeDataProvider;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BaseDbSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.DataToSql;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.IExportItem;
import org.eclipse.osee.orcs.db.internal.util.ZipBinaryResource;

public class DbTableSaxHandler
extends BaseDbSaxHandler {
    private final List<IResourceLocator> transferredBinaryContent;
    private final Set<BranchId> branchesToImport;
    private final IOseeExchangeDataProvider exportDataProvider;
    private final IResourceManager resourceManager;
    private IExportItem exportItem;

    public static DbTableSaxHandler createWithLimitedCache(Log logger, JdbcClient jdbcClient, IResourceManager resourceManager, IOseeExchangeDataProvider exportDataProvider, int cacheLimit) {
        return new DbTableSaxHandler(logger, jdbcClient, resourceManager, exportDataProvider, false, cacheLimit);
    }

    protected DbTableSaxHandler(Log logger, JdbcClient jdbcClient, IResourceManager resourceManager, IOseeExchangeDataProvider exportDataProvider, boolean isCacheAll, int cacheLimit) {
        super(logger, jdbcClient, isCacheAll, cacheLimit);
        this.resourceManager = resourceManager;
        this.branchesToImport = new HashSet<BranchId>();
        this.transferredBinaryContent = new ArrayList<IResourceLocator>();
        this.exportDataProvider = exportDataProvider;
    }

    private IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setSelectedBranchIds(Iterable<? extends BranchId> branchesToImport) {
        this.branchesToImport.clear();
        for (BranchId branchId : branchesToImport) {
            this.branchesToImport.add(branchId);
        }
    }

    private String importBinaryContent(String uriValue, String gammaId) {
        String relativePath = Lib.isWindows() ? uriValue : uriValue.replaceAll("\\\\", File.separator);
        String entrySearch = "resources" + File.separator + relativePath;
        if (this.exportDataProvider.getExportedDataRoot() != null) {
            File entry = new File(this.exportDataProvider.getExportedDataRoot(), entrySearch);
            if (entry.exists()) {
                String name = uriValue.substring(uriValue.lastIndexOf(92) + 1, uriValue.length());
                IResourceLocator locatorHint = this.getResourceManager().generateResourceLocator("attr", gammaId, name);
                IResourceLocator locator = this.getResourceManager().save(locatorHint, (IResource)new ZipBinaryResource(entry, locatorHint), new PropertyStore());
                this.transferredBinaryContent.add(locator);
                return locator.getLocation().toASCIIString();
            }
            throw new OseeStateException("Unable to locate resource in zip file - ZipEntry was null for [%s]", new Object[]{uriValue});
        }
        throw new OseeStateException("Uncompressed folder was Null.", new Object[0]);
    }

    private long getTypeId(Map<String, String> fieldMap) {
        String hexString = fieldMap.get("type_guid");
        return Long.valueOf(hexString);
    }

    @Override
    protected void processData(Map<String, String> fieldMap) {
        boolean process = true;
        try {
            String branchUuidString;
            if (!this.branchesToImport.isEmpty() && Strings.isValid((String)(branchUuidString = fieldMap.get("part_of_branch_id"))) && !this.branchesToImport.contains(Integer.valueOf(branchUuidString))) {
                process = false;
            }
            if (process) {
                Object[] objectData;
                String stringValue;
                String uriValue = fieldMap.get("binaryContentLocation");
                if (Strings.isValid((String)uriValue)) {
                    String gammaId = fieldMap.get("gamma_id");
                    Object translated = this.getTranslator().translate("gamma_id", Long.valueOf(gammaId));
                    uriValue = this.importBinaryContent(uriValue, translated.toString());
                    fieldMap.put("uri", uriValue);
                }
                if (Strings.isValid((String)(stringValue = fieldMap.get("stringContent")))) {
                    fieldMap.put("value", stringValue);
                }
                if (this.exportItem.equals(ExportItem.OSEE_ARTIFACT_DATA)) {
                    long typeId = this.getTypeId(fieldMap);
                    fieldMap.put("art_type_id", String.valueOf(typeId));
                }
                if (this.exportItem.equals(ExportItem.OSEE_ATTRIBUTE_DATA)) {
                    long typeId = this.getTypeId(fieldMap);
                    fieldMap.put("attr_type_id", String.valueOf(typeId));
                }
                if (this.exportItem.equals(ExportItem.OSEE_RELATION_LINK_DATA)) {
                    long typeId = this.getTypeId(fieldMap);
                    fieldMap.put("rel_link_type_id", String.valueOf(typeId));
                }
                String conflictId = fieldMap.get("conflict_id");
                String conflictType = fieldMap.get("conflict_type");
                if (Strings.isValid((String)conflictId) && Strings.isValid((String)conflictType)) {
                    int conflictOrdinal = Integer.valueOf(conflictType);
                    ConflictType[] conflictTypeArray = ConflictType.values();
                    int n = conflictTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ConflictType type = conflictTypeArray[n2];
                        if (type.getValue() == conflictOrdinal) {
                            Object value = Integer.valueOf(conflictId);
                            switch (type) {
                                case ARTIFACT: {
                                    value = this.getTranslator().translate("art_id", value);
                                    break;
                                }
                                case ATTRIBUTE: {
                                    value = this.getTranslator().translate("attr_id", value);
                                    break;
                                }
                                case RELATION: {
                                    value = this.getTranslator().translate("rel_link_id", value);
                                    break;
                                }
                            }
                            fieldMap.put("conflict_id", value.toString());
                            break;
                        }
                        ++n2;
                    }
                }
                if ((objectData = DataToSql.toDataArray(this.getMetaData(), this.getTranslator(), fieldMap)) != null) {
                    this.addData(objectData);
                    if (this.isStorageNeeded()) {
                        this.store();
                    }
                }
            }
        }
        catch (OseeCoreException ex) {
            this.cleanUpBinaryContent();
            this.getLogger().error((Throwable)ex, "Error processing in [%s]", new Object[]{this.getMetaData().getTableName()});
            throw ex;
        }
    }

    @Override
    public void reset() {
        this.transferredBinaryContent.clear();
        super.reset();
    }

    private void cleanUpBinaryContent() {
        StringBuilder errorMessage = new StringBuilder();
        IResourceManager manager = this.getResourceManager();
        for (IResourceLocator locator : this.transferredBinaryContent) {
            try {
                manager.delete(locator);
            }
            catch (Exception exception) {
                errorMessage.append(String.format("Error deleting [%s]\n", locator.getLocation().toASCIIString()));
            }
        }
        if (errorMessage.length() > 0) {
            this.getLogger().error("Error deleting binary data after transfer error. Please delete all content manually. [%s]", new Object[]{errorMessage.toString()});
        }
    }

    @Override
    public void clearDataTable() {
        if (!this.getMetaData().getTableName().equals("osee_tx_details")) {
            super.clearDataTable();
        }
    }

    public void setExportItem(IExportItem exportItem) {
        this.exportItem = exportItem;
    }
}

