/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeJoin;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeMultiplicity;
import org.eclipse.osee.framework.core.data.AttributeTypeArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeBoolean;
import org.eclipse.osee.framework.core.data.AttributeTypeBranchId;
import org.eclipse.osee.framework.core.data.AttributeTypeDate;
import org.eclipse.osee.framework.core.data.AttributeTypeDouble;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeInputStream;
import org.eclipse.osee.framework.core.data.AttributeTypeInteger;
import org.eclipse.osee.framework.core.data.AttributeTypeJoin;
import org.eclipse.osee.framework.core.data.AttributeTypeLong;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristic;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.DynamicEnumAttributeType;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.OrcsTypeJoin;
import org.eclipse.osee.framework.core.data.RelationTypeJoin;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.jdk.core.type.ChainingArrayList;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.QuinFunction;
import org.eclipse.osee.framework.jdk.core.type.SexFunction;

public class OrcsTypeTokens {
    private final List<ArtifactTypeToken> artifactTypes = new ArrayList<ArtifactTypeToken>();
    private final ChainingArrayList<@NonNull AttributeTypeGeneric<?>> attributeTypes = new ChainingArrayList();
    private final ChainingArrayList<@NonNull RelationTypeToken> relationTypes = new ChainingArrayList();
    private final ChainingArrayList<@NonNull ComputedCharacteristic<?>> computedCharacteristics = new ChainingArrayList();
    private final List<OrcsTypeJoin<?, ?>> orcsTypeJoins = new ArrayList();
    private final NamespaceToken namespace;

    public OrcsTypeTokens(NamespaceToken namespace) {
        this.namespace = namespace;
    }

    public NamespaceToken getNamespace() {
        return this.namespace;
    }

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, OseeImage image, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, image, superTypes);
    }

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, superTypes);
    }

    public List<AttributeTypeGeneric<?>> getAttributeTypes() {
        return this.attributeTypes;
    }

    public List<ArtifactTypeToken> getArtifactTypes() {
        return this.artifactTypes;
    }

    public ArtifactTypeToken add(AttributeMultiplicity attributeMultiplicity) {
        ArtifactTypeToken artifactType = attributeMultiplicity.get();
        this.artifactTypes.add(artifactType);
        return artifactType;
    }

    public <V, T extends AttributeTypeGeneric<V>> T add(T attributeType) {
        this.attributeTypes.add(attributeType);
        return attributeType;
    }

    public RelationTypeToken addNewRelationType(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName) {
        return (RelationTypeToken)this.relationTypes.addAndReturn((Object)RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName, ArtifactTypeToken.SENTINEL, true));
    }

    public RelationTypeToken addNewRelationType(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName, ArtifactTypeToken relationArtifactType) {
        return (RelationTypeToken)this.relationTypes.addAndReturn((Object)RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName, relationArtifactType, true));
    }

    public RelationTypeToken add(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName) {
        return (RelationTypeToken)this.relationTypes.addAndReturn((Object)RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName));
    }

    public void registerTypes(OrcsTokenService tokenService) {
        this.artifactTypes.forEach(tokenService::registerArtifactType);
        this.attributeTypes.forEach(tokenService::registerAttributeType);
        this.relationTypes.forEach(tokenService::registerRelationType);
        for (OrcsTypeJoin<?, ?> typeJoin : this.orcsTypeJoins) {
            if (typeJoin instanceof ArtifactTypeJoin) {
                tokenService.registerArtifactTypeJoin((ArtifactTypeJoin)typeJoin);
                continue;
            }
            if (typeJoin instanceof AttributeTypeJoin) {
                tokenService.registerAttributeTypeJoin((AttributeTypeJoin)typeJoin);
                continue;
            }
            if (typeJoin instanceof RelationTypeJoin) {
                tokenService.registerRelationTypeJoin((RelationTypeJoin)typeJoin);
                continue;
            }
            throw new OseeArgumentException("Unexpected join type: ", new Object[]{typeJoin});
        }
    }

    public @NonNull AttributeTypeArtifactId createArtifactId(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        AttributeTypeArtifactId attrType = (AttributeTypeArtifactId)this.attributeTypes.addAndReturn((Object)new AttributeTypeArtifactId(id, this.namespace, name, mediaType, description, taggerType));
        if (attrType.getDisplayHints().contains((Object)DisplayHint.MultiLine)) {
            attrType.addDisplayHint(DisplayHint.SingleLine);
        }
        return attrType;
    }

    public @NonNull AttributeTypeArtifactId createArtifactId(Long id, String name, String mediaType, String description) {
        return this.createArtifactId(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType));
    }

    public @NonNull AttributeTypeArtifactId createArtifactIdNoTag(Long id, String name, String mediaType, String description) {
        return this.createArtifactId(id, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public @NonNull AttributeTypeBoolean createBoolean(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        return (AttributeTypeBoolean)this.attributeTypes.addAndReturn((Object)new AttributeTypeBoolean(id, this.namespace, name, mediaType, description, taggerType, displayHints));
    }

    public @NonNull AttributeTypeBoolean createBoolean(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createBoolean(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), displayHints);
    }

    public @NonNull AttributeTypeBoolean createBooleanNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createBoolean(id, name, mediaType, description, TaggerTypeToken.SENTINEL, displayHints);
    }

    public @NonNull AttributeTypeBranchId createBranchId(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return (AttributeTypeBranchId)this.attributeTypes.addAndReturn((Object)new AttributeTypeBranchId(id, this.namespace, name, mediaType, description, taggerType));
    }

    public @NonNull AttributeTypeBranchId createBranchId(Long id, String name, String mediaType, String description) {
        return this.createBranchId(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType));
    }

    public @NonNull AttributeTypeBranchId createBranchIdNoTag(Long id, String name, String mediaType, String description) {
        return this.createBranchId(id, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public @NonNull AttributeTypeDate createDate(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return (AttributeTypeDate)this.attributeTypes.addAndReturn((Object)new AttributeTypeDate(id, this.namespace, name, mediaType, description, taggerType));
    }

    public @NonNull AttributeTypeDate createDate(Long id, String name, String mediaType, String description) {
        return this.createDate(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType));
    }

    public @NonNull AttributeTypeDate createDateNoTag(Long id, String name, String mediaType, String description) {
        return this.createDate(id, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public @NonNull AttributeTypeDouble createDouble(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        AttributeTypeDouble attrType = (AttributeTypeDouble)this.attributeTypes.addAndReturn((Object)new AttributeTypeDouble(id, this.namespace, name, mediaType, description, taggerType, displayHints));
        if (attrType.getDisplayHints().contains((Object)DisplayHint.MultiLine)) {
            attrType.addDisplayHint(DisplayHint.SingleLine);
        }
        return attrType;
    }

    public @NonNull AttributeTypeDouble createDouble(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createDouble(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), displayHints);
    }

    public @NonNull AttributeTypeDouble createDoubleNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createDouble(id, name, mediaType, description, TaggerTypeToken.SENTINEL, displayHints);
    }

    public @NonNull AttributeTypeInputStream createInputStream(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, String fileExtension) {
        return (AttributeTypeInputStream)this.attributeTypes.addAndReturn((Object)new AttributeTypeInputStream(id, this.namespace, name, mediaType, description, taggerType, fileExtension));
    }

    public @NonNull AttributeTypeInputStream createInputStream(Long id, String name, String mediaType, String description) {
        return this.createInputStream(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), OrcsTypeTokens.defaultFileExtension(mediaType));
    }

    public @NonNull AttributeTypeInputStream createInputStream(Long id, String name, String mediaType, String description, String fileExtension) {
        return this.createInputStream(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), fileExtension);
    }

    public @NonNull AttributeTypeInputStream createInputStreamNoTag(Long id, String name, String mediaType, String description) {
        return this.createInputStream(id, name, mediaType, description, TaggerTypeToken.SENTINEL, OrcsTypeTokens.defaultFileExtension(mediaType));
    }

    public @NonNull AttributeTypeInputStream createInputStreamNoTag(Long id, String name, String mediaType, String description, String fileExtension) {
        return this.createInputStream(id, name, mediaType, description, TaggerTypeToken.SENTINEL, fileExtension);
    }

    public @NonNull AttributeTypeInteger createInteger(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        AttributeTypeInteger attrType = (AttributeTypeInteger)this.attributeTypes.addAndReturn((Object)new AttributeTypeInteger(id, this.namespace, name, mediaType, description, taggerType));
        if (attrType.getDisplayHints().contains((Object)DisplayHint.MultiLine)) {
            attrType.addDisplayHint(DisplayHint.SingleLine);
        }
        return attrType;
    }

    public @NonNull AttributeTypeInteger createInteger(Long id, String name, String mediaType, String description) {
        return this.createInteger(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType));
    }

    public @NonNull AttributeTypeInteger createIntegerNoTag(Long id, String name, String mediaType, String description) {
        return this.createInteger(id, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public @NonNull AttributeTypeLong createLong(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        AttributeTypeLong attrType = (AttributeTypeLong)this.attributeTypes.addAndReturn((Object)new AttributeTypeLong(id, this.namespace, name, mediaType, description, taggerType));
        if (attrType.getDisplayHints().contains((Object)DisplayHint.MultiLine)) {
            attrType.addDisplayHint(DisplayHint.SingleLine);
        }
        return attrType;
    }

    public @NonNull AttributeTypeLong createLong(Long id, String name, String mediaType, String description) {
        return this.createLong(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType));
    }

    public @NonNull AttributeTypeLong createLongNoTag(Long id, String name, String mediaType, String description) {
        return this.createLong(id, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> T createEnum(T attributeType) {
        return (T)((AttributeTypeEnum)this.attributeTypes.addAndReturn(attributeType));
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> T createEnumNoTag(T attributeType) {
        return (T)((AttributeTypeEnum)this.attributeTypes.addAndReturn(attributeType));
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> T createEnum(QuinFunction<Long, String, TaggerTypeToken, String, NamespaceToken, T> attributeEnumConstructor, Long id, String name, String mediaType) {
        return (T)((AttributeTypeEnum)this.attributeTypes.addAndReturn((Object)((AttributeTypeEnum)attributeEnumConstructor.apply((Object)id, (Object)name, (Object)OrcsTypeTokens.determineTaggerType(mediaType), (Object)mediaType, (Object)this.namespace))));
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> T createEnumNoTag(QuinFunction<Long, String, TaggerTypeToken, String, NamespaceToken, T> attributeEnumConstructor, Long id, String name, String mediaType) {
        return (T)((AttributeTypeEnum)this.attributeTypes.addAndReturn((Object)((AttributeTypeEnum)attributeEnumConstructor.apply((Object)id, (Object)name, (Object)OrcsTypeTokens.determineTaggerType(mediaType), (Object)mediaType, (Object)this.namespace))));
    }

    public @NonNull DynamicEnumAttributeType createEnum(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return (DynamicEnumAttributeType)this.attributeTypes.addAndReturn((Object)new DynamicEnumAttributeType(id, this.namespace, name, mediaType, description, taggerType));
    }

    public @NonNull DynamicEnumAttributeType createEnum(Long id, String name, String mediaType, String description) {
        return this.createEnum(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType));
    }

    public @NonNull AttributeTypeString createString(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, String fileExtension, DisplayHint ... displayHints) {
        return (AttributeTypeString)this.attributeTypes.addAndReturn((Object)new AttributeTypeString(id, this.namespace, name, mediaType, description, taggerType, fileExtension, displayHints));
    }

    public @NonNull AttributeTypeString createString(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createString(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), OrcsTypeTokens.defaultFileExtension(mediaType), displayHints);
    }

    public @NonNull AttributeTypeString createString(Long id, String name, String mediaType, String description, String fileExtension, DisplayHint ... displayHints) {
        return this.createString(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), fileExtension, displayHints);
    }

    public @NonNull AttributeTypeString createStringNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createString(id, name, mediaType, description, TaggerTypeToken.SENTINEL, OrcsTypeTokens.defaultFileExtension(mediaType), new DisplayHint[0]);
    }

    public @NonNull AttributeTypeString createStringNoTag(Long id, String name, String mediaType, String description, String fileExtension) {
        return this.createString(id, name, mediaType, description, TaggerTypeToken.SENTINEL, fileExtension, new DisplayHint[0]);
    }

    public <T, U extends ComputedCharacteristic<T>> U createComp(SexFunction<Long, String, TaggerTypeToken, NamespaceToken, String, List<AttributeTypeGeneric<T>>, U> computationCharacteristicConstructor, Long id, String name, String description, AttributeTypeGeneric<T> ... typesToCompute) {
        return (U)((ComputedCharacteristic)this.computedCharacteristics.addAndReturn((Object)((ComputedCharacteristic)computationCharacteristicConstructor.apply((Object)id, (Object)name, (Object)TaggerTypeToken.PlainTextTagger, (Object)this.namespace, (Object)description, Arrays.asList(typesToCompute)))));
    }

    public <T, U extends ComputedCharacteristic<T>> U createCompNoTag(SexFunction<Long, String, TaggerTypeToken, NamespaceToken, String, List<AttributeTypeGeneric<T>>, U> computationCharacteristicConstructor, Long id, String name, String description, AttributeTypeGeneric<T> ... typesToCompute) {
        return (U)((ComputedCharacteristic)this.computedCharacteristics.addAndReturn((Object)((ComputedCharacteristic)computationCharacteristicConstructor.apply((Object)id, (Object)name, (Object)TaggerTypeToken.SENTINEL, (Object)this.namespace, (Object)description, Arrays.asList(typesToCompute)))));
    }

    public <U extends ComputedCharacteristic<EnumToken>> U createComp(SexFunction<Long, String, TaggerTypeToken, NamespaceToken, String, List<AttributeTypeGeneric<EnumToken>>, U> computationCharacteristicConstructor, Long id, String name, String description, AttributeTypeEnum<?> ... typesToCompute) {
        return (U)((ComputedCharacteristic)this.computedCharacteristics.addAndReturn((Object)((ComputedCharacteristic)computationCharacteristicConstructor.apply((Object)id, (Object)name, (Object)TaggerTypeToken.PlainTextTagger, (Object)this.namespace, (Object)description, this.createEnumList(typesToCompute)))));
    }

    public <U extends ComputedCharacteristic<EnumToken>> U createCompNoTag(SexFunction<Long, String, TaggerTypeToken, NamespaceToken, String, List<AttributeTypeGeneric<EnumToken>>, U> computationCharacteristicConstructor, Long id, String name, String description, AttributeTypeEnum<?> ... typesToCompute) {
        return (U)((ComputedCharacteristic)this.computedCharacteristics.addAndReturn((Object)((ComputedCharacteristic)computationCharacteristicConstructor.apply((Object)id, (Object)name, (Object)TaggerTypeToken.SENTINEL, (Object)this.namespace, (Object)description, this.createEnumList(typesToCompute)))));
    }

    private List<AttributeTypeGeneric<EnumToken>> createEnumList(AttributeTypeEnum<?>[] typesToCompute) {
        ArrayList<AttributeTypeGeneric<EnumToken>> enumsToCompute = new ArrayList<AttributeTypeGeneric<EnumToken>>();
        AttributeTypeEnum<?>[] attributeTypeEnumArray = typesToCompute;
        int n = typesToCompute.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeTypeEnum<?> enumType = attributeTypeEnumArray[n2];
            enumsToCompute.add(enumType.getAsEnumToken());
            ++n2;
        }
        return enumsToCompute;
    }

    public static TaggerTypeToken determineTaggerType(String mediaType) {
        switch (mediaType) {
            case "text/html": 
            case "application/msword": {
                return TaggerTypeToken.XmlTagger;
            }
        }
        return TaggerTypeToken.PlainTextTagger;
    }

    public static String defaultFileExtension(String mediaType) {
        switch (mediaType) {
            case "application/zip": 
            case "text/plain": {
                return "txt";
            }
            case "text/xml": 
            case "application/msword": {
                return "xml";
            }
            case "text/html": {
                return "html";
            }
            case "application/octet-stream": 
            case "image/*": {
                return "bin";
            }
        }
        return "";
    }

    public int size() {
        return this.artifactTypes.size() + this.attributeTypes.size() + this.relationTypes.size();
    }

    public String toString() {
        return this.namespace + ": " + this.size();
    }

    public ArtifactTypeJoin artifactTypeJoin(String name, ArtifactTypeToken ... artifactTypes) {
        ArtifactTypeJoin typeJoin = new ArtifactTypeJoin(name, artifactTypes);
        this.orcsTypeJoins.add(typeJoin);
        return typeJoin;
    }

    public AttributeTypeJoin attributeTypeJoin(String name, AttributeTypeToken ... attributeTypes) {
        AttributeTypeJoin typeJoin = new AttributeTypeJoin(name, attributeTypes);
        this.orcsTypeJoins.add(typeJoin);
        return typeJoin;
    }

    public RelationTypeJoin relationTypeJoin(String name, RelationTypeToken ... relationTypes) {
        RelationTypeJoin typeJoin = new RelationTypeJoin(name, relationTypes);
        this.orcsTypeJoins.add(typeJoin);
        return typeJoin;
    }
}

