/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceSubMessageToken
extends PLGenericDBObject {
    public static final InterfaceSubMessageToken SENTINEL = new InterfaceSubMessageToken();
    private String Name;
    private String InterfaceSubMessageNumber;
    private String Description;
    private ApplicabilityToken applicability;
    private boolean autogenerated = false;
    private ArtifactReadable artifactReadable;

    public InterfaceSubMessageToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceSubMessageToken(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName(art.getName());
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setInterfaceSubMessageNumber(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceSubMessageNumber, ""));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        this.artifactReadable = art;
    }

    public InterfaceSubMessageToken(Long id, String name, String description, String subMessageNumber, ApplicabilityToken applicabilityToken) {
        super(id, name);
        this.setDescription(description);
        this.setInterfaceSubMessageNumber(subMessageNumber);
        this.setApplicability(applicabilityToken);
    }

    public InterfaceSubMessageToken(Long id, String name) {
        super(id, name);
    }

    public InterfaceSubMessageToken() {
    }

    public String getInterfaceSubMessageNumber() {
        return this.InterfaceSubMessageNumber;
    }

    public void setInterfaceSubMessageNumber(String interfaceSubMessageNumber) {
        this.InterfaceSubMessageNumber = interfaceSubMessageNumber;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public void setAutogenerated(boolean autogenerated) {
        this.autogenerated = autogenerated;
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.artifactReadable;
    }
}

