/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceEnumerationApi;
import org.eclipse.osee.mim.InterfaceEnumerationSetApi;
import org.eclipse.osee.mim.internal.InterfaceEnumerationSetAccessor;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfaceEnumerationSetApiImpl
implements InterfaceEnumerationSetApi {
    private ArtifactAccessor<InterfaceEnumerationSet> accessor;
    private final InterfaceEnumerationApi interfaceEnumerationApi;

    public InterfaceEnumerationSetApiImpl(OrcsApi orcsApi, InterfaceEnumerationApi interfaceEnumerationApi) {
        this.setAccessor(new InterfaceEnumerationSetAccessor(orcsApi));
        this.interfaceEnumerationApi = interfaceEnumerationApi;
    }

    @Override
    public ArtifactAccessor<InterfaceEnumerationSet> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceEnumerationSet> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<InterfaceEnumerationSet> query(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public InterfaceEnumerationSet get(BranchId branch, ArtifactId enumSetId) {
        try {
            InterfaceEnumerationSet enumSet = this.getAccessor().get(branch, enumSetId, InterfaceEnumerationSet.class);
            enumSet.setEnumerations((List)this.interfaceEnumerationApi.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceEnumeration_EnumerationSet, ArtifactId.valueOf((Long)enumSet.getId()), InterfaceEnumeration.class));
            return enumSet;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceEnumerationSet.SENTINEL;
        }
    }

    @Override
    public List<InterfaceEnumerationSet> getAll(BranchId branch) {
        try {
            List enumSet = (List)this.getAccessor().getAll(branch, InterfaceEnumerationSet.class);
            for (InterfaceEnumerationSet set : enumSet) {
                set.setEnumerations((List)this.interfaceEnumerationApi.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceEnumeration_EnumerationSet, ArtifactId.valueOf((Long)set.getId()), InterfaceEnumeration.class));
            }
            return enumSet;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceEnumerationSet>();
        }
    }

    @Override
    public Collection<InterfaceEnumerationSet> queryExact(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<InterfaceEnumerationSet> query(BranchId branch, MimAttributeQuery query, boolean isExact) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, isExact, InterfaceEnumerationSet.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceEnumerationSet>();
        }
    }
}

