/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.util.RestUtil;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.Operator;

public class CommonUtil {
    public static BranchId getCommonBranch(OrcsApi orcsApi) throws OseeCoreException {
        return CoreBranches.COMMON;
    }

    public static BranchId getCommonBranch() throws OseeCoreException {
        return CommonUtil.getCommonBranch(OseeCoreData.getOrcsApi());
    }

    public static ArtifactReadable getCurrentUser(OrcsApi orcsApi, String currentLoggedInUser) throws OseeCoreException {
        if (currentLoggedInUser != null && !currentLoggedInUser.isEmpty()) {
            ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.UserId, currentLoggedInUser, QueryOption.EXACT_MATCH_OPTIONS).getResults().getExactlyOne();
            return exactlyOne;
        }
        return (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{SystemUser.OseeSystem}).getResults().getExactlyOne();
    }

    public static ArtifactReadable getUserFromGivenUserId(String userId) throws OseeCoreException {
        return CommonUtil.getCurrentUser(OseeCoreData.getOrcsApi(), userId);
    }

    public static ArtifactReadable getArtifactFromIdExcludingDeleted(String guidOrHrid, BranchId branchId, OrcsApi orcsApi) throws OseeCoreException {
        ArtifactReadable ai = null;
        ai = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch(branchId).andUuid(Long.valueOf(guidOrHrid).longValue()).excludeDeleted().getResults().getExactlyOne();
        return ai;
    }

    public static ArtifactReadable getArtifactFromIdExcludingDeleted(String guidOrHrid, BranchToken branch) throws OseeCoreException {
        return CommonUtil.getArtifactFromIdExcludingDeleted(guidOrHrid, (BranchId)branch, OseeCoreData.getOrcsApi());
    }

    public static ArtifactReadable getArtifactFromIdExcludingDeleted(String guidOrHrid) throws OseeCoreException {
        return CommonUtil.getArtifactFromIdExcludingDeleted(guidOrHrid, CommonUtil.getCommonBranch(), OseeCoreData.getOrcsApi());
    }

    public static Date getDate(String dateString) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E MMM dd hh:mm:ss zzz yyyy", Locale.getDefault());
            Date parse = simpleDateFormat.parse(dateString);
            return parse;
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.getDefault());
                Date parse = simpleDateFormat.parse(dateString);
                return parse;
            }
            catch (ParseException e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static String getCurrentDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public static List<ITransferableArtifact> getBasicAssignees(String xml) {
        HashSet<String> users = new HashSet<String>();
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        ArrayList<ITransferableArtifact> assignees = new ArrayList<ITransferableArtifact>();
        StringTokenizer tok = new StringTokenizer(xml, ";");
        int countTokens = tok.countTokens();
        if (countTokens >= 2) {
            tok.nextElement();
            String assiStr = tok.nextToken();
            Matcher m2 = Pattern.compile("<(.+?)>").matcher(assiStr);
            while (m2.find()) {
                assiStr = m2.group(1);
                if (assiStr.equalsIgnoreCase("undefined")) continue;
                users.add(assiStr);
            }
        }
        for (String userId : users) {
            try {
                ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.UserId, userId, new QueryOption[0]).getResults().getExactlyOne();
                TransferableArtifact user = new TransferableArtifact();
                TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(exactlyOne, (ITransferableArtifact)user);
                AttributeReadable userIDAttr = (AttributeReadable)exactlyOne.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne();
                String userIDStr = (String)userIDAttr.getValue();
                user.putAttributes("User Id", Arrays.asList(userIDStr));
                assignees.add((ITransferableArtifact)user);
            }
            catch (OseeCoreException e) {
                e.printStackTrace();
            }
        }
        return assignees;
    }

    public static List<ITransferableArtifact> getAssignees(String xml) {
        HashSet<String> users = new HashSet<String>();
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        ArrayList<ITransferableArtifact> assignees = new ArrayList<ITransferableArtifact>();
        StringTokenizer tok = new StringTokenizer(xml, ";");
        int countTokens = tok.countTokens();
        if (countTokens >= 2) {
            tok.nextElement();
            String assiStr = tok.nextToken();
            Matcher m2 = Pattern.compile("<(.+?)>").matcher(assiStr);
            while (m2.find()) {
                assiStr = m2.group(1);
                if (assiStr.equalsIgnoreCase("undefined")) continue;
                users.add(assiStr);
            }
        }
        for (String userId : users) {
            try {
                ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.UserId, userId, QueryOption.EXACT_MATCH_OPTIONS).getResults().getExactlyOne();
                TransferableArtifact user = new TransferableArtifact();
                TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(exactlyOne, (ITransferableArtifact)user);
                assignees.add((ITransferableArtifact)user);
            }
            catch (OseeCoreException e) {
                e.printStackTrace();
            }
        }
        return assignees;
    }

    public static TransferableArtifact getCompletedByUser(ArtifactReadable readable) {
        ResultSet attrCompletedBy = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CompletedBy);
        if (attrCompletedBy.size() > 0) {
            String string = ((AttributeReadable)attrCompletedBy.getExactlyOne()).getValue().toString();
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.UserId, Operator.EQUAL.toString(), new QueryOption[]{QueryOption.valueOf((String)string)}).getResults().getExactlyOne();
            TransferableArtifact user = new TransferableArtifact();
            TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(exactlyOne, (ITransferableArtifact)user);
            return user;
        }
        return null;
    }

    public static TransferableArtifact getBasicCompletedByUser(ArtifactReadable readable) {
        ResultSet attrCompletedBy = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CompletedBy);
        if (attrCompletedBy.size() > 0) {
            String string = ((AttributeReadable)attrCompletedBy.getExactlyOne()).getValue().toString();
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.UserId, string, new QueryOption[0]).getResults().getExactlyOne();
            TransferableArtifact user = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(exactlyOne, (ITransferableArtifact)user);
            AttributeReadable userIDAttr = (AttributeReadable)exactlyOne.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne();
            String userIDStr = (String)userIDAttr.getValue();
            user.putAttributes("User Id", Arrays.asList(userIDStr));
            return user;
        }
        return null;
    }

    public static TransferableArtifact getCancelledBy(ArtifactReadable readable) {
        ResultSet attrCompletedBy = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CancelledBy);
        if (attrCompletedBy.size() > 0) {
            String string = ((AttributeReadable)attrCompletedBy.getExactlyOne()).getValue().toString();
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.UserId, Operator.EQUAL.toString(), new QueryOption[]{QueryOption.valueOf((String)string)}).getResults().getExactlyOne();
            TransferableArtifact user = new TransferableArtifact();
            TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(exactlyOne, (ITransferableArtifact)user);
            return user;
        }
        return null;
    }

    public static TransferableArtifact getBasicCancelledBy(ArtifactReadable readable) {
        ResultSet attrCompletedBy = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CancelledBy);
        if (attrCompletedBy.size() > 0) {
            String string = ((AttributeReadable)attrCompletedBy.getExactlyOne()).getValue().toString();
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.UserId, string, new QueryOption[0]).getResults().getExactlyOne();
            TransferableArtifact user = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(exactlyOne, (ITransferableArtifact)user);
            AttributeReadable userIDAttr = (AttributeReadable)exactlyOne.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne();
            String userIDStr = (String)userIDAttr.getValue();
            user.putAttributes("User Id", Arrays.asList(userIDStr));
            return user;
        }
        return null;
    }

    public static List<ArtifactReadable> getRelatedArtifact(ArtifactReadable artifact, String relationName) {
        ArrayList<ArtifactReadable> listTeamArtifact = new ArrayList<ArtifactReadable>();
        try {
            Collection existingRelationTypes = artifact.getExistingRelationTypes();
            for (RelationTypeToken iRelationType : existingRelationTypes) {
                RelationTypeSide createRelationTypeSide1;
                ResultSet relatedArtifactsTemp2;
                if (!iRelationType.getName().equals(relationName)) continue;
                RelationTypeSide createRelationTypeSide = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_B);
                ResultSet relatedArtifactsTemp1 = artifact.getRelated(createRelationTypeSide);
                if (relatedArtifactsTemp1.size() > 0) {
                    Iterator iterator = relatedArtifactsTemp1.iterator();
                    while (iterator.hasNext()) {
                        listTeamArtifact.add((ArtifactReadable)iterator.next());
                    }
                }
                if ((relatedArtifactsTemp2 = artifact.getRelated(createRelationTypeSide1 = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_A))).size() > 0) {
                    Iterator iterator = relatedArtifactsTemp2.iterator();
                    while (iterator.hasNext()) {
                        listTeamArtifact.add((ArtifactReadable)iterator.next());
                    }
                }
                break;
            }
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return listTeamArtifact;
    }

    public static double getActualWorkedHours(ArtifactReadable readable) {
        String totalHoursString;
        double actualHours = 0.0;
        ResultSet attributes = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentState);
        for (AttributeReadable attributeReadable : attributes) {
            String totalHoursString2 = RestUtil.getTotalHoursString((String)attributeReadable.getValue().toString());
            if (totalHoursString2.length() <= 0) continue;
            actualHours = Double.parseDouble(totalHoursString2);
        }
        ResultSet attributes1 = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.State);
        for (AttributeReadable attributeReadable : attributes1) {
            String totalHoursString3 = RestUtil.getTotalHoursString((String)attributeReadable.getValue().toString());
            if (totalHoursString3.length() <= 0) continue;
            actualHours += Double.parseDouble(totalHoursString3);
        }
        ResultSet relatedArtifacts = OseeCoreData.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Task}).andRelatedTo(AtsRelationTypes.TeamWfToTask_TeamWorkflow, (ArtifactId)readable).getResults();
        for (ArtifactReadable subtask : relatedArtifacts) {
            ResultSet attributes2 = subtask.getAttributes((AttributeTypeToken)AtsAttributeTypes.State);
            for (AttributeReadable attributeReadable : attributes2) {
                String totalHoursString4 = RestUtil.getTotalHoursString((String)attributeReadable.getValue().toString());
                if (totalHoursString4.length() <= 0) continue;
                actualHours += Double.parseDouble(totalHoursString4);
            }
            ResultSet attributes3 = subtask.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentState);
            for (AttributeReadable attributeReadable : attributes3) {
                totalHoursString = RestUtil.getTotalHoursString((String)attributeReadable.getValue().toString());
                if (totalHoursString.length() <= 0) continue;
                actualHours += Double.parseDouble(totalHoursString);
            }
        }
        ResultSet relatedArtifacts1 = OseeCoreData.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.PeerToPeerReview}).andRelatedTo(AtsRelationTypes.TeamWorkflowToReview_TeamWorkflow, (ArtifactId)readable).getResults();
        for (ArtifactReadable subtask : relatedArtifacts1) {
            ResultSet attributes2 = subtask.getAttributes((AttributeTypeToken)AtsAttributeTypes.State);
            for (AttributeReadable attributeReadable : attributes2) {
                totalHoursString = RestUtil.getTotalHoursString((String)attributeReadable.getValue().toString());
                if (totalHoursString.length() <= 0) continue;
                actualHours += Double.parseDouble(totalHoursString);
            }
            ResultSet attributes3 = subtask.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentState);
            for (AttributeReadable attributeReadable : attributes3) {
                String totalHoursString5 = RestUtil.getTotalHoursString((String)attributeReadable.getValue().toString());
                if (totalHoursString5.length() <= 0) continue;
                actualHours += Double.parseDouble(totalHoursString5);
            }
        }
        return actualHours;
    }

    public static ResultSet<ArtifactReadable> getAllProjectsAsArtifactReadable() {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Project}).getResults();
        return list;
    }

    public static String getAttributeValue(ArtifactReadable artifactReadable, AttributeTypeToken attributeType) {
        return CommonUtil.getAttributeValue(artifactReadable, attributeType, "");
    }

    private static <T> T getAttributeValue(ArtifactReadable artifactReadable, AttributeTypeToken attributeType, T defaultValue) {
        AttributeReadable readable = (AttributeReadable)artifactReadable.getAttributes(attributeType).getOneOrNull();
        if (readable != null) {
            return (T)readable.getValue();
        }
        return defaultValue;
    }

    public static ResultSet<ArtifactReadable> getReleasesForProject(String projectGuid) {
        ArtifactReadable project = CommonUtil.getArtifactFromIdExcludingDeleted(projectGuid);
        return OseeCoreData.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Version}).andRelatedTo(AtsRelationTypes.ProjectToVersion_Project, (ArtifactId)project).getResults();
    }

    public static List<ITransferableArtifact> getBasicAssigneesInfo(String xml) {
        HashSet<String> users = new HashSet<String>();
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        ArrayList<ITransferableArtifact> assignees = new ArrayList<ITransferableArtifact>();
        StringTokenizer tok = new StringTokenizer(xml, ";");
        int countTokens = tok.countTokens();
        if (countTokens >= 2) {
            tok.nextElement();
            String assiStr = tok.nextToken();
            Matcher m2 = Pattern.compile("<(.+?)>").matcher(assiStr);
            while (m2.find()) {
                assiStr = m2.group(1);
                users.add(assiStr);
            }
        }
        for (String userId : users) {
            try {
                ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.UserId, userId, new QueryOption[0]).getResults().getExactlyOne();
                TransferableArtifact user = new TransferableArtifact();
                TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(exactlyOne, (ITransferableArtifact)user);
                user.putAttributes(CoreAttributeTypes.UserId.toString(), Arrays.asList(((AttributeReadable)exactlyOne.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne()).toString()));
                assignees.add((ITransferableArtifact)user);
            }
            catch (OseeCoreException e) {
                e.printStackTrace();
            }
        }
        return assignees;
    }

    public static List<Float> getPracticalStoryPointsData(float noOfDays, float totalStoryPoints) {
        float segement1 = noOfDays * 0.5f;
        float segment2 = noOfDays * 0.3f + segement1;
        float segment3 = noOfDays * 0.2f + segment2;
        float segement4 = noOfDays * 0.05f + segment3;
        int segmentTracker = 1;
        float total = totalStoryPoints;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int i = 1;
        while ((float)i <= noOfDays) {
            float value = 0.0f;
            if (!((float)i > segement1)) {
                segmentTracker = 1;
            } else if (!((float)i > segment2)) {
                segmentTracker = 2;
            } else if (!((float)i > segment3)) {
                segmentTracker = 3;
            } else if (!((float)i > segement4)) {
                segmentTracker = 4;
            }
            if (segmentTracker == 1) {
                if (i == 1) {
                    value = totalStoryPoints;
                } else {
                    total = value = total - totalStoryPoints * 0.01f;
                }
            } else if (segmentTracker == 2) {
                total = value = total - totalStoryPoints * 0.03f;
            } else if (segmentTracker == 3) {
                total = value = total - totalStoryPoints * 0.1f;
            }
            if ((float)i == noOfDays) {
                value = 0.0f;
            }
            arrayList.add(Float.valueOf(value));
            ++i;
        }
        return arrayList;
    }
}

