/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractSaxHandler
extends DefaultHandler
implements LexicalHandler {
    private final StringBuilder contents = new StringBuilder(2000);
    private final int maxContentLength;

    protected AbstractSaxHandler() {
        this(0);
    }

    protected AbstractSaxHandler(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.maxContentLength > 0 && this.contents.length() + length > this.maxContentLength) {
            return;
        }
        this.contents.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.endElementFound(uri, localName, qName);
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        this.contents.setLength(0);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.startElementFound(uri, localName, qName, attributes);
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        this.contents.setLength(0);
    }

    public abstract void startElementFound(String var1, String var2, String var3, Attributes var4) throws Exception;

    public abstract void endElementFound(String var1, String var2, String var3) throws Exception;

    public String getContents() {
        return this.contents.toString();
    }

    public void addContentsTo(Appendable appendable) throws IOException {
        appendable.append(this.contents);
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    @Override
    public void endCDATA() {
        this.contents.append("]]>");
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
        this.contents.append("<![CDATA[");
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
    }

    @Override
    public void startEntity(String name) {
    }
}

