/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util.health.check;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheck;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class TestDuplicateAttributesWithPersist
implements IAtsHealthCheck {
    public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
        for (IAttribute attr : atsApi.getAttributeResolver().getAttributes(workItem)) {
            if (attr.getValue() != null) continue;
            this.error(results, workItem, "Error: Types: " + attr.getAttributeType().getName() + " - Null Attribute", new Object[0]);
            if (changes == null) continue;
            changes.deleteAttribute(workItem, attr);
        }
        CountingMap typeCount = new CountingMap();
        HashCollection attrsByType = new HashCollection();
        for (IAttribute attr : atsApi.getAttributeResolver().getAttributes(workItem)) {
            typeCount.put((Object)attr.getAttributeType());
            attrsByType.put((Object)attr.getAttributeType(), (Object)attr);
        }
        for (Map.Entry entry : attrsByType.entrySet()) {
            AttributeReadable attr;
            AttributeTypeToken attrType = (AttributeTypeToken)entry.getKey();
            if (attrType.getName().contains("Mising Attribute Type ")) {
                results.log((ArtifactId)workItem.getStoreObject(), String.valueOf(this.getClass().getSimpleName()) + ".MissingAttributeType", String.format("Error: %s for " + workItem.getAtsId(), attrType.getName()));
                continue;
            }
            ArtifactReadable art = (ArtifactReadable)artifact;
            int count = ((List)entry.getValue()).size();
            int max = art.getArtifactType().getMax(attrType);
            if (count <= art.getArtifactType().getMax(attrType)) continue;
            String result = String.format("Artifact: %s Type [%s] AttrType [%s] Max [%d] Actual [%d]", artifact.toStringWithId(), art.getArtifactType().getName(), attrType.getName(), max, count);
            HashMap<String, AttributeReadable> valuesAttrMap = new HashMap<String, AttributeReadable>();
            GammaId latestGamma = GammaId.valueOf((int)0);
            StringBuffer fixInfo = new StringBuffer(" - FIX AVAILABLE");
            for (IAttribute attr2 : (List)entry.getValue()) {
                attr = (AttributeReadable)attr2;
                if (attr.getGammaId().isValid()) {
                    latestGamma = attr.getGammaId();
                }
                String info = String.format("[Gamma [%s] Value [%s]]", attr.getGammaId(), attr.getValue());
                valuesAttrMap.put(info, attr);
                fixInfo.append(info);
            }
            fixInfo.append(" - KEEP Gamma ");
            fixInfo.append(latestGamma);
            if (latestGamma.isValid()) {
                result = String.valueOf(result) + fixInfo;
                if (changes != null) {
                    for (IAttribute attr2 : (List)entry.getValue()) {
                        attr = (AttributeReadable)attr2;
                        if (!attr.getGammaId().notEqual((Id)latestGamma)) continue;
                        changes.deleteAttribute(workItem, (IAttribute)attr);
                    }
                    result = String.valueOf(result) + result + " - Fixed";
                }
            }
            this.error(results, workItem, result, new Object[0]);
        }
    }
}

