/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util.health;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheck;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheckProvider;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.rest.internal.notify.OseeEmailServer;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthCheckProviderService;
import org.eclipse.osee.ats.rest.internal.util.health.check.AtsHealthQueries;
import org.eclipse.osee.ats.rest.internal.util.health.check.TestDuplicateAttributesWithPersist;
import org.eclipse.osee.ats.rest.internal.util.health.check.TestTaskParent;
import org.eclipse.osee.ats.rest.internal.util.health.check.TestWorkflowVersions;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.util.OseeEmail;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.ILoggerListener;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.logging.SevereLoggingMonitor;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;

public class AtsHealthCheckOperation {
    private final AtsApi atsApi;
    private final JdbcService jdbcService;
    boolean inTest = false;
    boolean persist = false;

    public AtsHealthCheckOperation(AtsApi atsApi, JdbcService jdbcService) {
        this.atsApi = atsApi;
        this.jdbcService = jdbcService;
    }

    public XResultData run() {
        XResultData rd = new XResultData();
        try {
            ElapsedTime time = new ElapsedTime("ATS Health Check", false, true);
            this.runIt(rd);
            String elapsedStr = time.end(ElapsedTime.Units.SEC);
            rd.log("\n\n" + elapsedStr);
            this.emailResults(rd);
        }
        catch (Exception ex) {
            rd.errorf("Exception running reports [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    private void emailResults(XResultData rd) {
        String dbName = "";
        String configDbName = this.atsApi.getConfigValue("DatabaseName");
        if (Strings.isValid((String)configDbName)) {
            dbName = " " + configDbName;
        }
        OseeEmailServer emailMessage = OseeEmailServer.create(Arrays.asList("noop@osee.com"), "donald.g.dunne@boeing.com", "donald.g.dunne@boeing.com", String.valueOf(dbName) + " - ATS Health Check", AHTML.simplePage((String)rd.toString().replaceAll("\n", "</br>")), OseeEmail.BodyType.Html);
        emailMessage.send();
    }

    public void runIt(XResultData rd) {
        SevereLoggingMonitor monitorLog = new SevereLoggingMonitor();
        OseeLog.registerLoggerListener((ILoggerListener)monitorLog);
        int count = 0;
        HealthCheckResults vResults = new HealthCheckResults();
        if (this.inTest) {
            vResults.log("testMap1", "blah blah");
            vResults.log("testMap2", "blah blah");
            vResults.log("testMap1", "blah blah");
            vResults.log("testMap3", "blah blah");
        } else {
            List<IAtsHealthCheck> checks = this.getHealthChecks();
            for (IAtsHealthCheck check : checks) {
                check.check(vResults, this.atsApi);
            }
            IAtsChangeSet changes = this.atsApi.createChangeSet(this.getClass().getSimpleName());
            List<Collection<Long>> artIdLists = this.loadWorkingWorkItemIds(rd);
            for (Collection<Long> artIdList : artIdLists) {
                Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(artIdList);
                ArrayList<ArtifactToken> artifacts = new ArrayList<ArtifactToken>(allArtifacts.size());
                for (ArtifactToken artifact : allArtifacts) {
                    if (this.atsApi.getStoreService().isDeleted((ArtifactId)artifact)) continue;
                    artifacts.add(artifact);
                }
                count += artifacts.size();
                for (ArtifactToken artifact : artifacts) {
                    for (IAtsHealthCheck check : checks) {
                        Date date = new Date();
                        try {
                            if (this.atsApi.getStoreService().isDeleted((ArtifactId)artifact)) continue;
                            IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(artifact);
                            check.check(artifact, workItem, vResults, this.atsApi, (IAtsChangeSet)(this.persist ? changes : null));
                        }
                        catch (Exception ex) {
                            vResults.log((ArtifactId)artifact, check.getName(), "Error: Exception: " + Lib.exceptionToString((Exception)ex));
                        }
                        vResults.logTestTimeSpent(date, check.getName());
                    }
                }
            }
            if (this.persist) {
                changes.executeIfNeeded();
            }
            checks = null;
        }
        vResults.addResultsMapToResultData(rd);
        vResults.addTestTimeMapToResultData(rd);
        rd.logf("Completed processing %s work items.", new Object[]{count});
    }

    private List<IAtsHealthCheck> getHealthChecks() {
        LinkedList<IAtsHealthCheck> healthChecks = new LinkedList<IAtsHealthCheck>();
        healthChecks.add(new TestTaskParent());
        healthChecks.add(new TestWorkflowTeamDefinition());
        healthChecks.add(new TestWorkflowVersions());
        healthChecks.add(new TestWorkflowDefinition());
        healthChecks.add(new TestStateMgr());
        healthChecks.add(new TestCurrentStateIsInWorkDef());
        healthChecks.add(new TestWorkflowHasAction());
        healthChecks.add(new TestTeamDefinitions());
        healthChecks.add(new TestActionableItems());
        healthChecks.add(new TestVersions());
        healthChecks.add(new TestTeamWorkflows());
        healthChecks.add(new TestBranches());
        for (IAtsHealthCheckProvider provider : AtsHealthCheckProviderService.getHealthCheckProviders()) {
            healthChecks.addAll(provider.getHealthChecks());
        }
        healthChecks.add(new TestDuplicateAttributesWithPersist());
        healthChecks.add(new TestDuplicateArtEntries());
        return healthChecks;
    }

    private List<Long> getInvalidIds(List<Long> ids) {
        ArrayList<Long> badIds = new ArrayList<Long>();
        for (Long id : ids) {
            if (this.atsApi.getQueryService().getArtifact(id) != null) continue;
            badIds.add(id);
        }
        return badIds;
    }

    private List<Collection<Long>> loadWorkingWorkItemIds(XResultData rd) {
        rd.log("testLoadAllCommonArtifactIds - Started " + DateUtil.getMMDDYYHHMM());
        List<Long> artIds = this.getCommonArtifactIds(rd);
        if (artIds.isEmpty()) {
            rd.error("Error: Artifact load returned 0 artifacts to check");
        }
        rd.log("testLoadAllCommonArtifactIds - Completed " + DateUtil.getMMDDYYHHMM());
        return Collections.subDivide(artIds, (int)4000);
    }

    private List<Long> getCommonArtifactIds(XResultData rd) {
        ArrayList<Long> artIds = new ArrayList<Long>();
        rd.log("getCommonArtifactIds - Started " + DateUtil.getMMDDYYHHMM());
        JdbcStatement chStmt = this.jdbcService.getClient().getStatement();
        try {
            chStmt.runPreparedQuery(AtsHealthQueries.getWorkItemsInCurrentStateType(this.atsApi, StateType.Working), new Object[0]);
            while (chStmt.next()) {
                artIds.add(chStmt.getLong(1));
            }
        }
        finally {
            chStmt.close();
            rd.log("getCommonArtifactIds - Completed " + DateUtil.getMMDDYYHHMM());
        }
        return artIds;
    }

    private class TestActionableItems
    implements IAtsHealthCheck {
        private TestActionableItems() {
        }

        public void check(HealthCheckResults results, AtsApi atsApi) {
            for (ArtifactToken aiArt : atsApi.getQueryService().getArtifacts(AtsArtifactTypes.ActionableItem)) {
                ArtifactToken progArt;
                for (AttributeTypeGeneric attributeTypeGeneric : Arrays.asList(AtsAttributeTypes.TeamDefinitionReference)) {
                    for (Object obj : atsApi.getAttributeResolver().getAttributeValues((ArtifactId)aiArt, (AttributeTypeToken)attributeTypeGeneric)) {
                        ArtifactId artId = (ArtifactId)obj;
                        ArtifactToken refArt = atsApi.getQueryService().getArtifact(artId);
                        if (refArt != null) continue;
                        results.log("TestActionableItems", String.format("Invalid %s %s for Actionable Item %s", attributeTypeGeneric.getName(), artId.getId(), aiArt.toStringWithId()));
                    }
                }
                ArtifactId artifactId = (ArtifactId)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)aiArt, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)ArtifactId.SENTINEL);
                if (!artifactId.isValid() || (progArt = atsApi.getQueryService().getArtifact(artifactId)) != null) continue;
                results.log("TestTeamDefinitions", String.format("Invalid Program Id %s for Actionable Item %s", artifactId, aiArt.toStringWithId()));
            }
        }
    }

    private class TestBranches
    implements IAtsHealthCheck {
        private TestBranches() {
        }

        public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
            if (workItem.isTeamWorkflow()) {
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
                try {
                    BranchToken workingBranch = atsApi.getBranchService().getWorkingBranch(teamWf);
                    if (workingBranch != null && workingBranch.isValid() && !atsApi.getBranchService().getBranchType((BranchId)workingBranch).isBaselineBranch()) {
                        Collection branchesLeftToCommit;
                        if (!atsApi.getBranchService().getBranchState((BranchId)workingBranch).isCommitted()) {
                            Collection branchesCommittedTo = atsApi.getBranchService().getBranchesCommittedTo(teamWf);
                            if (!branchesCommittedTo.isEmpty()) {
                                results.log((ArtifactId)artifact, "testAtsBranchManagerA", "Error: TeamWorkflow " + teamWf.toStringWithId() + " has committed branches but working branch [" + workingBranch + "] != COMMITTED");
                            }
                        } else if (!atsApi.getBranchService().isArchived((BranchId)workingBranch) && (branchesLeftToCommit = atsApi.getBranchService().getBranchesLeftToCommit(teamWf)).isEmpty()) {
                            results.log((ArtifactId)artifact, "testAtsBranchManagerA", "Error: TeamWorkflow " + teamWf.toStringWithId() + " has committed all branches but working branch [" + workingBranch + "] != ARCHIVED");
                        }
                    }
                }
                catch (Exception ex) {
                    results.log("testAtsBranchManager", String.valueOf(teamWf.getArtifactTypeName()) + " exception: " + ex.getLocalizedMessage());
                }
            }
        }
    }

    private class TestCurrentStateIsInWorkDef
    implements IAtsHealthCheck {
        private TestCurrentStateIsInWorkDef() {
        }

        public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
            if (workItem.isInWork()) {
                String currentStatename = workItem.getStateMgr().getCurrentStateName();
                IAtsWorkDefinition workDef = workItem.getWorkDefinition();
                if (workDef.getStateByName(currentStatename) == null) {
                    results.log((ArtifactId)artifact, "TestCurrentStateIsInWorkDef", String.format("Error: Current State [%s] not valid for Work Definition [%s] for " + artifact.toStringWithId(), currentStatename, workDef.getName()));
                }
            }
        }
    }

    private class TestDuplicateArtEntries
    implements IAtsHealthCheck {
        private TestDuplicateArtEntries() {
        }

        public void check(HealthCheckResults results, AtsApi atsApi) {
            List artIds = atsApi.getQueryService().getArtifactIdsFromQuery(AtsHealthQueries.getMultipleArtEntriesonCommon(atsApi), new Object[0]);
            if (!artIds.isEmpty()) {
                results.log("TestDuplicateArtEntries", String.format("Error: Duplicate Art Ids [%s]", Collections.toString((String)",", (Iterable)artIds)));
            }
        }
    }

    private class TestStateMgr
    implements IAtsHealthCheck {
        private TestStateMgr() {
        }

        public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
            workItem.getStateMgr();
        }
    }

    private class TestTeamDefinitions
    implements IAtsHealthCheck {
        private TestTeamDefinitions() {
        }

        public void check(HealthCheckResults results, AtsApi atsApi) {
            for (ArtifactToken teamDefArt : atsApi.getQueryService().getArtifacts(AtsArtifactTypes.TeamDefinition)) {
                ArtifactToken progArt;
                String branchId = (String)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"-1");
                BranchId branch = BranchId.valueOf((String)branchId);
                if (branch.isValid()) {
                    BranchToken branchToken = atsApi.getBranchService().getBranch(branch);
                    if (branchToken == null) {
                        results.log("TestTeamDefinitions", String.format("Invalid Branch %s for Team Def %s", branch.getId(), teamDefArt.toStringWithId()));
                    } else if (atsApi.getBranchService().getBranchType((BranchId)branchToken) != BranchType.BASELINE) {
                        results.log("TestTeamDefinitions", String.format("Invalid BranchType %s for Branch %s for Team Def %s", atsApi.getBranchService().getBranchType((BranchId)branchToken), branch.getId(), teamDefArt.toStringWithId()));
                    }
                }
                for (AttributeTypeGeneric attributeTypeGeneric : Arrays.asList(AtsAttributeTypes.WorkflowDefinitionReference, AtsAttributeTypes.RelatedPeerWorkflowDefinitionReference, AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference)) {
                    for (Object obj : atsApi.getAttributeResolver().getAttributeValues((ArtifactId)teamDefArt, (AttributeTypeToken)attributeTypeGeneric)) {
                        ArtifactId workDefId = (ArtifactId)obj;
                        if (!workDefId.isValid() || atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefId) != null) continue;
                        results.log("TestTeamDefinitions", String.format("Invalid WorkDefRef %s for Team Def %s", workDefId.getId(), teamDefArt.toStringWithId()));
                    }
                }
                ArtifactId artifactId = (ArtifactId)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)ArtifactId.SENTINEL);
                if (!artifactId.isValid() || (progArt = atsApi.getQueryService().getArtifact(artifactId)) != null) continue;
                results.log("TestTeamDefinitions", String.format("Invalid Program Id %s for Team Def %s", artifactId, teamDefArt.toStringWithId()));
            }
        }
    }

    private class TestTeamWorkflows
    implements IAtsHealthCheck {
        private TestTeamWorkflows() {
        }

        public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
            if (workItem.isTeamWorkflow()) {
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
                try {
                    List<Long> badIds;
                    if (!atsApi.getActionableItemService().hasActionableItems((IAtsWorkItem)teamWf)) {
                        results.log((ArtifactId)artifact, "TestTeamWorkflows", "Error: TeamWorkflow " + teamWf.toStringWithId() + " has 0 ActionableItems");
                    }
                    if (teamWf.getTeamDefinition() == null) {
                        results.log((ArtifactId)artifact, "TestTeamWorkflows", "Error: TeamWorkflow " + teamWf.toStringWithId() + " has no TeamDefinition");
                    }
                    if (!(badIds = AtsHealthCheckOperation.this.getInvalidIds(AtsObjects.toIds((Collection)atsApi.getActionableItemService().getActionableItems((IAtsWorkItem)teamWf)))).isEmpty()) {
                        results.log((ArtifactId)artifact, "TestTeamWorkflows", "Error: TeamWorkflow " + teamWf.toStringWithId() + " has AI ids that don't exisit " + badIds);
                    }
                }
                catch (Exception ex) {
                    results.log((ArtifactId)artifact, "TestTeamWorkflows", String.valueOf(teamWf.getArtifactTypeName()) + " exception: " + ex.getLocalizedMessage());
                }
            }
        }
    }

    private class TestVersions
    implements IAtsHealthCheck {
        private TestVersions() {
        }

        public void check(HealthCheckResults results, AtsApi atsApi) {
            for (ArtifactToken verArt : atsApi.getQueryService().getArtifacts(AtsArtifactTypes.Version)) {
                Version version = atsApi.getVersionService().getVersionById((ArtifactId)verArt);
                String branchId = (String)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"-1");
                BranchId branch = BranchId.valueOf((String)branchId);
                if (branch.isValid()) {
                    BranchToken branch2 = atsApi.getBranchService().getBranch(branch);
                    if (branch2 == null) {
                        results.log("TestTeamDefinitions", String.format("Invalid Branch %s for Team Def %s", branch.getId(), verArt.toStringWithId()));
                    } else if (atsApi.getBranchService().getBranchType((BranchId)branch2) != BranchType.BASELINE) {
                        results.log("TestTeamDefinitions", String.format("Invalid BranchType %s for Branch %s for Team Def %s", atsApi.getBranchService().getBranchType((BranchId)branch2), branch.getId(), verArt.toStringWithId()));
                    }
                }
                for (IAtsVersion parallelVersion : atsApi.getVersionService().getParallelVersions((IAtsVersion)version)) {
                    if (parallelVersion == null) continue;
                    try {
                        if (!parallelVersion.isBranchInvalid()) continue;
                        results.log((ArtifactId)verArt, "testParallelConfig", "Error: [" + parallelVersion.toStringWithId() + "] in parallel config without parent branch id");
                    }
                    catch (Exception ex) {
                        results.log((ArtifactId)verArt, "testParallelConfig", "Error: " + verArt.getName() + " exception testing testVersionArtifacts: " + ex.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private class TestWorkflowDefinition
    implements IAtsHealthCheck {
        private TestWorkflowDefinition() {
        }

        public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
            if (workItem.getWorkDefinition() == null) {
                this.error(results, workItem, "Workflow has no Work Definition", new Object[0]);
            } else if (workItem.getStateDefinition() == null) {
                this.error(results, workItem, "Workflow can not get State Definition", new Object[0]);
            } else if (workItem.getStateMgr().getCurrentState() == null) {
                this.error(results, workItem, "Workflow can not get current state", new Object[0]);
            }
        }
    }

    private class TestWorkflowHasAction
    implements IAtsHealthCheck {
        private TestWorkflowHasAction() {
        }

        public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
            if (workItem.isReview() && atsApi.getReviewService().isStandAloneReview((Object)workItem)) {
                return;
            }
            if (workItem.hasAction() && workItem.getParentAction() == null) {
                results.log((ArtifactId)artifact, "TestWorkflowHasAction", String.format("Error: Workflow %s has no parent Action", workItem.toStringWithId()));
            }
        }
    }

    private class TestWorkflowTeamDefinition
    implements IAtsHealthCheck {
        private TestWorkflowTeamDefinition() {
        }

        public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
            if (workItem.isTeamWorkflow() && workItem.getParentTeamWorkflow().getTeamDefinition() == null) {
                this.error(results, workItem, "Team workflow has no Team Definition (re-run conversion?)", new Object[0]);
            }
        }
    }
}

