/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;

public class TokenSearchOperations {
    private static String ARTIFACTS_MATCHING_ATTRIBUTE_VALUE_QUERY = "SELECT branch_id, attr.art_id, attr.VALUE AS name FROM OSEE_ATTRIBUTE attr, OSEE_TXS txs WHERE attr.ART_ID IN (ART_IDS_HERE) AND txs.BRANCH_ID = ? AND txs.GAMMA_ID = attr.GAMMA_ID AND txs.TX_CURRENT = 1 AND txs.MOD_TYPE NOT IN (3,5,9,10) AND attr.ATTR_TYPE_ID = ? AND attr.value = ?";

    public static HashCollection<ArtifactId, ArtifactToken> getArtifactTokenListFromRelated(BranchToken branch, Collection<ArtifactId> artifacts, ArtifactTypeId artifactType, RelationTypeSide relationType, OrcsApi orcsApi, JdbcClient jdbcClient) {
        LinkedList<Long> artIds = new LinkedList<Long>();
        String ids = "";
        for (ArtifactId art : artifacts) {
            artIds.add(art.getId());
            ids = String.valueOf(ids) + art.getIdString() + ",";
        }
        ids = ids.replaceFirst(",$", "");
        HashMap<Long, Long> artBIdToArtAId = new HashMap<Long, Long>();
        HashMap<Long, Long> artAIdToArtBId = new HashMap<Long, Long>();
        boolean isSideA = relationType.getSide().isSideA();
        try (JdbcStatement chStmt = jdbcClient.getStatement();){
            String query = OseeSql.ARTIFACT_TO_RELATED_B_ARTIFACT_ID.getSql().replaceFirst("ART_IDS_HERE", ids);
            query = query.replaceAll("REL_SIDE_HERE", isSideA ? "b_art_id" : "a_art_id");
            query = query.replaceAll("REL_TYPE_LINKE_ID_HERE", relationType.getIdString());
            query = query.replaceAll("BRANCH_ID_HERE", branch.getIdString());
            chStmt.runPreparedQuery(query, new Object[0]);
            while (chStmt.next()) {
                Long aArtId = chStmt.getLong("a_art_id");
                Long bArtId = chStmt.getLong("b_art_id");
                artBIdToArtAId.put(bArtId, aArtId);
                artAIdToArtBId.put(aArtId, bArtId);
            }
        }
        chStmt = jdbcClient.getStatement();
        HashCollection artToRelatedTokens = new HashCollection();
        try {
            String query = OseeSql.ARTIFACT_TOKENS_RELATED_TO_ARTIFACT_QUERY.getSql().replaceFirst("ART_IDS_HERE", ids);
            query = query.replaceAll("OPPOSITE_REL_SIDE_HERE", isSideA ? "a_art_id" : "b_art_id");
            query = query.replaceAll("REL_SIDE_HERE", isSideA ? "b_art_id" : "a_art_id");
            query = query.replaceAll("REL_TYPE_LINKE_ID_HERE", relationType.getIdString());
            query = query.replaceAll("BRANCH_ID_HERE", branch.getIdString());
            chStmt.runPreparedQuery(query, new Object[0]);
            while (chStmt.next()) {
                Long artId = chStmt.getLong("art_id");
                ArtifactTypeToken artTypeId = orcsApi.tokenService().getArtifactType(Long.valueOf(chStmt.getLong("art_type_id")));
                String name = chStmt.getString("value");
                ArtifactToken token = ArtifactToken.valueOf((long)artId, (String)name, (BranchToken)branch, (ArtifactTypeToken)artTypeId);
                Long artIdLong = isSideA ? (Long)artAIdToArtBId.get(artId) : (Long)artBIdToArtAId.get(artId);
                ArtifactId aArtId = ArtifactId.valueOf((Long)artIdLong);
                artToRelatedTokens.put((Object)aArtId, (Object)token);
            }
        }
        finally {
            chStmt.close();
        }
        return artToRelatedTokens;
    }

    public static Collection<ArtifactToken> getArtifactTokensMatchingAttrValue(BranchId branch, Collection<ArtifactToken> artifacts, AttributeTypeToken attributeType, Object value, OrcsApi orcsApi, JdbcService jdbcService) {
        LinkedList<Long> artIds = new LinkedList<Long>();
        HashMap<Long, ArtifactToken> artIdToTokenMap = new HashMap<Long, ArtifactToken>();
        String ids = "";
        for (ArtifactToken art : artifacts) {
            artIds.add(art.getId());
            ids = String.valueOf(ids) + art.getIdString() + ",";
            artIdToTokenMap.put(art.getId(), art);
        }
        ids = ids.replaceFirst(",$", "");
        HashSet<ArtifactToken> results = new HashSet<ArtifactToken>();
        try (JdbcStatement chStmt = jdbcService.getClient().getStatement();){
            String query = ARTIFACTS_MATCHING_ATTRIBUTE_VALUE_QUERY.replaceFirst("ART_IDS_HERE", ids);
            query = query.replaceAll("ATTR_TYPE_ID_HERE", attributeType.getIdString());
            query = query.replaceAll("BRANCH_ID_HERE", branch.getIdString());
            chStmt.runPreparedQuery(query, new Object[]{branch.getId(), attributeType.getId(), value});
            while (chStmt.next()) {
                Long artId = chStmt.getLong("art_id");
                results.add((ArtifactToken)artIdToTokenMap.get(artId));
            }
        }
        return results;
    }
}

