/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile.operations;

import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileProgram;
import org.eclipse.osee.ats.api.agile.atw.AtwNode;
import org.eclipse.osee.ats.api.agile.program.UiGridProgItem;
import org.eclipse.osee.ats.api.agile.program.UiGridProgram;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.insertion.JaxInsertion;
import org.eclipse.osee.ats.api.insertion.JaxInsertionActivity;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class ProgramOperations {
    private final AtsApi atsApi;
    private static String IMG_BASE_PATH = "/ats/agileui/images/";

    public ProgramOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public AtwNode getAtwTree(IAgileProgram program) {
        ArtifactToken progArt = this.atsApi.getQueryService().getArtifact(program.getId());
        AtwNode progNode = this.handleArtifactAndChildren(progArt, null);
        progNode.setExpanded(true);
        return progNode;
    }

    private AtwNode handleArtifactAndChildren(ArtifactToken artifact, AtwNode parentNode) {
        AtwNode node = this.getNodeFromArt(artifact);
        if (parentNode != null) {
            parentNode.getChildren().add(node);
        }
        for (ArtifactToken child : this.atsApi.getRelationResolver().getChildren((ArtifactId)artifact)) {
            this.handleArtifactAndChildren(child, node);
        }
        return node;
    }

    private AtwNode getNodeFromArt(ArtifactToken artifact) {
        AtwNode node = new AtwNode();
        node.setName(artifact.getName());
        node.setId(artifact.getIdString());
        node.setImage(this.getImage(artifact));
        return node;
    }

    public UiGridProgram getUiGridTree(IAgileProgram program) {
        ArtifactToken progArt = this.atsApi.getQueryService().getArtifact(program.getId());
        UiGridProgram progItem = new UiGridProgram();
        progItem.setId(program.getId());
        progItem.setName(program.getName());
        progItem.setItems(this.handleProgArtifactAndChildren(progArt, null, -1, new LinkedList<UiGridProgItem>()));
        return progItem;
    }

    private List<UiGridProgItem> handleProgArtifactAndChildren(ArtifactToken artifact, UiGridProgItem parentNode, int level, LinkedList<UiGridProgItem> items) {
        UiGridProgItem item = this.getProgItemFromArt(artifact, level);
        if (level >= 0) {
            items.add(item);
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileStory})) {
            if (artifact.getName().contains("up")) {
                item.setAgilePoints("Large");
            } else if (artifact.getName().contains("forward")) {
                item.setAgilePoints("Small");
            } else if (artifact.getName().contains("left")) {
                item.setAgilePoints("X-Large");
            }
            this.addTeamAndSprintAndTasksToStory(artifact, items, level + 1);
        }
        for (ArtifactToken child : this.atsApi.getRelationResolver().getChildren((ArtifactId)artifact)) {
            this.handleProgArtifactAndChildren(child, item, level + 1, items);
        }
        return items;
    }

    private void addTeamAndSprintAndTasksToStory(ArtifactToken storyArt, LinkedList<UiGridProgItem> items, int level) {
        ArtifactToken sprintArt;
        ArtifactToken teamArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)storyArt, AtsRelationTypes.AgileStoryToAgileTeam_AgileTeam);
        if (teamArt.isValid()) {
            UiGridProgItem item = this.getProgItemFromArt(teamArt, level);
            items.add(item);
        }
        if ((sprintArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)storyArt, AtsRelationTypes.AgileStoryToSprint_AgileSprint)).isValid()) {
            UiGridProgItem item = this.getProgItemFromArt(sprintArt, level);
            items.add(item);
            for (ArtifactToken taskArt : this.atsApi.getRelationResolver().getRelatedArtifacts((ArtifactId)sprintArt, AtsRelationTypes.AgileSprintToItem_AtsItem)) {
                UiGridProgItem taskItem = this.getProgItemFromArt(taskArt, level + 1);
                taskItem.setTLevel(level + 1);
                this.setTaskFields(taskArt, taskItem);
                items.add(taskItem);
            }
        }
        for (ArtifactToken taskArt : this.atsApi.getRelationResolver().getRelatedArtifacts((ArtifactId)storyArt, AtsRelationTypes.AgileStoryToItem_TeamWorkflow)) {
            UiGridProgItem taskItem = this.getProgItemFromArt(taskArt, level);
            taskItem.setTLevel(level);
            this.setTaskFields(taskArt, taskItem);
            items.add(taskItem);
        }
    }

    private void setTaskFields(ArtifactToken taskArt, UiGridProgItem taskItem) {
        String assignees;
        IAtsTeamWorkflow workItem = this.atsApi.getQueryService().getTeamWf((ArtifactId)taskArt);
        String points = this.atsApi.getAgileService().getAgileTeamPointsStr((IAtsWorkItem)workItem);
        if (org.eclipse.osee.framework.jdk.core.util.Strings.isValid((String)points)) {
            taskItem.setAgilePoints(points);
        }
        if (org.eclipse.osee.framework.jdk.core.util.Strings.isValid((String)(assignees = workItem.getStateMgr().getAssigneesStr()))) {
            taskItem.setAssigneesOrImplementers(assignees);
        }
    }

    private UiGridProgItem getProgItemFromArt(ArtifactToken artifact, int level) {
        UiGridProgItem item = new UiGridProgItem();
        String paddedName = level > 0 ? String.valueOf(Strings.repeat((String)"  - ", (int)level)) + artifact.getName() : artifact.getName();
        item.setName(paddedName);
        item.setId(artifact.getId());
        item.setImage(this.getImage(artifact));
        item.setType(this.atsApi.getStoreService().getArtifactType((ArtifactId)artifact).getName());
        item.setTLevel(level);
        return item;
    }

    private String getImage(ArtifactToken artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileProgramBacklog})) {
            return String.valueOf(IMG_BASE_PATH) + "agileProgramBacklog.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileProgram})) {
            return String.valueOf(IMG_BASE_PATH) + "agileProgram.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileProgramBacklogItem})) {
            return String.valueOf(IMG_BASE_PATH) + "agileProgramBacklogItem.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileProgramFeature})) {
            return String.valueOf(IMG_BASE_PATH) + "agileProgramFeature.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileStory})) {
            return String.valueOf(IMG_BASE_PATH) + "agileStory.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
            return String.valueOf(IMG_BASE_PATH) + "agileSprint.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileBacklog})) {
            return String.valueOf(IMG_BASE_PATH) + "agileBacklog.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) {
            return String.valueOf(IMG_BASE_PATH) + "agileTeam.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) {
            return String.valueOf(IMG_BASE_PATH) + "agileFeatureGroup.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.GeneralDocument})) {
            return String.valueOf(IMG_BASE_PATH) + "generalDoc.gif";
        }
        if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder})) {
            return String.valueOf(IMG_BASE_PATH) + "folder.gif";
        }
        return null;
    }

    public IAtsInsertion createInsertion(ArtifactId programArtifact, JaxInsertion newInsertion) {
        long id = newInsertion.getId();
        if (id <= 0L) {
            id = Lib.generateArtifactIdAsInt();
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create new Insertion", this.atsApi.getUserService().getCurrentUser());
        ArtifactReadable insertionArt = (ArtifactReadable)changes.createArtifact(AtsArtifactTypes.Insertion, newInsertion.getName(), Long.valueOf(id));
        changes.relate(programArtifact, AtsRelationTypes.ProgramToInsertion_Insertion, (ArtifactId)insertionArt);
        changes.execute();
        return this.atsApi.getProgramService().getInsertionById((ArtifactId)insertionArt);
    }

    public IAtsInsertion updateInsertion(JaxInsertion updatedInsertion) {
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Update Insertion", this.atsApi.getUserService().getCurrentUser());
        changes.setSoleAttributeValue(ArtifactId.valueOf((Long)updatedInsertion.getId()), (AttributeTypeToken)CoreAttributeTypes.Name, (Object)updatedInsertion.getName());
        changes.execute();
        return this.atsApi.getProgramService().getInsertionById((ArtifactId)this.atsApi.getQueryService().getArtifact(updatedInsertion.getId()));
    }

    public void deleteInsertion(ArtifactId artifact) {
        this.deleteConfigObject(artifact, "Delete Insertion", AtsArtifactTypes.Insertion);
    }

    public IAtsInsertionActivity createInsertionActivity(ArtifactId insertion, JaxInsertionActivity newActivity) {
        long id = newActivity.getId();
        if (id <= 0L) {
            id = Lib.generateArtifactIdAsInt();
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create new Insertion Activity", this.atsApi.getUserService().getCurrentUser());
        ArtifactReadable insertionActivityArt = (ArtifactReadable)changes.createArtifact(AtsArtifactTypes.InsertionActivity, newActivity.getName(), Long.valueOf(id));
        changes.relate(insertion, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity, (ArtifactId)insertionActivityArt);
        changes.execute();
        return this.atsApi.getProgramService().getInsertionActivityById((ArtifactId)insertionActivityArt);
    }

    public IAtsInsertionActivity updateInsertionActivity(JaxInsertionActivity updatedActivity) {
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Update Insertion", this.atsApi.getUserService().getCurrentUser());
        ArtifactReadable insertionActivityArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(updatedActivity.getId());
        changes.setSoleAttributeValue((ArtifactId)insertionActivityArt, (AttributeTypeToken)CoreAttributeTypes.Name, (Object)updatedActivity.getName());
        changes.setSoleAttributeValue(ArtifactId.valueOf((Long)updatedActivity.getId()), (AttributeTypeToken)CoreAttributeTypes.Name, (Object)updatedActivity.getName());
        changes.execute();
        return this.atsApi.getProgramService().getInsertionActivityById((ArtifactId)this.atsApi.getQueryService().getArtifact(updatedActivity.getId()));
    }

    public void deleteInsertionActivity(ArtifactId artifact) {
        this.deleteConfigObject(artifact, "Delete Insertion Activity", AtsArtifactTypes.InsertionActivity);
    }

    private void deleteConfigObject(ArtifactId id, String comment, ArtifactTypeToken type) {
        ArtifactReadable toDelete = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(id);
        if (toDelete == null) {
            throw new OseeCoreException("No object found for id %s", new Object[]{id});
        }
        if (!toDelete.isTypeEqual((ArtifactTypeId)type)) {
            throw new OseeCoreException("Artifact type does not match for %s", new Object[]{comment});
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(String.format("Delete config object %s-%s", id, type));
        changes.deleteArtifact((ArtifactId)toDelete);
        changes.execute();
    }
}

