/*********************************************************************
 * Copyright (c) 2022 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

/**
 * Contains the classes and an enumeration used to categorize and map OSEE native data types to Synchronization Artifact
 * data types. OSEE implements a large variety of data types represented by objects implementing the
 * {@link AttributeTypeToken} interface. The interface defines a set of predicates that can be used to categorize the
 * OSEE native data types. The OSEE native data type categories are represented by the {@link NativeDataType}
 * enumeration.
 *
 * @author Loren K. Ashley
 */

package org.eclipse.osee.define.rest.synchronization.forest.denizens;

/* EOF */