/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreBranchCategoryTokens;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedRecursive;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedTo;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeFollow;
import org.eclipse.osee.orcs.db.internal.search.handlers.FollowRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class SelectiveArtifactSqlWriter
extends AbstractSqlWriter {
    private final List<AbstractJoinQuery> joinTables = new ArrayList<AbstractJoinQuery>();
    private final AbstractSqlWriter parentWriter;
    private final List<Object> parameters = new ArrayList<Object>();
    private String fieldAlias;
    private String relsAlias;
    private String rels2Alias;

    private SelectiveArtifactSqlWriter(AbstractSqlWriter parentWriter, SqlJoinFactory sqlJoinFactory, JdbcClient jdbcClient, QueryData rootQueryData) {
        super(sqlJoinFactory, jdbcClient, rootQueryData);
        this.parentWriter = parentWriter;
    }

    public SelectiveArtifactSqlWriter(SqlJoinFactory sqlJoinFactory, JdbcClient jdbcClient, QueryData rootQueryData) {
        this(null, sqlJoinFactory, jdbcClient, rootQueryData);
    }

    public SelectiveArtifactSqlWriter(AbstractSqlWriter parentWriter) {
        this(parentWriter, parentWriter.joinFactory, parentWriter.getJdbcClient(), new QueryData(parentWriter.rootQueryData));
    }

    @Override
    public void addParameter(Object parameter) {
        if (this.parentWriter == null) {
            this.parameters.add(parameter);
        } else {
            this.parentWriter.addParameter(parameter);
        }
    }

    @Override
    protected void addJoin(AbstractJoinQuery join) {
        if (this.parentWriter == null) {
            this.joinTables.add(join);
        } else {
            this.parentWriter.addJoin(join);
        }
    }

    public void runSql(Consumer<JdbcStatement> consumer, SqlHandlerFactory handlerFactory, int numArtifacts) {
        this.runSqlorFetch(consumer, handlerFactory, numArtifacts);
    }

    public int getCount(SqlHandlerFactory handlerFactory) {
        return this.runSqlorFetch(null, handlerFactory, 1);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runSqlorFetch(Consumer<JdbcStatement> consumer, SqlHandlerFactory handlerFactory, int numArtifacts) {
        try {
            this.build(handlerFactory);
            for (AbstractJoinQuery join : this.joinTables) {
                join.store();
            }
            if (this.rootQueryData.isCountQueryType()) {
                var7_6 = (Integer)this.getJdbcClient().fetch((Object)-1, this.toSql(), this.parameters.toArray());
                return var7_6;
            }
            this.getJdbcClient().runQuery(consumer, numArtifacts * 20, this.toSql(), this.parameters.toArray());
        }
        finally {
            ** for (join : this.joinTables)
        }
lbl-1000:
        // 1 sources

        {
            try {
                join.close();
            }
            catch (Exception v0) {}
            continue;
        }
lbl19:
        // 1 sources

        this.reset();
        return var7_6;
    }

    public String toSql() {
        return this.output.toString();
    }

    @Override
    public Options getOptions() {
        return this.queryDataCursor.getOptions();
    }

    private void follow(SqlHandlerFactory handlerFactory, List<String> artWithAliases, String sourceArtTable) {
        ArrayList handlers = new ArrayList(this.queryDataCursor.getOnlyCriteriaSet().size());
        FollowRelationSqlHandler previousFollow = null;
        for (Criteria criteria : this.queryDataCursor.getOnlyCriteriaSet()) {
            if (criteria instanceof CriteriaRelationTypeFollow) {
                FollowRelationSqlHandler handlerSlim = previousFollow == null ? new FollowRelationSqlHandler(sourceArtTable) : new FollowRelationSqlHandler(previousFollow);
                handlerSlim.setData((CriteriaRelationTypeFollow)criteria);
                handlers.add(handlerSlim);
                previousFollow = handlerSlim;
                continue;
            }
            handlers.add(handlerFactory.createHandler(criteria));
        }
        String artWithAlias = this.write(handlers, "artWith");
        artWithAliases.add(artWithAlias);
        QueryData tempQueryDataCursor = this.queryDataCursor;
        Iterator iterator = this.queryDataCursor.getChildrenQueryData().iterator();
        while (iterator.hasNext()) {
            QueryData childQueryData;
            this.queryDataCursor = childQueryData = (QueryData)iterator.next();
            this.follow(handlerFactory, artWithAliases, artWithAlias);
        }
        this.queryDataCursor = tempQueryDataCursor;
    }

    public void build(SqlHandlerFactory handlerFactory) {
        String artWithAlias;
        ArrayList<String> artWithAliases = new ArrayList<String>();
        this.follow(handlerFactory, artWithAliases, null);
        if (artWithAliases.size() == 1) {
            artWithAlias = (String)artWithAliases.get(0);
        } else {
            artWithAlias = this.startCommonTableExpression("arts");
            boolean firstAlias = true;
            if (!this.rootQueryData.getBranchCategories().isEmpty() && this.rootQueryData.getBranchCategories().contains(CoreBranchCategoryTokens.MIM)) {
                for (String art : artWithAliases) {
                    if (!firstAlias) {
                        this.write(" union ");
                    } else {
                        firstAlias = false;
                    }
                    if (this.output.toString().contains("osee_relation rel")) {
                        String dataString = this.output.toString().replaceAll("\\/\\*.*?\\*\\/", "");
                        Pattern pattern = Pattern.compile(String.valueOf(art) + "\\sAS\\s\\((.*?)\\)", 32);
                        Matcher regexMatcher = pattern.matcher(dataString);
                        if (!regexMatcher.find()) continue;
                        if (regexMatcher.group(1).contains("osee_relation rel")) {
                            this.write("SELECT " + art + ".* from " + art);
                            continue;
                        }
                        this.write("SELECT " + art + ".*, 0 as top_rel_type, 0 as top_rel_order from " + art);
                        continue;
                    }
                    this.write("SELECT " + art + ".* from " + art);
                }
            } else {
                this.write(Collections.toString(artWithAliases, (String)"SELECT * FROM ", (String)" UNION SELECT * FROM ", null));
            }
        }
        if (this.rootQueryData.isIdQueryType() || this.rootQueryData.isCountQueryType()) {
            this.fieldAlias = artWithAlias;
        } else {
            String attsAlias = this.writeAttsCommonTableExpression(artWithAlias);
            if (this.rootQueryData.isAttributesOnlyQueryType() || this.rootQueryData.isTokenQueryType()) {
                this.fieldAlias = attsAlias;
            } else {
                this.writeRelsCommonTableExpression(artWithAlias);
                if (!this.rootQueryData.getBranchCategories().isEmpty() && this.rootQueryData.getBranchCategories().contains(CoreBranchCategoryTokens.MIM)) {
                    this.writeRelsCommonTableExpression2(artWithAlias);
                }
                this.writeFieldsCommonTableExpression(artWithAlias, attsAlias);
            }
        }
        this.finishWithClause();
        if (this.rootQueryData.isCountQueryType()) {
            this.write("SELECT count(*) FROM %s", this.fieldAlias);
        } else {
            this.write("SELECT * FROM %s", this.fieldAlias);
        }
        if (this.parentWriter == null && !this.rootQueryData.isCountQueryType() && !this.rootQueryData.isSelectQueryType()) {
            this.write(" ORDER BY art_id");
        } else if (this.rels2Alias != null) {
            if (this.output.toString().contains("top_rel_type")) {
                this.write(" ORDER BY top desc,top_rel_type, top_rel_order, rel_order");
            } else {
                this.write(" ORDER BY top desc, rel_order");
            }
        }
    }

    private void writeFieldsCommonTableExpression(String artWithAlias, String attsAlias) {
        this.fieldAlias = this.startCommonTableExpression("fields");
        this.writeSelectAndHint();
        this.writeSelectFields(attsAlias, "*");
        if (!this.rootQueryData.getBranchCategories().isEmpty() && this.rootQueryData.getBranchCategories().contains(CoreBranchCategoryTokens.MIM)) {
            this.write(", 0 as rel_type, 0 as rel_order, 0 AS other_art_type_id FROM ");
        } else {
            this.write(", 0 AS other_art_type_id FROM ");
        }
        this.write(attsAlias);
        this.write("\n UNION ALL\n ");
        SelectiveArtifactSqlWriter relWriter = new SelectiveArtifactSqlWriter(this);
        relWriter.relsAlias = this.relsAlias;
        ArrayList handlers = new ArrayList();
        handlers.add(new SqlHandler<Criteria>(){
            private String artAlias;

            @Override
            public void addTables(AbstractSqlWriter writer) {
                writer.addTable(SelectiveArtifactSqlWriter.this.relsAlias);
                this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
            }

            @Override
            public void addPredicates(AbstractSqlWriter writer) {
                writer.writeEquals(SelectiveArtifactSqlWriter.this.relsAlias, "other_art_id", this.artAlias, "art_id");
            }

            @Override
            public int getPriority() {
                return SqlHandlerPriority.RELATED_TO_ART_IDS.ordinal();
            }
        });
        relWriter.write(handlers);
        this.write(relWriter.toSql());
        if (!this.rootQueryData.getBranchCategories().isEmpty() && this.rootQueryData.getBranchCategories().contains(CoreBranchCategoryTokens.MIM)) {
            this.write("\n UNION ALL\n ");
            SelectiveArtifactSqlWriter relWriter2 = new SelectiveArtifactSqlWriter(this);
            relWriter2.rels2Alias = this.rels2Alias;
            ArrayList handlers2 = new ArrayList();
            handlers2.add(new SqlHandler<Criteria>(){
                private String artAlias;

                @Override
                public void addTables(AbstractSqlWriter writer) {
                    writer.addTable(SelectiveArtifactSqlWriter.this.rels2Alias);
                    this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
                }

                @Override
                public void addPredicates(AbstractSqlWriter writer) {
                    writer.writeEquals(SelectiveArtifactSqlWriter.this.rels2Alias, "other_art_id", this.artAlias, "art_id");
                }

                @Override
                public int getPriority() {
                    return SqlHandlerPriority.RELATED_TO_ART_IDS.ordinal();
                }
            });
            relWriter2.write(handlers2);
            this.write(relWriter2.toSql());
        }
    }

    private String writeAttsCommonTableExpression(String artWithAlias) {
        String attsAlias = this.startCommonTableExpression("atts");
        String attAlias = "att";
        String attTxsAlias = "txs";
        this.writeUseNlTableHint(String.valueOf(attAlias) + " " + attTxsAlias);
        this.writeSelectFields(artWithAlias, "*", attAlias, "attr_type_id AS type_id", attAlias, "value", attAlias, "uri", attAlias, "attr_id");
        this.write(", 0 AS other_art_id");
        this.write("\n FROM %s, osee_attribute att, osee_txs txs", artWithAlias);
        this.write("\n WHERE ");
        this.writeEqualsAnd(artWithAlias, attAlias, "art_id");
        AttributeTypeId attributeType = this.rootQueryData.getAttributeType();
        if (attributeType.isValid()) {
            this.writeEqualsParameterAnd(attAlias, "attr_type_id", attributeType);
        }
        this.writeEqualsAnd(attAlias, attTxsAlias, "gamma_id");
        this.writeTxBranchFilter(attTxsAlias);
        return attsAlias;
    }

    private void writeRelsCommonTableExpression(String artWithAlias) {
        this.relsAlias = this.startCommonTableExpression("rels");
        String relAlias = "rel";
        String relTxsAlias = "txs";
        this.writeUseNlTableHint(String.valueOf(relAlias) + " " + relTxsAlias);
        this.writeSelectFields(artWithAlias, "*", relAlias, "rel_link_type_id AS type_id");
        if (!this.rootQueryData.getBranchCategories().isEmpty() && this.rootQueryData.getBranchCategories().contains(CoreBranchCategoryTokens.MIM)) {
            this.write(", CASE art_id WHEN a_art_id THEN 'B' ELSE 'A' END AS value, '' AS spare1, 0 AS spare2, CASE art_id WHEN a_art_id THEN b_art_id ELSE a_art_id END AS other_art_id, 0 as rel_type, 0 as rel_order");
        } else {
            this.write(", CASE art_id WHEN a_art_id THEN 'B' ELSE 'A' END AS value, '' AS spare1, 0 AS spare2, CASE art_id WHEN a_art_id THEN b_art_id ELSE a_art_id END AS other_art_id");
        }
        this.write("\n FROM %s, osee_relation_link rel, osee_txs txs", artWithAlias);
        this.write("\n WHERE ");
        this.write(artWithAlias);
        this.write(".art_id IN (a_art_id, b_art_id) AND ");
        this.writeEqualsAnd(relAlias, relTxsAlias, "gamma_id");
        this.writeTxBranchFilter(relTxsAlias);
    }

    private void writeRelsCommonTableExpression2(String artWithAlias) {
        this.rels2Alias = this.startCommonTableExpression("rels");
        String relAlias = "rel";
        String relTxsAlias = "txs";
        this.writeUseNlTableHint(String.valueOf(relAlias) + " " + relTxsAlias);
        this.writeSelectFields(artWithAlias, "*", relAlias, "rel_type AS type_id");
        this.write(", CASE art_id WHEN a_art_id THEN 'B' ELSE 'A' END AS value, '' AS spare1, 0 AS spare2, CASE art_id WHEN a_art_id THEN b_art_id ELSE a_art_id END AS other_art_id, rel_type, rel_order");
        this.write("\n FROM %s, osee_relation rel, osee_txs txs", artWithAlias);
        this.write("\n WHERE ");
        this.write(artWithAlias);
        this.write(".art_id IN (a_art_id, b_art_id) AND ");
        this.writeEqualsAnd(relAlias, relTxsAlias, "gamma_id");
        this.writeTxBranchFilter(relTxsAlias);
    }

    @Override
    protected void writeSelectFields() {
        String artAlias = this.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
        String txAlias = this.getMainTableAlias(OseeDb.TXS_TABLE);
        if (this.relsAlias == null && this.rels2Alias == null) {
            this.writeSelectFields(artAlias, "art_id", artAlias, "art_type_id", txAlias, "app_id", txAlias, "transaction_id", txAlias, "mod_type");
            if (OptionsUtil.getIncludeApplicabilityTokens((Options)this.rootQueryData.getOptions())) {
                this.writeSelectFields(this.getMainTableAlias(OseeDb.OSEE_KEY_VALUE_TABLE), "value app_value");
            }
            this.write(", ");
            this.write(this.queryDataCursor.getParentQueryData() == null ? "1" : "0");
            this.write(" AS top");
            if (this.rootQueryData.hasCriteriaType(CriteriaRelatedTo.class)) {
                List crt = this.rootQueryData.getCriteriaByType(CriteriaRelatedTo.class);
                if (crt.stream().anyMatch(a -> ((RelationTypeSide)a.getType()).isNewRelationTable())) {
                    this.write(", rel_type as top_rel_type, rel_order as top_rel_order");
                }
            } else if (this.rootQueryData.hasCriteriaType(CriteriaRelatedRecursive.class)) {
                List crr = this.rootQueryData.getCriteriaByType(CriteriaRelatedRecursive.class);
                if (crr.stream().anyMatch(a -> a.getType().isNewRelationTable())) {
                    this.write(", top_rel_type, top_rel_order");
                }
            } else if (this.getTableEntries().stream().filter(a -> a.startsWith("osee_relation rel")).count() > 0L) {
                this.write(", rel_type as top_rel_type, rel_order as top_rel_order");
            }
        } else if (this.relsAlias != null) {
            this.writeSelectFields(this.relsAlias, "*", artAlias, "art_type_id");
            this.write(" AS other_art_type_id");
        } else if (this.rels2Alias != null) {
            this.writeSelectFields(this.rels2Alias, "*", artAlias, "art_type_id");
            this.write(" AS other_art_type_id");
        }
    }

    @Override
    protected void writeSelect(Iterable<SqlHandler<?>> handlers) {
        String multiHint = this.getMultiTableHintParameter();
        if (multiHint.split(" ").length > 1) {
            this.writeUseNlTableHint(multiHint);
        } else {
            this.writeSelectAndHint();
        }
        if (this.rootQueryData.isCountQueryType()) {
            this.writeSelectFields(this.getMainTableAlias(OseeDb.ARTIFACT_TABLE), "art_id");
        } else {
            this.writeSelectFields();
            for (SqlHandler<?> handler : handlers) {
                handler.writeSelectFields(this);
            }
        }
    }

    @Override
    public void writeGroupAndOrder(Iterable<SqlHandler<?>> handlers) {
    }

    @Override
    protected void reset() {
        super.reset();
        this.parameters.clear();
        this.joinTables.clear();
        this.rootQueryData.reset();
    }

    @Override
    public String toString() {
        if (this.parentWriter == null) {
            StringBuilder strB = new StringBuilder();
            String[] tokens = this.output.toString().split("\\?");
            int i = 0;
            while (i < tokens.length) {
                strB.append(tokens[i]);
                if (i < this.parameters.size()) {
                    Object parameter = this.parameters.get(i);
                    if (parameter instanceof Id) {
                        strB.append(((Id)parameter).getIdString());
                    } else {
                        strB.append(parameter);
                    }
                } else if (i < tokens.length - 1) {
                    strB.append("?");
                }
                ++i;
            }
            return strB.toString();
        }
        return this.toSql();
    }
}

