/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.HasOptions;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.sql.SqlAliasManager;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.CharJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public abstract class AbstractSqlWriter
implements HasOptions {
    private static final String AND_NEW_LINE = " AND\n";
    private final List<String> tableEntries = new ArrayList<String>();
    private final SqlAliasManager aliasManager = new SqlAliasManager();
    private final JdbcClient jdbcClient;
    private final SqlContext context;
    protected final StringBuilder output = new StringBuilder();
    protected final QueryData rootQueryData;
    protected final SqlJoinFactory joinFactory;
    private int level;
    private boolean firstField;
    private boolean firstCte = true;
    protected QueryData queryDataCursor;
    private String tupleAlias;
    private String tupleTxsAlias;
    private String multiTableHintParameter = "";

    public AbstractSqlWriter(SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlContext context, QueryData rootQueryData) {
        this.joinFactory = joinFactory;
        this.jdbcClient = jdbcClient;
        this.context = context;
        this.rootQueryData = rootQueryData;
        this.queryDataCursor = rootQueryData;
    }

    public AbstractSqlWriter(SqlJoinFactory joinFactory, JdbcClient jdbcClient, QueryData rootQueryData) {
        this(joinFactory, jdbcClient, null, rootQueryData);
    }

    public void build(SqlHandler<?> ... handlers) {
        this.build(Arrays.asList(handlers));
    }

    public void build(List<SqlHandler<?>> handlers) {
        this.reset();
        this.write(handlers);
        String sql = this.toString();
        this.context.setSql(sql);
    }

    protected void reset() {
        this.output.delete(0, this.output.length());
        if (this.context != null) {
            this.context.getJoins().clear();
            this.context.getParameters().clear();
        }
        this.getTableEntries().clear();
        this.aliasManager.reset();
        this.level = 0;
        this.firstCte = true;
        this.multiTableHintParameter = "";
    }

    protected void write(Iterable<SqlHandler<?>> handlers) {
        this.write(handlers, null);
    }

    protected String write(Iterable<SqlHandler<?>> handlers, String ctePrefix) {
        String cteAlias = null;
        this.writeToWithClause(handlers);
        if (ctePrefix == null) {
            this.finishWithClause();
        } else {
            cteAlias = this.startCommonTableExpression(ctePrefix);
        }
        this.computeTables(handlers);
        this.writeSelect(handlers);
        this.write("\n FROM ");
        this.writeTables();
        this.write("\n WHERE ");
        this.writePredicates(handlers);
        this.removeDanglingSeparator("\n WHERE ");
        this.writeGroupAndOrder(handlers);
        return cteAlias;
    }

    public String startRecursiveCommonTableExpression(String prefix, String parameters) {
        boolean isRecursive = parameters != null;
        String cteAlias = this.getNextAlias(prefix);
        if (this.firstCte) {
            this.write("WITH ");
            this.firstCte = false;
        } else {
            this.write("),\n");
        }
        if (isRecursive) {
            this.write(this.jdbcClient.getDbType().getRecursiveWithSql());
            this.write(" ");
        }
        this.write(cteAlias);
        if (isRecursive) {
            this.write(" ");
            this.write(parameters);
        }
        this.write(" AS (\n ");
        return cteAlias;
    }

    public void writeCteRecursiveUnion() {
        this.write("\n ");
        this.write(this.jdbcClient.getDbType().getCteRecursiveUnion());
        this.write("\n");
    }

    public String startCommonTableExpression(String prefix) {
        return this.startRecursiveCommonTableExpression(prefix, null);
    }

    protected void writeWithClause(Iterable<SqlHandler<?>> handlers) {
        this.writeToWithClause(handlers);
        this.finishWithClause();
    }

    private void writeToWithClause(Iterable<SqlHandler<?>> handlers) {
        for (SqlHandler<?> handler : handlers) {
            this.setHandlerLevel(handler);
            handler.writeCommonTableExpression(this);
        }
    }

    protected void finishWithClause() {
        if (!this.firstCte) {
            this.write(")\n");
        }
    }

    public SqlContext getContext() {
        return this.context;
    }

    protected void writeSelect(Iterable<SqlHandler<?>> handlers) {
        this.writeSelectAndHint();
        if (this.rootQueryData.isCountQueryType()) {
            if (OptionsUtil.isHistorical((Options)this.getOptions())) {
                this.write("count(xTable.art_id) FROM (");
                this.writeSelectAndHint();
                this.write("1");
            } else {
                this.write("count(*)");
            }
        } else {
            this.writeSelectFields();
            for (SqlHandler<?> handler : handlers) {
                handler.writeSelectFields(this);
            }
        }
    }

    public void writeCommaIfNotFirst() {
        if (this.firstField) {
            this.firstField = false;
        } else {
            this.write(", ");
        }
    }

    protected abstract void writeSelectFields();

    public void writeSelectFields(String ... tablesAndFields) {
        int i = 0;
        while (i < tablesAndFields.length) {
            this.writeCommaIfNotFirst();
            String table = tablesAndFields[i++];
            String field = tablesAndFields[i];
            this.write(table);
            this.write(".");
            this.write(field);
            ++i;
        }
    }

    public void writeTxBranchFilter(String txsAlias) {
        boolean allowDeleted = OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
        this.writeTxBranchFilter(txsAlias, allowDeleted);
    }

    public void writeTxBranchFilter(String txsAlias, boolean allowDeleted) {
        this.writeTxFilter(txsAlias, allowDeleted);
        this.writeBranchFilter(txsAlias);
    }

    public void writeBranchFilter(String txsAlias) {
        BranchToken branch = this.rootQueryData.getBranch();
        if (!branch.isValid()) {
            throw new OseeArgumentException("writeBranchFilter: branch id must be valid not:" + branch, new Object[0]);
        }
        this.write(" AND ");
        this.writeEqualsParameter(txsAlias, "branch_id", branch);
    }

    protected void writeTxFilter(String txsAlias, boolean allowDeleted) {
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            this.write(txsAlias);
            this.write(".transaction_id <= ?");
            this.addParameter(OptionsUtil.getFromTransaction((Options)this.getOptions()));
            if (!allowDeleted) {
                this.write(" AND ");
                this.write(txsAlias);
                this.write(".mod_type <> ");
                this.write(ModificationType.DELETED.getIdString());
            }
        } else {
            this.writeTxCurrentFilter(txsAlias, allowDeleted);
        }
    }

    protected void writeTxCurrentFilter(String txsAlias, boolean allowDeleted) {
        this.write(txsAlias);
        this.write(".tx_current");
        if (allowDeleted) {
            this.write(" <> ");
            this.write(TxCurrent.NOT_CURRENT.getIdString());
        } else {
            this.write(" = ");
            this.write(TxCurrent.CURRENT.getIdString());
        }
    }

    protected abstract void writeGroupAndOrder(Iterable<SqlHandler<?>> var1);

    protected void writeTables() {
        boolean first = true;
        for (String tableEntry : this.getTableEntries()) {
            if (first) {
                first = false;
            } else {
                this.write(", ");
            }
            this.write(tableEntry);
        }
        this.getTableEntries().clear();
    }

    protected void computeTables(Iterable<SqlHandler<?>> handlers) {
        for (SqlHandler<?> handler : handlers) {
            this.setHandlerLevel(handler);
            handler.addTables(this);
        }
        if (this.queryDataCursor.getView().isValid()) {
            this.tupleAlias = this.addTable(OseeDb.TUPLE2);
            this.tupleTxsAlias = this.addTable(OseeDb.TXS_TABLE);
        }
    }

    protected void setHandlerLevel(SqlHandler<?> handler) {
        this.level = handler.getLevel();
    }

    protected void writePredicates(Iterable<SqlHandler<?>> handlers) {
        Iterator<SqlHandler<?>> iterator = handlers.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            SqlHandler<?> handler = iterator.next();
            this.setHandlerLevel(handler);
            if (!handler.hasPredicates()) continue;
            if (first) {
                first = false;
            } else {
                this.write(AND_NEW_LINE);
            }
            handler.addPredicates(this);
        }
        if (this.mainTableAliasExists(OseeDb.ARTIFACT_TABLE)) {
            if (!first) {
                this.write(" AND ");
            }
            String mainTableAlias = this.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
            String mainTxsAlias = this.getMainTableAlias(OseeDb.TXS_TABLE);
            this.writeEqualsAnd(mainTableAlias, mainTxsAlias, "gamma_id");
            if (this.mainTableAliasExists(OseeDb.OSEE_KEY_VALUE_TABLE)) {
                String mainKvAlias = this.getMainTableAlias(OseeDb.OSEE_KEY_VALUE_TABLE);
                this.writeEqualsAnd(mainTxsAlias, "app_id", mainKvAlias, "key");
            }
            this.writeTxBranchFilter(mainTxsAlias);
            if (this.queryDataCursor.getAppId().isValid()) {
                this.write(" AND ");
                this.writeEqualsParameter(mainTxsAlias, "app_id", this.queryDataCursor.getAppId());
            }
            if (this.queryDataCursor.getView().isValid()) {
                this.write(" AND ");
                this.writeEqualsParameterAnd(this.tupleAlias, "tuple_type", CoreTupleTypes.ViewApplicability);
                this.writeEqualsParameterAnd(this.tupleAlias, "e1", this.queryDataCursor.getView());
                this.writeEqualsAnd(this.tupleAlias, this.tupleTxsAlias, "gamma_id");
                this.writeEqualsAnd(this.tupleAlias, "e2", this.getMainTableAlias(OseeDb.TXS_TABLE), "app_id");
                this.writeTxBranchFilter(this.tupleTxsAlias);
            }
        }
    }

    protected boolean mainTableAliasExists(SqlTable table) {
        return this.queryDataCursor.mainTableAliasExists(table);
    }

    public void writeAnd() {
        this.write(" AND ");
    }

    public void writeAndLn() {
        this.write(AND_NEW_LINE);
    }

    protected void removeDanglingSeparator(String token) {
        int length = this.output.length();
        int index = this.output.lastIndexOf(token);
        if (index == length - token.length()) {
            this.output.delete(index, length);
        }
    }

    protected boolean hasAlias(SqlTable table) {
        return this.getAliasManager().hasAlias(this.level, table, table.getObjectType());
    }

    public List<String> getAliases(SqlTable table) {
        return this.getAliasManager().getAliases(this.level, table, table.getObjectType());
    }

    public String getFirstAlias(SqlTable table) {
        return this.getFirstAlias(this.level, table, table.getObjectType());
    }

    public String getFirstAlias(int level, SqlTable table, ObjectType type) {
        return this.getAliasManager().getFirstAlias(level, table, type);
    }

    public String getLastAlias(SqlTable table) {
        ObjectType type = table.getObjectType();
        return this.getAliasManager().getLastAlias(table, type);
    }

    public String getNextAlias(SqlTable table) {
        return this.getNextAlias(table.getPrefix(), table.getObjectType());
    }

    private String getNextAlias(String prefix, ObjectType type) {
        return this.getAliasManager().getNextAlias(prefix, type);
    }

    public String getNextAlias(String prefix) {
        return this.getAliasManager().getNextAlias(prefix, ObjectType.UNKNOWN);
    }

    public SqlAliasManager getAliasManager() {
        return this.aliasManager;
    }

    public String addTable(SqlTable table) {
        return this.addTable(table, table.getObjectType());
    }

    public String addTable(RelationTypeToken relationType) {
        return this.addTable(this.getRelationTable(relationType));
    }

    public void addTable(String tableName) {
        this.getTableEntries().add(tableName);
    }

    public String addTable(SqlTable table, ObjectType objectType) {
        String alias = this.getNextAlias(table.getPrefix(), objectType);
        this.getTableEntries().add(String.format("%s %s", table.getName(), alias));
        this.multiTableHintParameter = this.multiTableHintParameter.length() > 0 ? String.valueOf(this.multiTableHintParameter) + " " + alias : alias;
        return alias;
    }

    public String getMultiTableHintParameter() {
        return this.multiTableHintParameter;
    }

    public String getMainTableAlias(SqlTable table) {
        return this.queryDataCursor.getMainTableAlias(table, this::addTable);
    }

    public void writeTableNoAlias(SqlTable table) {
        this.write(table.getName());
    }

    public String writeTable(SqlTable table) {
        String alias = this.getNextAlias(table);
        this.write("%s %s", table.getName(), alias);
        return alias;
    }

    public String writeTable(RelationTypeToken relationType) {
        return this.writeTable(this.getRelationTable(relationType));
    }

    private SqlTable getRelationTable(RelationTypeToken relationType) {
        return relationType.isNewRelationTable() ? OseeDb.RELATION_TABLE2 : OseeDb.RELATION_TABLE;
    }

    public void write(String format, Object ... params) {
        if (params != null && params.length > 0) {
            this.output.append(String.format(format, params));
        } else {
            this.output.append(format);
        }
    }

    public void write(String sql) {
        this.output.append(sql);
    }

    public void writeEquals(String table1, String table2, String column) {
        this.write("%s.%s = %s.%s", table1, column, table2, column);
    }

    public void writeEqualsAnd(String table1, String table2, String column) {
        this.writeEquals(table1, table2, column);
        this.write(" AND ");
    }

    public void writeEquals(String table1, String column1, String table2, String column2) {
        this.write("%s.%s = %s.%s", table1, column1, table2, column2);
    }

    public void writeEqualsAnd(String table1, String column1, String table2, String column2) {
        this.writeEquals(table1, column1, table2, column2);
        this.write(" AND ");
    }

    public void addParameter(Object parameter) {
        this.getContext().getParameters().add(parameter);
    }

    public void writeEqualsParameter(String table, String column, Object parameter) {
        this.output.append(table);
        this.output.append(".");
        this.writeEqualsParameter(column, parameter);
    }

    public void writeEqualsParameterAnd(String table, String column, Object parameter) {
        this.writeEqualsParameter(table, column, parameter);
        this.write(" AND ");
    }

    public void writeEqualsParameter(String column, Object parameter) {
        this.output.append(column);
        this.output.append(" = ?");
        this.addParameter(parameter);
    }

    public void writeEqualsParameterAnd(String column, Object parameter) {
        this.writeEqualsParameter(column, parameter);
        this.write(" AND ");
    }

    protected void addJoin(AbstractJoinQuery join) {
        this.getContext().getJoins().add(join);
    }

    public CharJoinQuery writeCharJoin(Collection<String> ids) {
        CharJoinQuery joinQuery = this.joinFactory.createCharJoinQuery();
        joinQuery.addAll(ids);
        this.addJoin(joinQuery);
        return joinQuery;
    }

    public IdJoinQuery writeJoin(Collection<? extends Id> ids) {
        IdJoinQuery joinQuery = this.joinFactory.createIdJoinQuery();
        joinQuery.addAll(ids);
        this.addJoin(joinQuery);
        return joinQuery;
    }

    public Options getOptions() {
        return this.getContext().getOptions();
    }

    protected void writeUseNlTableHint(String hintParams) {
        this.writeSelectAndMultiTableHint("USE_NL", hintParams);
    }

    protected void writeSelectAndMultiTableHint(String hint, String hintParams) {
        this.write("SELECT");
        this.write(this.jdbcClient.getMultiTableHint(hint, hintParams));
        this.write(" ");
        this.firstField = true;
    }

    protected void writeSelectAndHint() {
        this.write("SELECT");
        this.write(this.jdbcClient.getOrderedHint());
        this.write(" ");
        this.firstField = true;
    }

    public String toString() {
        return this.output.toString();
    }

    public void writePatternMatch(String table, String column, String pattern) {
        this.writePatternMatch(String.valueOf(table) + "." + column, pattern);
    }

    public void writePatternMatch(String field, String pattern) {
        this.write(this.jdbcClient.getDbType().getRegularExpMatchSql(field));
        this.addParameter(pattern);
    }

    public JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    public List<String> getTableEntries() {
        return this.tableEntries;
    }
}

