/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization.forest.morphology;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.define.rest.synchronization.IdentifierType;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThing;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.DuplicateStoreEntryException;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.Store;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.StoreType;
import org.eclipse.osee.define.rest.synchronization.util.HierarchyTree;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ParameterArray;

class StoreRank3
implements Store {
    private static int rank = 3;
    protected final Map<IdentifierType.Identifier, HierarchyTree<IdentifierType.Identifier, GroveThing>> hierarchyTrees;
    private final Predicate<Object>[] keyValidators;
    private final Set<IdentifierType.Identifier> quickDuplicateSet;
    private final StoreType storeType;

    public StoreRank3(StoreType storeType, Predicate<Object> primaryKeyValidator, Predicate<Object> secondaryKeyValidator, Predicate<Object> tertiaryKeyValidator) {
        this.storeType = storeType;
        this.keyValidators = new Predicate[]{Objects.requireNonNull(primaryKeyValidator), Objects.requireNonNull(secondaryKeyValidator), Objects.requireNonNull(tertiaryKeyValidator)};
        this.hierarchyTrees = new HashMap<IdentifierType.Identifier, HierarchyTree<IdentifierType.Identifier, GroveThing>>();
        this.quickDuplicateSet = new HashSet<IdentifierType.Identifier>();
    }

    @Override
    public void add(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing)) : "StoreRank3::add, groveThing is null.";
        if (groveThing.isType(IdentifierType.SPECIFICATION)) {
            IdentifierType.Identifier key = groveThing.getIdentifier();
            if (this.quickDuplicateSet.contains(key)) {
                throw new DuplicateStoreEntryException(this, groveThing);
            }
            HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = new HierarchyTree<IdentifierType.Identifier, GroveThing>();
            hierarchyTree.setRoot(key, groveThing);
            this.hierarchyTrees.put(key, hierarchyTree);
            this.quickDuplicateSet.add(key);
        } else {
            groveThing.getPrimaryKeys().ifPresent(keys -> {
                assert (ParameterArray.validateNonNullSizeAndElements((Object[])keys, (int)rank, (int)rank, (Predicate[])this.keyValidators)) : new StringBuilder(1024).append("\n").append("StoreRank3::add, primary keys failed to validate for GroveThing").append("\n").append("   GroveThing folows:").append("\n").append(groveThing).append("\n");
                if (this.quickDuplicateSet.contains(keys[2])) {
                    throw new DuplicateStoreEntryException(this, groveThing);
                }
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                if (Objects.isNull(hierarchyTree)) {
                    hierarchyTree = new HierarchyTree();
                    this.hierarchyTrees.put((IdentifierType.Identifier)keys[0], hierarchyTree);
                }
                hierarchyTree.insertLast((IdentifierType.Identifier)keys[1], (IdentifierType.Identifier)keys[2], groveThing);
                this.quickDuplicateSet.add((IdentifierType.Identifier)keys[2]);
            });
        }
    }

    @Override
    public boolean contains(Object ... keys) {
        assert (ParameterArray.validateNonNullSizeAndElements((Object[])keys, (int)1, (int)rank, (Predicate[])this.keyValidators));
        HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
        if (Objects.isNull(hierarchyTree)) {
            return false;
        }
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 2: {
                return hierarchyTree.containsKey((IdentifierType.Identifier)keys[1]);
            }
            case 3: {
                return hierarchyTree.containsKey((IdentifierType.Identifier)keys[1], (IdentifierType.Identifier)keys[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Optional<GroveThing> get(Object ... keys) {
        assert (ParameterArray.validateNonNullSizeAndElements((Object[])keys, (int)2, (int)rank, (Predicate[])this.keyValidators));
        HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
        if (Objects.isNull(hierarchyTree)) {
            return null;
        }
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 2: {
                return Optional.ofNullable(hierarchyTree.get((IdentifierType.Identifier)keys[1]));
            }
            case 3: {
                return hierarchyTree.get((IdentifierType.Identifier)keys[1], (IdentifierType.Identifier)keys[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public StoreType getType() {
        return this.storeType;
    }

    @Override
    public int rank() {
        return rank;
    }

    @Override
    public int size() {
        return this.hierarchyTrees.values().stream().collect(Collectors.summingInt(HierarchyTree::size));
    }

    @Override
    public Stream<GroveThing> stream(Object ... keys) {
        assert (ParameterArray.validateSizeAndElements((Object[])keys, (int)0, (int)rank, (Predicate[])this.keyValidators));
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 0: {
                return this.hierarchyTrees.values().stream().flatMap(HierarchyTree::streamValuesDeep);
            }
            case 1: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamValuesDeep() : Stream.empty();
            }
            case 2: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamValuesShallow((IdentifierType.Identifier)keys[1]) : Stream.empty();
            }
            case 3: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.get((IdentifierType.Identifier)keys[1], (IdentifierType.Identifier)keys[2]).map(value -> Stream.of(value)).orElseGet(Stream::empty) : Stream.empty();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Stream<Object> streamKeysAtAndBelow(Object ... keys) {
        assert (ParameterArray.validateSizeAndElements((Object[])keys, (int)0, (int)rank, (Predicate[])this.keyValidators));
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 0: {
                return this.hierarchyTrees.keySet().stream().flatMap(treeKey -> this.hierarchyTrees.get(treeKey).streamKeysDeep());
            }
            case 1: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamKeysDeep() : Stream.empty();
            }
            case 2: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamKeysDeep((IdentifierType.Identifier)keys[1]) : Stream.empty();
            }
            case 3: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return (Objects.nonNull(hierarchyTree) ? hierarchyTree.get((IdentifierType.Identifier)keys[1], (IdentifierType.Identifier)keys[2]) : Optional.empty()).map(child -> Stream.of(keys[2])).orElseGet(Stream::empty);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Stream<Object> streamKeysAt(Object ... keys) {
        assert (ParameterArray.validateSizeAndElements((Object[])keys, (int)0, (int)rank, (Predicate[])this.keyValidators));
        int keyCount = Objects.nonNull(keys) ? keys.length : 0;
        switch (keyCount) {
            case 0: {
                return this.hierarchyTrees.keySet().stream();
            }
            case 1: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamKeysShallow((IdentifierType.Identifier)keys[0]) : Stream.empty();
            }
            case 2: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return Objects.nonNull(hierarchyTree) ? hierarchyTree.streamKeysShallow((IdentifierType.Identifier)keys[1]) : Stream.empty();
            }
            case 3: {
                HierarchyTree<IdentifierType.Identifier, GroveThing> hierarchyTree = this.hierarchyTrees.get(keys[0]);
                return (Objects.nonNull(hierarchyTree) ? hierarchyTree.get((IdentifierType.Identifier)keys[1], (IdentifierType.Identifier)keys[2]) : Optional.empty()).map(child -> Stream.of(keys[2])).orElseGet(Stream::empty);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Stream<Object[]> streamKeySets(Object ... keys) {
        return this.stream(keys).map(GroveThing::getPrimaryKeys).filter(Optional::isPresent).map(Optional::get).map(lowerKeys -> {
            Class<?> keyClass = lowerKeys[0].getClass();
            Object[] keyArray = (Object[])Array.newInstance(keyClass, 3);
            keyArray[0] = keys[0];
            if (((Object[])lowerKeys).length == 1) {
                keyArray[1] = lowerKeys[0];
                keyArray[2] = lowerKeys[0];
            } else {
                keyArray[1] = lowerKeys[1];
                keyArray[2] = lowerKeys[2];
            }
            return keyArray;
        });
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)(indent + 0));
        String indent1 = IndentedString.indentString((int)(indent + 1));
        outMessage.append(indent0).append(this.getClass().getName()).append("\n").append(indent1).append("Rank:         ").append(this.rank()).append("\n").append(indent1).append("Store Type:   ").append((Object)this.storeType).append("\n").append(indent1).append("Current Size: ").append(this.size()).append("\n");
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

