/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.util.SkipAtsConfigJsonWriter;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.ats.rest.internal.config.ConfigJsonWriter;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.OrcsApi;

@Provider
public class ConfigsJsonWriter
implements MessageBodyWriter<Collection<IAtsConfigObject>> {
    private JsonFactory jsonFactory;
    private AtsApi atsApiServer;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setAtsApiServer(AtsApiServer atsApiServer) {
        this.atsApiServer = atsApiServer;
    }

    public void start() {
        this.jsonFactory = JsonUtil.getFactory();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(Collection<IAtsConfigObject> data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Type t;
        ParameterizedType parameterizedType;
        Type[] actualTypeArgs;
        if (JsonUtil.hasAnnotation(SkipAtsConfigJsonWriter.class, (Annotation[])annotations)) {
            return false;
        }
        boolean isWriteable = false;
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && (actualTypeArgs = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (t = actualTypeArgs[0]) instanceof Class) {
            Class clazz = (Class)t;
            isWriteable = IAtsConfigObject.class.isAssignableFrom(clazz);
        }
        return isWriteable;
    }

    private boolean matches(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void writeTo(Collection<IAtsConfigObject> programs, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        try {
            writer = this.jsonFactory.createGenerator(entityStream);
            writer.writeStartArray();
            for (IAtsConfigObject program : programs) {
                ConfigJsonWriter.addProgramObject(this.atsApiServer, this.orcsApi, (IAtsObject)program, annotations, writer, this.matches(IdentityView.class, annotations));
            }
            writer.writeEndArray();
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }
}

