/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.admin;

import org.eclipse.osee.authentication.admin.AuthenticationRequest;

public final class AuthenticationRequestBuilder {
    private String scheme;
    private String userName;
    private String password;

    private AuthenticationRequestBuilder() {
    }

    public static AuthenticationRequestBuilder newBuilder() {
        return new AuthenticationRequestBuilder();
    }

    public AuthenticationRequestBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public AuthenticationRequestBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public AuthenticationRequestBuilder password(String password) {
        this.password = password;
        return this;
    }

    public AuthenticationRequest build() {
        return new AuthenticationRequestImpl(this.scheme, this.userName, this.password);
    }

    private static final class AuthenticationRequestImpl
    implements AuthenticationRequest {
        private final String userName;
        private final String password;
        private final String scheme;

        public AuthenticationRequestImpl(String scheme, String userName, String password) {
            this.scheme = scheme;
            this.userName = userName;
            this.password = password;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getUserName() {
            return this.userName;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        public String toString() {
            return "AuthenticationRequestImpl [scheme=" + this.scheme + ", userName=" + this.userName + ", password=[*****]]";
        }
    }
}

