/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.eclipse.osee.framework.jdk.core.util.io.JavaFileBuilder;

public class IEnumValueBuilder
extends JavaFileBuilder {
    protected PriorityQueue<EnumRecord> enums = new PriorityQueue<EnumRecord>(20, new Comparator<EnumRecord>(){

        @Override
        public int compare(EnumRecord i, EnumRecord j) {
            return i.number - j.number;
        }
    });

    public IEnumValueBuilder(String packageName, String className, String classJavaDoc) {
        super(packageName, className, classJavaDoc, null);
        this.addMethod(this.getBasicConstructor());
        this.addMethod(this.getGetIntValue());
        this.addMethod(this.getToEnum());
        this.addMethod(this.getGetToEnum());
    }

    public void addEnum(String name, int enumNumber) {
        this.addEnumField(new EnumRecord(enumNumber, name));
    }

    protected String getBasicConstructor() {
        return "\tprivate int value;\n\n\tprivate " + this.className + "(int value) {\n" + "\t\tthis.value = value;\n" + "\t}\n";
    }

    private String getGetIntValue() {
        return "\tpublic int getIntValue() {\n\t\treturn value;\n\t}\n";
    }

    private String getToEnum() {
        return "\tpublic static " + this.className + " toEnum(int value) {\n" + "\t\tfor (" + this.className + " myEnum : " + this.className + ".values()) {\n" + "\t\t\tif (myEnum.getIntValue() == value) {\n" + "\t\t\t\treturn myEnum;\n" + "\t\t\t}\n" + "\t\t}\n" + "\t\tthrow new IllegalArgumentException(\"Unable to find " + this.className + " with value \" + value + \".\");\n" + "\t}\n";
    }

    private String getGetToEnum() {
        return "\tpublic static " + this.className + " getEnum(String enumString) {\n" + "\t\tfor (" + this.className + " myEnum : " + this.className + ".values()) {\n" + "\t\t\tif (" + this.className + ".valueOf(enumString) == myEnum) {\n" + "\t\t\t\treturn myEnum;\n" + "\t\t\t}\n" + "\t\t}\n" + "\t\tthrow new IllegalArgumentException(\"Unable to find " + this.className + " to match \" + enumString + \".\");\n" + "\t}\n";
    }

    public static class EnumRecord {
        private final int number;
        private final String name;

        public EnumRecord(int number, String name) {
            this.number = number;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            String enumStr = String.valueOf(this.name) + "(" + this.number + ")";
            return enumStr;
        }
    }
}

