/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.ArrayList;
import java.util.List;

public class IndentedString {
    private static IndentedString indentedString;
    private static int initialIndentStringCount;
    private static int indentAmount;
    private final StringBuilder indentBuffer;
    private final List<String> indentStrings = new ArrayList<String>(initialIndentStringCount);
    private int largestIndent = -1;

    static {
        initialIndentStringCount = 32;
        indentAmount = 3;
        indentedString = new IndentedString();
        indentedString.createInitialIndentStrings();
    }

    private IndentedString() {
        this.indentBuffer = new StringBuilder(indentAmount * initialIndentStringCount + 1024);
    }

    private void createInitialIndentStrings() {
        int i = 0;
        while (i < initialIndentStringCount) {
            this.createIndentString(i);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createIndentString(int indent) {
        if (indent > this.largestIndent) {
            IndentedString indentedString = IndentedString.indentedString;
            synchronized (indentedString) {
                int start = this.largestIndent + 1;
                int end = indent;
                int spaceCount = indentAmount * (end - start + (this.largestIndent >= 0 ? 1 : 0));
                int i = 0;
                while (i < spaceCount) {
                    this.indentBuffer.append(" ");
                    ++i;
                }
                int newIndent = start;
                while (newIndent <= end) {
                    this.indentStrings.add(newIndent, this.indentBuffer.toString());
                    ++newIndent;
                }
                this.largestIndent = indent;
            }
        }
        return this.indentStrings.get(indent);
    }

    public static String indentString(int indent) {
        return indentedString.createIndentString(indent);
    }
}

