/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.disposition.rest.internal.importer.Actual;
import org.eclipse.osee.disposition.rest.internal.importer.CheckGroup;
import org.eclipse.osee.disposition.rest.internal.importer.Config;
import org.eclipse.osee.disposition.rest.internal.importer.ElementHandlers;
import org.eclipse.osee.disposition.rest.internal.importer.Expected;
import org.eclipse.osee.disposition.rest.internal.importer.Number;
import org.eclipse.osee.disposition.rest.internal.importer.Result;
import org.eclipse.osee.disposition.rest.internal.importer.ScriptVersion;
import org.eclipse.osee.disposition.rest.internal.importer.Stacktrace;
import org.eclipse.osee.disposition.rest.internal.importer.TestPoint;
import org.eclipse.osee.disposition.rest.internal.importer.TestPointName;
import org.eclipse.osee.disposition.rest.internal.importer.TestPointResults;
import org.eclipse.osee.disposition.rest.internal.importer.Time;
import org.eclipse.osee.disposition.rest.internal.importer.TimeSummary;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.xml.sax.Attributes;

public class DispoSaxHandler
extends AbstractSaxHandler {
    Map<String, ElementHandlers> handlers = new HashMap<String, ElementHandlers>();

    public DispoSaxHandler() throws Exception {
        this.addHandlers(new TestPoint());
        this.addHandlers(new Number());
        this.addHandlers(new Result());
        this.addHandlers(new Stacktrace());
        this.addHandlers(new Actual());
        this.addHandlers(new Expected());
        this.addHandlers(new CheckGroup());
        this.addHandlers(new Config());
        this.addHandlers(new TestPointName());
        this.addHandlers(new ScriptVersion());
        this.addHandlers(new TestPointResults());
        this.addHandlers(new Time());
        this.addHandlers(new TimeSummary());
    }

    public void endElementFound(String uri, String localName, String name) throws Exception {
        ElementHandlers handler = this.handlers.get("*");
        if (handler != null) {
            handler.endElementFound(uri, localName, name, this.stripCData(this.getContents().trim()));
        }
        if ((handler = this.handlers.get(name)) != null) {
            handler.endElementFound(uri, localName, name, this.stripCData(this.getContents().trim()));
        }
    }

    private String stripCData(String content) {
        if (content.startsWith("<![CDATA[")) {
            return content.subSequence(9, content.length() - 3).toString();
        }
        return content;
    }

    public void startElementFound(String uri, String localName, String name, Attributes attributes) throws Exception {
        ElementHandlers handler = this.handlers.get("*");
        if (handler != null) {
            handler.startElementFound(uri, localName, name, attributes);
        }
        if ((handler = this.handlers.get(name)) != null) {
            handler.startElementFound(uri, localName, name, attributes);
        }
    }

    public void addHandlers(ElementHandlers handler) throws Exception {
        ElementHandlers obj = this.handlers.put(handler.getElementName(), handler);
        if (obj != null) {
            throw new Exception("Duplicate handler.");
        }
    }

    public ElementHandlers getHandler(String elementName) {
        return this.handlers.get(elementName);
    }
}

