/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.structure.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import flexjson.JSONSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifactsContainer;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.InterfaceAdapter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

@Path(value="Teams")
public class TeamsResource
extends AbstractConfigResource {
    public TeamsResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.TeamDefinition, atsApi, orcsApi);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="createTeamWeb")
    public String createTeamWeb(String json) {
        try {
            Object[] st;
            Gson gson = new Gson();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            ArtifactToken childArtifact = null;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            List projectDetails = artifact.getAttributes("Project");
            List teamMembers = artifact.getAttributes("TeamMembers");
            List teamLeads = artifact.getAttributes("TeamLeads");
            ArtifactReadable project = null;
            for (String projectGuid : projectDetails) {
                project = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(projectGuid).longValue()).getResults().getExactlyOne();
            }
            ArtifactReadable currentUser = CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser());
            UserId userId = UserId.valueOf((Long)currentUser.getId());
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, userId, "Add New Team");
            childArtifact = tx.createArtifact(AtsArtifactTypes.TeamDefinition, artifact.getName());
            ResultSet results = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andNameEquals("Teams").getResults();
            tx.addChild((ArtifactId)results.getExactlyOne(), (ArtifactId)childArtifact);
            tx.relate((ArtifactId)project, (RelationTypeToken)AtsRelationTypes.ProjectToTeamDefinition_TeamDefinition, (ArtifactId)childArtifact);
            ArrayList projectUsers = new ArrayList();
            projectUsers.addAll(teamMembers);
            projectUsers.addAll(teamLeads);
            Object[] objectArray = st = projectUsers.toArray();
            int n = st.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (projectUsers.indexOf(s) != projectUsers.lastIndexOf(s)) {
                    projectUsers.remove(projectUsers.lastIndexOf(s));
                }
                ++n2;
            }
            for (String projectUser : projectUsers) {
                ResultSet projectMember = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(projectUser).longValue()).getResults();
                tx.relate((ArtifactId)project, (RelationTypeToken)AtsRelationTypes.ProjectToUser_Project, (ArtifactId)projectMember.getExactlyOne());
            }
            for (String team : teamMembers) {
                ResultSet teamMember = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(team).longValue()).getResults();
                tx.relate((ArtifactId)childArtifact, (RelationTypeToken)AtsRelationTypes.TeamMember_Member, (ArtifactId)teamMember.getExactlyOne());
                tx.relate((ArtifactId)project, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)teamMember.getExactlyOne());
            }
            for (String teamLead : teamLeads) {
                ResultSet teamLeader = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(teamLead).longValue()).getResults();
                tx.relate((ArtifactId)childArtifact, (RelationTypeToken)AtsRelationTypes.TeamLead_Lead, (ArtifactId)teamLeader.getExactlyOne());
                tx.relate((ArtifactId)project, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)teamLeader.getExactlyOne());
                ArtifactReadable atsAdmin = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.UserGroup}).andId(ArtifactId.valueOf((Long)136750L)).getResults().getExactlyOne();
                ArtifactReadable oseeAdmin = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.UserGroup}).andNameEquals("OseeAdmin").getResults().getExactlyOne();
                tx.relate((ArtifactId)atsAdmin, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)teamLeader.getExactlyOne());
                tx.relate((ArtifactId)oseeAdmin, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)teamLeader.getExactlyOne());
            }
            List attributes2 = artifact.getAttributes(AtsAttributeTypes.WorkflowDefinition.toString());
            if (attributes2 != null && attributes2.size() > 0) {
                tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinition, (String)attributes2.get(0));
            }
            tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.TeamUsesVersions, "true");
            tx.commit();
            ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{childArtifact}).getResults();
            ArtifactReadable readableArtifact = (ArtifactReadable)result.getExactlyOne();
            TransferableArtifactsContainer artifactsContainer = new TransferableArtifactsContainer();
            TransferableArtifact ar = new TransferableArtifact();
            ar.setName(readableArtifact.getName());
            TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(readableArtifact, (ITransferableArtifact)ar);
            artifactsContainer.addAll(Arrays.asList(ar));
            JSONSerializer serializer = new JSONSerializer();
            String serialize = serializer.deepSerialize((Object)artifactsContainer);
            return serialize;
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="updateTeamWeb")
    public String updateTeamWeb(String json) {
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            String serialize = null;
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            ArtifactReadable currentUser = CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser());
            UserId userId = UserId.valueOf((Long)currentUser.getId());
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction(CommonUtil.getCommonBranch(orcsApi), userId, "Update Release Artifact");
            String attribute = artifact.getUuid();
            if (attribute != null) {
                ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).getResults();
                new ArrayList();
                for (ArtifactReadable artifactReadable : list) {
                    if (!artifactReadable.getGuid().equals(attribute)) continue;
                    List projectDetails = artifact.getAttributes("Project");
                    List teamMembers = artifact.getAttributes("TeamMembers");
                    List teamLeads = artifact.getAttributes("TeamLeads");
                    tx.unrelateFromAll(AtsRelationTypes.ProjectToTeamDefinition_Project, (ArtifactId)artifactReadable);
                    tx.unrelateFromAll(AtsRelationTypes.TeamMember_Team, (ArtifactId)artifactReadable);
                    tx.unrelateFromAll(AtsRelationTypes.TeamLead_Team, (ArtifactId)artifactReadable);
                    ResultSet relatedUserForProject = null;
                    for (String project : projectDetails) {
                        Object[] st;
                        ResultSet projects = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(project).getResults();
                        tx.relate((ArtifactId)projects.getExactlyOne(), (RelationTypeToken)AtsRelationTypes.ProjectToTeamDefinition_Project, (ArtifactId)artifactReadable);
                        relatedUserForProject = ((ArtifactReadable)projects.getExactlyOne()).getRelated(CoreRelationTypes.Users_User);
                        tx.unrelateFromAll(AtsRelationTypes.ProjectToUser_Project, (ArtifactId)projects.getExactlyOne());
                        ArrayList projectUsers = new ArrayList();
                        projectUsers.addAll(teamMembers);
                        projectUsers.addAll(teamLeads);
                        Object[] objectArray = st = projectUsers.toArray();
                        int n = st.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object s = objectArray[n2];
                            if (projectUsers.indexOf(s) != projectUsers.lastIndexOf(s)) {
                                projectUsers.remove(projectUsers.lastIndexOf(s));
                            }
                            ++n2;
                        }
                        for (String projectUser : projectUsers) {
                            ResultSet projectMember = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(projectUser).getResults();
                            tx.relate((ArtifactId)projects.getExactlyOne(), (RelationTypeToken)AtsRelationTypes.ProjectToUser_Project, (ArtifactId)projectMember.getExactlyOne());
                        }
                        ArrayList<ArtifactReadable> removeUserFromProject = new ArrayList<ArtifactReadable>();
                        for (ArtifactReadable relatedUser : relatedUserForProject) {
                            boolean isFound = false;
                            for (String teamMember : teamMembers) {
                                if (!teamMember.equals(relatedUser.getGuid())) continue;
                                isFound = true;
                                break;
                            }
                            for (String teamLead : teamLeads) {
                                if (!teamLead.equals(relatedUser.getGuid())) continue;
                                isFound = true;
                                break;
                            }
                            for (String teamLead : teamLeads) {
                                if (!teamLead.equals(relatedUser.getGuid())) continue;
                                isFound = true;
                                break;
                            }
                            if (isFound) continue;
                            removeUserFromProject.add(artifactReadable);
                        }
                        for (ArtifactReadable removeUser : removeUserFromProject) {
                            tx.unrelate((ArtifactId)projects.getExactlyOne(), (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)removeUser);
                        }
                    }
                    for (String team : teamMembers) {
                        ResultSet teamMember = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(team).getResults();
                        for (ArtifactReadable artifactReadable2 : teamMember) {
                            tx.relate((ArtifactId)artifactReadable, (RelationTypeToken)AtsRelationTypes.TeamMember_Team, (ArtifactId)artifactReadable2);
                        }
                    }
                    for (String teamLead : teamLeads) {
                        ResultSet teamLeader = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(teamLead).getResults();
                        for (ArtifactReadable artifactReadable2 : teamLeader) {
                            tx.relate((ArtifactId)artifactReadable, (RelationTypeToken)AtsRelationTypes.TeamLead_Team, (ArtifactId)artifactReadable2);
                            ArtifactReadable atsAdmin = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.UserGroup}).andId(ArtifactId.valueOf((Long)136750L)).getResults().getExactlyOne();
                            ArtifactReadable oseeAdmin = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.UserGroup}).andNameEquals("OseeAdmin").getResults().getExactlyOne();
                            boolean isOseeAdmin = false;
                            boolean isAtsAdmin = false;
                            ResultSet atsAdminList = atsAdmin.getRelated(CoreRelationTypes.Users_User);
                            for (ArtifactReadable artifactReadable3 : atsAdminList) {
                                if (!artifactReadable3.getGuid().equals(artifactReadable2.getGuid())) continue;
                                isAtsAdmin = true;
                            }
                            ResultSet oseeAdminList = oseeAdmin.getRelated(CoreRelationTypes.Users_User);
                            for (ArtifactReadable artifactReadable3 : oseeAdminList) {
                                if (!artifactReadable3.getGuid().equals(artifactReadable2.getGuid())) continue;
                                isOseeAdmin = true;
                            }
                            if (!isAtsAdmin) {
                                tx.relate((ArtifactId)atsAdmin, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)artifactReadable2);
                            }
                            if (isOseeAdmin) continue;
                            tx.relate((ArtifactId)oseeAdmin, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)artifactReadable2);
                        }
                    }
                    List attributes2 = artifact.getAttributes(AtsAttributeTypes.WorkflowDefinition.getIdString());
                    if (attributes2 != null && attributes2.size() > 0) {
                        tx.setSoleAttributeFromString((ArtifactId)artifactReadable, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinition, (String)attributes2.get(0));
                    }
                    tx.setSoleAttributeFromString((ArtifactId)artifactReadable, (AttributeTypeToken)CoreAttributeTypes.Name, artifact.getName());
                    tx.commit();
                    ArtifactReadable cfr_ignored_0 = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(attribute).excludeDeleted().getResults().getExactlyOne();
                    ArrayList<TransferableArtifact> trans = new ArrayList<TransferableArtifact>();
                    TransferableArtifact ar = new TransferableArtifact();
                    ar.setName(artifactReadable.getName());
                    TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                    trans.add(ar);
                    TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                    container.addAll(trans);
                    JSONSerializer serializer = new JSONSerializer();
                    serialize = serializer.deepSerialize((Object)container);
                    break;
                }
            }
            return serialize;
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="teamsForProject")
    public String getTeamsForProject(String guidFromUi) throws OseeCoreException {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        String guid = guidFromUi;
        ArtifactReadable projectArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(guid, (BranchId)CoreBranches.COMMON, orcsApi);
        TransferableArtifactsContainer container = new TransferableArtifactsContainer();
        ResultSet teamArtifacts = projectArtifact.getRelated(AtsRelationTypes.ProjectToTeamDefinition_TeamDefinition);
        ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
        if (teamArtifacts != null) {
            for (ArtifactReadable artifactReadable : teamArtifacts) {
                TransferableArtifact ar = new TransferableArtifact();
                TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                artifactReadable = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(artifactReadable.getGuid()).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).getResults().getExactlyOne();
                ResultSet attributes = artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkflowDefinition);
                if (attributes != null) {
                    for (AttributeReadable attributeReadable : attributes) {
                        ar.putAttributes(AtsAttributeTypes.WorkflowDefinition.getName(), Arrays.asList(attributeReadable.getValue().toString()));
                    }
                }
                ArrayList<TransferableArtifact> artMembers = new ArrayList<TransferableArtifact>();
                ArrayList<TransferableArtifact> artLeadList = new ArrayList<TransferableArtifact>();
                ResultSet relatedLeads = artifactReadable.getRelated(AtsRelationTypes.TeamLead_Lead);
                for (ArtifactReadable artLeads : relatedLeads) {
                    TransferableArtifact arChild = new TransferableArtifact();
                    TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artLeads, (ITransferableArtifact)arChild);
                    AttributeReadable exactlyOne = (AttributeReadable)artLeads.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne();
                    arChild.putAttributes(CoreAttributeTypes.UserId.getName(), Arrays.asList(exactlyOne.getValue().toString()));
                    artLeadList.add(arChild);
                }
                ar.putRelations(AtsRelationTypes.TeamLead_Lead.getName(), artLeadList);
                ResultSet relatedMembs = artifactReadable.getRelated(AtsRelationTypes.TeamMember_Member);
                for (ArtifactReadable artMem : relatedMembs) {
                    TransferableArtifact arChild = new TransferableArtifact();
                    TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artMem, (ITransferableArtifact)arChild);
                    AttributeReadable exactlyOne = (AttributeReadable)artMem.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne();
                    arChild.putAttributes(CoreAttributeTypes.UserId.getName(), Arrays.asList(exactlyOne.getValue().toString()));
                    artMembers.add(arChild);
                }
                ar.putRelations(AtsRelationTypes.TeamMember_Member.getName(), artMembers);
                listTras.add(ar);
            }
            container.addAll(listTras);
        }
        JSONSerializer serializer = new JSONSerializer();
        String serialize = serializer.deepSerialize((Object)container);
        return serialize;
    }
}

