/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class InterfaceStructureElementToken
extends PLGenericDBObject {
    public static final InterfaceStructureElementToken SENTINEL = new InterfaceStructureElementToken();
    private String Name;
    private Boolean InterfaceElementAlterable;
    private String Notes;
    private String Description;
    private Integer InterfaceElementIndexStart;
    private Integer InterfaceElementIndexEnd;
    private String Units;
    private Long PlatformTypeId;
    private String PlatformTypeName;
    private Double beginByte = 0.0;
    private Double beginWord = 0.0;
    private ApplicabilityToken applicability;
    private String logicalType;
    private String InterfacePlatformTypeMinval;
    private String InterfacePlatformTypeMaxval;
    private String InterfacePlatformTypeDefaultValue;
    private String InterfacePlatformTypeBitSize;
    private String InterfacePlatformTypeDescription;
    private boolean autogenerated = false;
    private boolean includedInCounts = true;
    private boolean hasNegativeEndByteOffset = false;
    private PlatformTypeToken platformType;
    private ArtifactReadable artifactReadable;

    public InterfaceStructureElementToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceStructureElementToken(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name));
        this.setInterfaceElementAlterable((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementAlterable, (Object)false));
        this.setInterfaceElementIndexStart((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexStart, (Object)0));
        this.setInterfaceElementIndexEnd((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexEnd, (Object)0));
        this.setNotes((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Notes, (Object)""));
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        ArtifactReadable pTypeArt = (ArtifactReadable)art.getRelated(CoreRelationTypes.InterfaceElementPlatformType_PlatformType).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (pTypeArt.isValid() && !pTypeArt.getExistingAttributeTypes().isEmpty()) {
            PlatformTypeToken pType = new PlatformTypeToken(pTypeArt);
            this.setPlatformType(pType);
            this.setInterfacePlatformTypeBitSize(pType.getInterfacePlatformTypeBitSize());
            this.setPlatformTypeId(pType.getId());
            this.setPlatformTypeName(pType.getName());
            this.setLogicalType(pType.getInterfaceLogicalType() != null ? pType.getInterfaceLogicalType() : "");
            this.setInterfacePlatformTypeMinval(pType.getInterfacePlatformTypeMinval() != null ? pType.getInterfacePlatformTypeMinval() : "");
            this.setInterfacePlatformTypeMaxval(pType.getInterfacePlatformTypeMaxval() != null ? pType.getInterfacePlatformTypeMaxval() : "");
            this.setInterfacePlatformTypeDefaultValue(pType.getInterfacePlatformTypeDefaultValue() != null ? pType.getInterfacePlatformTypeDefaultValue() : "");
            this.setUnits(pType.getInterfacePlatformTypeUnits() != null ? pType.getInterfacePlatformTypeUnits() : "");
            this.setInterfacePlatformTypeDescription(pType.getDescription() != null ? pType.getDescription() : "");
            this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        } else {
            this.setPlatformType(PlatformTypeToken.SENTINEL);
            this.setInterfacePlatformTypeBitSize("0");
            this.setPlatformTypeId(-1L);
            this.setPlatformTypeName("");
            this.setLogicalType("");
            this.setInterfacePlatformTypeMinval("0");
            this.setInterfacePlatformTypeMaxval("0");
            this.setInterfacePlatformTypeDefaultValue("0");
            this.setUnits("");
            this.setInterfacePlatformTypeDescription("");
        }
        this.artifactReadable = art;
    }

    public InterfaceStructureElementToken(String name, String description, Double beginByte, Double beginWord, Integer size) {
        this(name, description, beginByte, beginWord, size, false);
    }

    public InterfaceStructureElementToken(String name, String description, Double beginByte, Double beginWord, Integer size, boolean offset) {
        super(-1L, name);
        this.setId(-1L);
        this.setName(name);
        this.setDescription(description);
        this.setInterfaceElementAlterable(false);
        this.setInterfaceElementIndexStart(0);
        this.setInterfacePlatformTypeBitSize("8");
        this.setInterfaceElementIndexEnd(size - 1);
        this.setNotes("");
        this.setBeginByte(beginByte);
        this.setBeginWord(beginWord);
        this.setApplicability(ApplicabilityToken.BASE);
        this.setPlatformTypeId(-1L);
        this.setPlatformTypeName("spare");
        this.setUnits("");
        this.setLogicalType("autogenerated");
        this.setInterfacePlatformTypeDefaultValue("");
        this.setInterfacePlatformTypeMaxval("0");
        this.setInterfacePlatformTypeMinval("0");
        this.setAutogenerated(true);
        this.setIncludedInCounts(false);
        this.setHasNegativeEndByteOffset(offset);
        this.setInterfacePlatformTypeDescription("Autogenerated upon page load");
    }

    public InterfaceStructureElementToken(Long id, String name, ApplicabilityToken applicability, PlatformTypeToken pType) {
        super(id, name);
        this.setInterfaceElementAlterable(false);
        this.setInterfaceElementIndexStart(0);
        this.setInterfaceElementIndexEnd(0);
        this.setApplicability(applicability);
        this.setPlatformType(pType);
        this.setInterfacePlatformTypeBitSize(pType.getInterfacePlatformTypeBitSize());
        this.setPlatformTypeId(pType.getId());
        this.setPlatformTypeName(pType.getName());
        this.setLogicalType(pType.getInterfaceLogicalType());
        this.setInterfacePlatformTypeMinval(pType.getInterfacePlatformTypeMinval());
        this.setInterfacePlatformTypeMaxval(pType.getInterfacePlatformTypeMaxval());
        this.setInterfacePlatformTypeDefaultValue(pType.getInterfacePlatformTypeDefaultValue());
        this.setUnits(pType.getInterfacePlatformTypeUnits());
        this.setInterfacePlatformTypeDescription(pType.getDescription());
        this.setAutogenerated(true);
        this.setInterfacePlatformTypeDescription("Autogenerated upon page load");
    }

    public InterfaceStructureElementToken(Long id, String name) {
        super(id, name);
    }

    public InterfaceStructureElementToken() {
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public String getNotes() {
        return this.Notes;
    }

    public void setNotes(String notes) {
        this.Notes = notes;
    }

    public Boolean getInterfaceElementAlterable() {
        return this.InterfaceElementAlterable;
    }

    public void setInterfaceElementAlterable(Boolean interfaceElementAlterable) {
        this.InterfaceElementAlterable = interfaceElementAlterable;
    }

    public Integer getInterfaceElementIndexStart() {
        return this.InterfaceElementIndexStart;
    }

    public void setInterfaceElementIndexStart(Integer interfaceElementIndexStart) {
        this.InterfaceElementIndexStart = interfaceElementIndexStart;
    }

    public Integer getInterfaceElementIndexEnd() {
        return this.InterfaceElementIndexEnd;
    }

    public void setInterfaceElementIndexEnd(Integer interfaceElementIndexEnd) {
        this.InterfaceElementIndexEnd = interfaceElementIndexEnd;
    }

    public Long getPlatformTypeId() {
        return this.PlatformTypeId;
    }

    public void setPlatformTypeId(Long platformTypeId) {
        this.PlatformTypeId = platformTypeId;
    }

    public String getPlatformTypeName2() {
        return this.PlatformTypeName;
    }

    public void setPlatformTypeName(String platformTypeName) {
        this.PlatformTypeName = platformTypeName;
    }

    public Double getBeginByte() {
        return this.beginByte;
    }

    public void setBeginByte(Double beginByte) {
        this.beginByte = beginByte;
    }

    public Double getEndByte() {
        return (this.beginByte + this.getInterfacePlatformTypeByteSize() * (double)Math.max(1, this.getArrayLength()) - 1.0) % 4.0;
    }

    public Double getBeginWord() {
        return this.beginWord;
    }

    public void setBeginWord(Double beginWord) {
        this.beginWord = beginWord;
    }

    public Double getEndWord() {
        return Math.ceil((this.getBeginWord() * 4.0 + this.getBeginByte() + this.getInterfacePlatformTypeByteSize() * (double)Math.max(1, this.getArrayLength())) / 4.0) - 1.0;
    }

    @JsonIgnore
    public Double getEndingByteNoReset() {
        return this.getEndWord() * 4.0;
    }

    @JsonIgnore
    public Double getEndingBitNoReset() {
        return this.getEndingByteNoReset() * 8.0;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public String getLogicalType() {
        return this.logicalType;
    }

    public void setLogicalType(String logicalType) {
        this.logicalType = logicalType;
    }

    public String getInterfacePlatformTypeMinval() {
        return this.InterfacePlatformTypeMinval;
    }

    public void setInterfacePlatformTypeMinval(String interfacePlatformTypeMinval) {
        this.InterfacePlatformTypeMinval = interfacePlatformTypeMinval;
    }

    public String getInterfacePlatformTypeMaxval() {
        return this.InterfacePlatformTypeMaxval;
    }

    public void setInterfacePlatformTypeMaxval(String interfacePlatformTypeMaxval) {
        this.InterfacePlatformTypeMaxval = interfacePlatformTypeMaxval;
    }

    public String getInterfacePlatformTypeDefaultValue() {
        return this.InterfacePlatformTypeDefaultValue;
    }

    public void setInterfacePlatformTypeDefaultValue(String interfacePlatformTypeDefaultValue) {
        this.InterfacePlatformTypeDefaultValue = interfacePlatformTypeDefaultValue;
    }

    public String getUnits() {
        return this.Units;
    }

    public void setUnits(String units) {
        this.Units = units;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public void setAutogenerated(boolean autogenerated) {
        this.autogenerated = autogenerated;
    }

    @JsonIgnore
    public boolean isIncludedInCounts() {
        return this.includedInCounts;
    }

    @JsonIgnore
    public void setIncludedInCounts(boolean includedInCounts) {
        this.includedInCounts = includedInCounts;
    }

    @JsonIgnore
    public double getInterfacePlatformTypeBitSize() {
        return Double.parseDouble(this.InterfacePlatformTypeBitSize);
    }

    @JsonIgnore
    public double getInterfacePlatformTypeByteSize() {
        return Double.parseDouble(this.InterfacePlatformTypeBitSize) / 8.0;
    }

    @JsonIgnore
    public double getInterfacePlatformTypeWordSize() {
        return Math.floor(this.getInterfacePlatformTypeByteSize() / 4.0);
    }

    @JsonIgnore
    public int getArrayLength() {
        return this.getInterfaceElementIndexEnd() - this.getInterfaceElementIndexStart() + 1;
    }

    public double getElementSizeInBits() {
        return (double)this.getArrayLength() * this.getInterfacePlatformTypeBitSize();
    }

    public double getElementSizeInBytes() {
        return (double)this.getArrayLength() * this.getInterfacePlatformTypeBitSize() / 8.0;
    }

    public void setInterfacePlatformTypeBitSize(String interfacePlatformTypeBitSize) {
        this.InterfacePlatformTypeBitSize = interfacePlatformTypeBitSize;
    }

    @JsonIgnore
    public boolean isHasNegativeEndByteOffset() {
        return this.hasNegativeEndByteOffset;
    }

    @JsonIgnore
    public void setHasNegativeEndByteOffset(boolean hasNegativeEndByteOffset) {
        this.hasNegativeEndByteOffset = hasNegativeEndByteOffset;
    }

    public String getInterfacePlatformTypeDescription() {
        return this.InterfacePlatformTypeDescription;
    }

    public void setInterfacePlatformTypeDescription(String interfacePlatformTypeDescription) {
        this.InterfacePlatformTypeDescription = interfacePlatformTypeDescription;
    }

    @JsonIgnore
    public PlatformTypeToken getPlatformType() {
        return this.platformType;
    }

    @JsonIgnore
    public void setPlatformType(PlatformTypeToken platformType) {
        this.platformType = platformType;
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.artifactReadable;
    }
}

