/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.internal.InterfaceConnectionAccessor;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfaceConnectionViewApiImpl
implements InterfaceConnectionViewApi {
    private ArtifactAccessor<InterfaceConnection> accessor;

    InterfaceConnectionViewApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new InterfaceConnectionAccessor(orcsApi));
    }

    @Override
    public ArtifactAccessor<InterfaceConnection> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceConnection> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<InterfaceConnection> query(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public InterfaceConnection getRelatedFromMessage(InterfaceMessageToken message) {
        return message.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceConnectionContent_Connection).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceConnection((ArtifactReadable)a)).findFirst().orElse(InterfaceConnection.SENTINEL);
    }

    @Override
    public InterfaceConnection get(BranchId branch, ArtifactId connectionId) {
        try {
            return this.getAccessor().get(branch, connectionId, InterfaceConnection.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return InterfaceConnection.SENTINEL;
        }
    }

    @Override
    public Collection<InterfaceConnection> queryExact(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<InterfaceConnection> query(BranchId branch, MimAttributeQuery query, boolean isExact) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, isExact, InterfaceConnection.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceConnection>();
        }
    }
}

