/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.io.OutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.internal.IcdGenerator;

public final class IcdStreamingOutput
implements StreamingOutput {
    private final MimApi mimApi;
    private final BranchId branch;
    private final ArtifactId viewId;
    private final ArtifactId connectionId;

    public IcdStreamingOutput(MimApi mimApi, BranchId branch, ArtifactId viewId, ArtifactId connectionId) {
        this.branch = branch;
        this.viewId = viewId;
        this.connectionId = connectionId;
        this.mimApi = mimApi;
    }

    public void write(OutputStream output) {
        try {
            IcdGenerator generator = new IcdGenerator(this.mimApi);
            generator.runOperation(output, this.branch, this.viewId, this.connectionId);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }
}

