/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization.forest.morphology;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.define.rest.synchronization.IdentifierType;
import org.eclipse.osee.define.rest.synchronization.IdentifierTypeGroup;
import org.eclipse.osee.define.rest.synchronization.LinkType;
import org.eclipse.osee.define.rest.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThing;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class AbstractGroveThing
implements GroveThing {
    private static int minGroveThingRank = 1;
    private static int maxGroveThingRank = 3;
    private static int minNativeGroveThingRank = 1;
    private static int maxNativeGroveThingRank = 3;
    private Object foreignHierarchy;
    protected Object foreignThing;
    protected Map<LinkType, Object> links;
    protected Map<LinkType, LinkRank> linkRank;
    protected Predicate<LinkType> linkTypeValidator;
    protected Function<Object, Object>[] nativeKeyFunctions;
    protected Optional<Object[]> nativeKeys;
    protected int nativeRank;
    protected Object[] nativeThings;
    protected Predicate<Object[]> nativeThingValidator;
    protected GroveThing[] parentGroveThings;
    protected Predicate<GroveThing[]> parentsValidator;
    protected IdentifierType.Identifier[] primaryKeys;
    protected int primaryRank;
    protected boolean providesNativeKeys;

    public AbstractGroveThing(IdentifierType.Identifier groveThingKey, int primaryRank, int nativeRank, boolean providesNativeKeys, Predicate<LinkType> linkTypeValidator, Map<LinkType, LinkRank> linkRank, Predicate<GroveThing[]> parentsValidator, Predicate<Object[]> nativeThingValidator, Function<Object, Object>[] nativeKeyFunctions, GroveThing ... parents) {
        assert (Objects.nonNull(groveThingKey)) : "AbstractGroveThing constructor GroveThingKey is null.";
        assert (primaryRank >= minGroveThingRank && primaryRank <= maxGroveThingRank) : "AbstractGroveThing constructor Priamry Rank is out of range.";
        assert (nativeRank >= minNativeGroveThingRank && nativeRank <= maxNativeGroveThingRank) : "AbstractGroveThing constructor Priamry Rank is out of range.";
        assert (Objects.nonNull(linkRank)) : "AbstractGroveThing constructor Link Rank is null.";
        assert (Objects.nonNull(parentsValidator)) : "AbstractGroveThing constructor Parent Validator is null.";
        assert (parentsValidator.test(parents)) : "AbstractGroveThing constructor parents failed to validate.";
        assert (Objects.nonNull(nativeThingValidator)) : "AbstractGroveThing constructor Native Thing Validator is null.";
        this.primaryRank = primaryRank;
        this.nativeRank = nativeRank;
        this.providesNativeKeys = providesNativeKeys;
        this.linkTypeValidator = linkTypeValidator;
        this.parentsValidator = parentsValidator;
        this.nativeThingValidator = nativeThingValidator;
        this.nativeKeyFunctions = nativeKeyFunctions;
        this.foreignHierarchy = null;
        this.foreignThing = null;
        this.links = new HashMap<LinkType, Object>();
        this.linkRank = Objects.requireNonNull(linkRank);
        this.nativeThings = null;
        this.nativeKeys = Optional.empty();
        GroveThing[] groveThingArray = this.parentGroveThings = Objects.nonNull(parents) && parents.length > 0 ? parents : null;
        if (this.rank() == 1) {
            this.primaryKeys = new IdentifierType.Identifier[]{groveThingKey};
        } else {
            this.primaryKeys = new IdentifierType.Identifier[this.rank()];
            int i = 0;
            while (i < this.rank() - 1) {
                this.primaryKeys[i] = parents[i].getIdentifier();
                ++i;
            }
            this.primaryKeys[this.rank() - 1] = groveThingKey;
        }
    }

    @Override
    public Object getForeignHierarchy() {
        return this.foreignHierarchy;
    }

    @Override
    public Object getForeignThing() {
        return this.foreignThing;
    }

    @Override
    public Optional<GroveThing> getLinkScalar(LinkType linkType) {
        assert (Objects.nonNull(linkType) && LinkRank.SCALAR.equals((Object)this.linkRank.get(linkType)) && (Objects.isNull(this.linkTypeValidator) || this.linkTypeValidator.test(linkType)));
        return LinkRank.SCALAR.equals((Object)this.linkRank.get(linkType)) ? Optional.ofNullable((GroveThing)this.links.get(Objects.requireNonNull(linkType))) : Optional.empty();
    }

    @Override
    public Optional<Collection<GroveThing>> getLinkVector(LinkType linkType) {
        assert (Objects.nonNull(linkType) && (LinkRank.VECTOR.equals((Object)this.linkRank.get(linkType)) || LinkRank.MAP.equals((Object)this.linkRank.get(linkType))) && (Objects.isNull(this.linkTypeValidator) || this.linkTypeValidator.test(linkType)));
        switch (this.linkRank.get(linkType)) {
            case MAP: {
                return Optional.ofNullable(((Map)this.links.get(Objects.requireNonNull(linkType))).values());
            }
            case VECTOR: {
                return Optional.ofNullable((List)this.links.get(Objects.requireNonNull(linkType)));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<GroveThing> getLinkVectorElement(LinkType linkType, int index) {
        assert (Objects.nonNull(linkType) && LinkRank.VECTOR.equals((Object)this.linkRank.get(linkType)) && (Objects.isNull(this.linkTypeValidator) || this.linkTypeValidator.test(linkType)));
        switch (this.linkRank.get(linkType)) {
            case MAP: {
                return Optional.empty();
            }
            case VECTOR: {
                return Optional.ofNullable((GroveThing)((List)this.links.get(Objects.requireNonNull(linkType))).get(index));
            }
        }
        return Optional.empty();
    }

    @Override
    public IdentifierType.Identifier getIdentifier() {
        return this.primaryKeys[this.rank() - 1];
    }

    @Override
    public Optional<GroveThing> getParent(int selector) {
        return selector >= 0 && selector <= this.rank() - 1 ? Optional.of(this.parentGroveThings[selector]) : (selector <= -1 && selector >= 1 - this.rank() ? Optional.of(this.parentGroveThings[this.rank() - 1 + selector]) : Optional.empty());
    }

    @Override
    public Optional<Object[]> getPrimaryKeys() {
        return Optional.of(this.primaryKeys);
    }

    @Override
    public Optional<Object[]> getNativeKeys() {
        return this.nativeKeys;
    }

    @Override
    public Object getNativeThing() {
        return this.nativeThings[this.nativeRank() - 1];
    }

    @Override
    public IdentifierType getType() {
        return this.getIdentifier().getType();
    }

    @Override
    public boolean mayProvideNativeKeys() {
        return this.providesNativeKeys;
    }

    @Override
    public boolean hasNativeKeys() {
        return this.providesNativeKeys && this.nativeKeys.isPresent();
    }

    @Override
    public boolean isInGroup(IdentifierTypeGroup identifierTypeGroup) {
        return this.getIdentifier().isInGroup(identifierTypeGroup);
    }

    @Override
    public boolean isType(LinkType linkType) {
        return linkType instanceof IdentifierType ? this.getIdentifier().isType((IdentifierType)linkType) : (linkType instanceof IdentifierTypeGroup ? this.getIdentifier().isInGroup((IdentifierTypeGroup)linkType) : false);
    }

    @Override
    public int nativeRank() {
        return this.nativeRank;
    }

    @Override
    public int rank() {
        return this.primaryRank;
    }

    @Override
    public void setForeignHierarchy(Object foreignHierarchy) {
        this.foreignHierarchy = foreignHierarchy;
    }

    @Override
    public void setForeignThing(Object foreignThing) {
        assert (Objects.nonNull(foreignThing));
        assert (Objects.isNull(this.foreignThing));
        this.foreignThing = foreignThing;
    }

    @Override
    public void setLinkScalar(LinkType linkType, GroveThing linkedGroveThing) {
        assert (Objects.nonNull(linkType) && Objects.nonNull(linkedGroveThing) && (Objects.isNull(this.linkTypeValidator) || this.linkTypeValidator.test(linkType)) && LinkRank.SCALAR.equals((Object)this.linkRank.get(linkType)) && !this.links.containsKey(linkType));
        if (!Objects.requireNonNull(linkedGroveThing).isType(Objects.requireNonNull(linkType))) {
            throw new UnexpectedGroveThingTypeException(linkedGroveThing, linkType);
        }
        this.links.put(linkType, linkedGroveThing);
    }

    @Override
    public void setLinkVectorElement(LinkType linkType, GroveThing linkedGroveThing) {
        assert (Objects.nonNull(linkType) && Objects.nonNull(linkedGroveThing) && (Objects.isNull(this.linkTypeValidator) || this.linkTypeValidator.test(linkType)) && (LinkRank.MAP.equals((Object)this.linkRank.get(linkType)) || LinkRank.VECTOR.equals((Object)this.linkRank.get(linkType))));
        if (!Objects.requireNonNull(linkedGroveThing).isType(Objects.requireNonNull(linkType))) {
            throw new UnexpectedGroveThingTypeException(linkedGroveThing, linkType);
        }
        switch (this.linkRank.get(linkType)) {
            case MAP: {
                HashMap<IdentifierType.Identifier, GroveThing> map = (HashMap<IdentifierType.Identifier, GroveThing>)this.links.get(Objects.requireNonNull(linkType));
                if (Objects.isNull(map)) {
                    map = new HashMap<IdentifierType.Identifier, GroveThing>();
                    this.links.put(linkType, map);
                }
                map.put(Objects.requireNonNull(linkedGroveThing).getIdentifier(), linkedGroveThing);
                break;
            }
            case VECTOR: {
                ArrayList<GroveThing> list = (ArrayList<GroveThing>)this.links.get(Objects.requireNonNull(linkType));
                if (Objects.isNull(list)) {
                    list = new ArrayList<GroveThing>();
                    this.links.put(linkType, list);
                }
                list.add(Objects.requireNonNull(linkedGroveThing));
            }
        }
    }

    @Override
    public GroveThing setNativeThings(Object ... nativeThings) {
        assert (Objects.isNull(this.nativeThings) && (Objects.isNull(this.nativeThingValidator) || this.nativeThingValidator.test(nativeThings)));
        this.nativeThings = nativeThings;
        if (!this.providesNativeKeys || Objects.isNull(this.nativeKeyFunctions)) {
            this.nativeKeys = Optional.empty();
            return this;
        }
        Object[] nativeThingKeys = new Object[this.nativeRank()];
        int i = 0;
        while (i < this.nativeRank()) {
            nativeThingKeys[i] = this.nativeKeyFunctions[i].apply(this.nativeThings[i]);
            ++i;
        }
        this.nativeKeys = Optional.of(nativeThingKeys);
        return this;
    }

    @Override
    public Stream<GroveThing> streamLinks(LinkType linkType) {
        assert (Objects.nonNull(linkType) && (Objects.isNull(this.linkTypeValidator) || this.linkTypeValidator.test(linkType)) && this.links.containsKey(linkType));
        Object object = this.links.get(linkType);
        if (Objects.isNull(object)) {
            return Stream.empty();
        }
        switch (this.linkRank.get(linkType)) {
            case SCALAR: {
                return Stream.of((GroveThing)this.links.get(linkType));
            }
            case MAP: {
                return ((Map)this.links.get(linkType)).values().stream();
            }
            case VECTOR: {
                return ((List)this.links.get(linkType)).stream();
            }
        }
        return Stream.empty();
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)(indent + 0));
        String indent1 = IndentedString.indentString((int)(indent + 1));
        String indent2 = IndentedString.indentString((int)(indent + 2));
        String name = this.getClass().getName();
        outMessage.append(indent0).append(name).append("\n");
        if (Objects.nonNull(this.primaryKeys)) {
            outMessage.append(indent1).append("Grove Thing Keys: ").append(Arrays.stream(this.primaryKeys).map(IdentifierType.Identifier::toString).collect(Collectors.joining(", "))).append("\n");
        }
        if (Objects.nonNull(this.links)) {
            outMessage.append(indent1).append("Links:            ").append(this.links.values().stream().flatMap(linkObject -> linkObject instanceof GroveThing ? Stream.of((GroveThing)linkObject) : (linkObject instanceof List ? ((List)linkObject).stream() : ((Map)linkObject).values().stream())).map(GroveThing::getIdentifier).map(IdentifierType.Identifier::toString).collect(Collectors.joining(", ", "[ ", " ]"))).append("\n");
        }
        if (Objects.nonNull(this.nativeThings)) {
            outMessage.append(indent1).append("Native Things:    ").append("\n");
            int i = 0;
            while (i < this.nativeRank()) {
                outMessage.append(indent2).append("Native Thing[ ").append(i).append(" ]: ");
                if (i >= this.nativeThings.length) {
                    outMessage.append("(index-out-of-bounds)").append("\n");
                } else if (Objects.isNull(this.nativeThings[i])) {
                    outMessage.append("(null)").append("\n");
                } else if (this.nativeThings[i] instanceof ToMessage) {
                    outMessage.append("\n");
                    ((ToMessage)this.nativeThings[i]).toMessage(indent + 3, outMessage);
                } else {
                    outMessage.append(this.nativeThings[i].toString()).append("\n");
                }
                ++i;
            }
            this.getNativeKeys().ifPresent(nativeKeys -> {
                outMessage.append(indent1).append("Native Thing Keys: ").append("\n");
                int i = 0;
                while (i < this.nativeRank()) {
                    outMessage.append(indent2).append("Key[ ").append(i).append(" ]: ");
                    if (i >= this.nativeThings.length) {
                        outMessage.append("(index-out-of-bounds)").append("\n");
                    } else if (Objects.isNull(this.nativeThings[i])) {
                        outMessage.append("(null)").append("\n");
                    } else if (nativeKeys[i] instanceof ToMessage) {
                        outMessage.append("\n");
                        ((ToMessage)nativeKeys[i]).toMessage(indent + 3, outMessage);
                    } else {
                        outMessage.append(nativeKeys[i].toString()).append("\n");
                    }
                    ++i;
                }
            });
        }
        outMessage.append(indent1).append("Foreign Hierarchy: ").append(Objects.nonNull(this.foreignHierarchy) ? this.foreignHierarchy : "(null)").append("\n").append(indent1).append("Foreign Thing:     ").append(Objects.nonNull(this.foreignThing) ? this.foreignThing : "(null)").append("\n");
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    public static enum LinkRank {
        SCALAR,
        MAP,
        VECTOR;

    }
}

