/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.util;

import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.orcs.OrcsApi;

public class UserUtility {
    public static ArtifactReadable getUserById(OrcsApi orcsApi, String userId) throws OseeCoreException {
        return (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).and((AttributeTypeId)CoreAttributeTypes.UserId, userId, QueryOption.EXACT_MATCH_OPTIONS).getResults().getExactlyOne();
    }

    public static ArtifactReadable getUserByGUID(OrcsApi orcsApi, String guid) throws OseeCoreException {
        return (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andGuid(guid).getResults().getExactlyOne();
    }

    public static ResultSet<ArtifactReadable> getUserArtifacts(OrcsApi orcsApi) throws OseeCoreException {
        return orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).getResults();
    }

    public static String getUserNameByUserId(String userId) {
        if (userId.equals("UnAssigned")) {
            return userId;
        }
        if (!"".equals(userId.trim())) {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            try {
                ArtifactReadable user = UserUtility.getUserById(orcsApi, userId);
                String userName = UserUtility.getUserName(user);
                if (!userName.isEmpty()) {
                    return userName;
                }
            }
            catch (ItemDoesNotExist itemDoesNotExist) {
                return userId;
            }
        }
        return userId;
    }

    public static String getUserId(ArtifactReadable user) {
        List userIdObject = user.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.UserId);
        if (!userIdObject.isEmpty() && userIdObject.get(0) instanceof String) {
            return (String)userIdObject.get(0);
        }
        return "";
    }

    public static String getUserName(ArtifactReadable user) {
        String userName = user.getName();
        if (userName.contains("(")) {
            userName = userName.split("\\(")[0].trim();
        }
        if (userName != null && !userName.isEmpty()) {
            return userName;
        }
        return "";
    }
}

