/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.structure.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import flexjson.JSONSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifactsContainer;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.InterfaceAdapter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

@Path(value="Components")
public class ComponentsResource
extends AbstractConfigResource {
    public ComponentsResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.ActionableItem, atsApi, orcsApi);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="teamsuser")
    public String getAssociatedTeamsUsersForComponent(String attributes) {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        if (attributes != null) {
            Object[] st;
            ArtifactReadable compArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(attributes, CommonUtil.getCommonBranch(orcsApi), orcsApi);
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            ArrayList<TransferableArtifact> listOfUsers = new ArrayList<TransferableArtifact>();
            boolean isConfigured = false;
            ResultSet listTeamArtifact = compArtifact.getRelated(AtsRelationTypes.TeamActionableItem_TeamDefinition);
            if (!isConfigured) {
                TransferableArtifact teamArtifact = null;
                for (ArtifactReadable artifactReadable : listTeamArtifact) {
                    ArrayList<String> l;
                    ResultSet attributes2;
                    TransferableArtifact ar;
                    ArtifactReadable exactlyOne = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(artifactReadable.getGuid()).getResults().getExactlyOne();
                    teamArtifact = new TransferableArtifact();
                    TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)teamArtifact);
                    ResultSet relatedArtifact = exactlyOne.getRelated(AtsRelationTypes.TeamLead_Lead);
                    ResultSet relatedArtifact1 = exactlyOne.getRelated(AtsRelationTypes.TeamMember_Member);
                    for (ArtifactReadable teamLead : relatedArtifact) {
                        ar = new TransferableArtifact();
                        TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(teamLead, (ITransferableArtifact)ar);
                        attributes2 = teamLead.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId);
                        for (AttributeReadable attributeReadable : attributes2) {
                            l = new ArrayList<String>();
                            l.add(attributeReadable.getValue().toString());
                            ar.putAttributes(CoreAttributeTypes.UserId.toString(), l);
                        }
                        listOfUsers.add(ar);
                    }
                    for (ArtifactReadable teamMembers : relatedArtifact1) {
                        ar = new TransferableArtifact();
                        TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(teamMembers, (ITransferableArtifact)ar);
                        attributes2 = teamMembers.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId);
                        for (AttributeReadable attributeReadable : attributes2) {
                            l = new ArrayList();
                            l.add(attributeReadable.getValue().toString());
                            ar.putAttributes(CoreAttributeTypes.UserId.toString(), l);
                        }
                        listOfUsers.add(ar);
                    }
                }
                if (teamArtifact != null) {
                    ArrayList<TransferableArtifact> list = new ArrayList<TransferableArtifact>();
                    list.add(teamArtifact);
                    container.setArtifactList(list);
                }
            }
            Object[] objectArray = st = listOfUsers.toArray();
            int n = st.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (listOfUsers.indexOf(s) != listOfUsers.lastIndexOf(s)) {
                    listOfUsers.remove(listOfUsers.lastIndexOf(s));
                }
                ++n2;
            }
            container.addAll(listOfUsers);
            JSONSerializer serializer = new JSONSerializer();
            String serialize = serializer.deepSerialize((Object)container);
            return serialize;
        }
        return null;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="createTest")
    public String createComponentTest(String json) {
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            ArtifactToken childArtifact = null;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Add New Component");
            String uuid = AtsRelationTypes.TeamActionableItem_TeamDefinition.getGuid().toString();
            String type1 = AtsRelationTypes.TeamActionableItem_TeamDefinition.getRelationType().toString();
            String side = AtsRelationTypes.TeamActionableItem_TeamDefinition.getSide().toString();
            String key = "RelationTypeSide - uuid=[" + uuid + "] type=[" + type1 + "] side=[" + side + "]";
            List relatedArtifacts = artifact.getRelatedArtifacts(key);
            for (ITransferableArtifact transferableArtifact : relatedArtifacts) {
                ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(transferableArtifact.getUuid()).longValue()).getResults();
                ArtifactReadable team = null;
                if (result != null && result.size() == 1) {
                    team = (ArtifactReadable)result.getOneOrNull();
                    team.getRelated(AtsRelationTypes.ProjectToTeamDefinition_Project).getOneOrNull();
                }
                childArtifact = tx.createArtifact(AtsArtifactTypes.ActionableItem, artifact.getName());
                ResultSet results = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andNameEquals("Actionable Items").getResults();
                tx.addChild((ArtifactId)results.getExactlyOne(), (ArtifactId)childArtifact);
                Map attributes = artifact.getAttributes();
                Set entrySet = attributes.entrySet();
                for (Map.Entry entry : entrySet) {
                    String type = (String)entry.getKey();
                    String[] split = type.split(";");
                    List value = (List)entry.getValue();
                    for (String string : value) {
                        if (split.length == 2 && split[1].equals("Date")) {
                            Date date = CommonUtil.getDate(string);
                            tx.setSoleAttributeValue((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), (Object)date);
                            continue;
                        }
                        tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), string);
                    }
                }
                tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.Actionable, "true");
                if (team == null) continue;
                tx.relate((ArtifactId)team, (RelationTypeToken)AtsRelationTypes.TeamActionableItem_ActionableItem, (ArtifactId)childArtifact);
            }
            tx.commit();
            ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{childArtifact}).getResults();
            ArtifactReadable readableArtifact = (ArtifactReadable)result.getExactlyOne();
            TransferableArtifact ar = new TransferableArtifact();
            ar.setName(readableArtifact.getName());
            TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(readableArtifact, (ITransferableArtifact)ar);
            TransferableArtifactsContainer artifactsContainer = new TransferableArtifactsContainer();
            artifactsContainer.addAll(Arrays.asList(ar));
            JSONSerializer serializer = new JSONSerializer();
            String serialize = serializer.deepSerialize((Object)artifactsContainer);
            return serialize;
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/updatePackage")
    public String updateComponentWeb(String json) {
        try {
            ResultSet list;
            Iterator iterator;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String attribute = artifact.getUuid();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Update Component Artifact");
            if (attribute != null && (iterator = (list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andUuid(Long.valueOf(attribute).longValue()).excludeDeleted().getResults()).iterator()).hasNext()) {
                ArtifactReadable artifactReadable = (ArtifactReadable)iterator.next();
                Map attributes = artifact.getAttributes();
                Set entrySet = attributes.entrySet();
                for (Map.Entry entry : entrySet) {
                    String type = (String)entry.getKey();
                    String[] split = type.split(";");
                    List value = (List)entry.getValue();
                    for (String string : value) {
                        if (split.length == 2 && split[1].equals("Date")) {
                            Date date = CommonUtil.getDate(string);
                            tx.setSoleAttributeValue((ArtifactId)artifactReadable, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), (Object)date);
                            continue;
                        }
                        tx.setSoleAttributeFromString((ArtifactId)artifactReadable, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), string);
                    }
                }
                tx.commit();
                ArrayList<TransferableArtifact> trans = new ArrayList<TransferableArtifact>();
                TransferableArtifact ar = new TransferableArtifact();
                ar.setName(artifactReadable.getName());
                TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                trans.add(ar);
                TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                container.addAll(trans);
                JSONSerializer serializer = new JSONSerializer();
                String serialize = serializer.deepSerialize((Object)container);
                return serialize;
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json;
    }
}

