/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.api.synchronization.ExportRequest;
import org.eclipse.osee.define.api.synchronization.ImportMapping;
import org.eclipse.osee.define.api.synchronization.ImportRequest;
import org.eclipse.osee.define.api.synchronization.Root;
import org.eclipse.osee.define.api.synchronization.SynchronizationEndpoint;
import org.eclipse.osee.define.rest.synchronization.BadDocumentRootException;
import org.eclipse.osee.define.rest.synchronization.RootList;
import org.eclipse.osee.define.rest.synchronization.SynchronizationArtifact;
import org.eclipse.osee.define.rest.synchronization.UnknownSynchronizationArtifactTypeException;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.orcs.OrcsApi;

public class SynchronizationEndpointImpl
implements SynchronizationEndpoint {
    private static SynchronizationEndpointImpl synchronizationEndpointImpl = null;
    private final OrcsApi orcsApi;

    private SynchronizationEndpointImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public static synchronized SynchronizationEndpointImpl create(OrcsApi orcsApi) {
        return Objects.isNull(synchronizationEndpointImpl) ? (synchronizationEndpointImpl = new SynchronizationEndpointImpl(Objects.requireNonNull(orcsApi))) : synchronizationEndpointImpl;
    }

    private String buildExceptionMessage(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return new StringBuilder(2048).append("\n").append("<---S-E-R-V-E-R---E-X-C-E-P-T-I-O-N--->").append("\n").append(e.getMessage()).append("\n").append(stringWriter.toString()).append("\n").toString();
    }

    private String buildBadInputMessage(String parameterName, Object badObject) {
        String indent0 = IndentedString.indentString((int)0);
        String indent1 = IndentedString.indentString((int)1);
        StringBuilder message = new StringBuilder(2048).append("\n").append(indent0).append("<---S-E-R-V-E-R---E-X-C-E-P-T-I-O-N--->").append("\n").append(indent0).append("Bad input parameter.").append("\n").append(indent1).append("Parameter:                ").append(parameterName).append("\n").append(indent1).append("Received Parameter Value: ");
        if (Objects.isNull(badObject)) {
            message.append("(null)").append("\n");
        } else if (badObject instanceof ToMessage) {
            ((ToMessage)badObject).toMessage(2, message);
        } else {
            message.append(badObject.toString()).append("\n");
        }
        return message.toString();
    }

    public InputStream export(ExportRequest exportRequest) {
        try {
            this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        }
        catch (OseeAccessDeniedException e) {
            throw new NotAuthorizedException(this.buildExceptionMessage(e), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        if (Objects.isNull(exportRequest) || !exportRequest.isValid()) {
            throw new BadRequestException(this.buildBadInputMessage("exportRequest", exportRequest), Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        try {
            String synchronizationArtifactType = exportRequest.getSynchronizationArtifactType();
            Root[] rootsArray = exportRequest.getRoots();
            RootList rootList = RootList.create(this.orcsApi, synchronizationArtifactType);
            Root[] rootArray = rootsArray;
            int n = rootsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Root root = rootArray[n2];
                rootList.add(root);
                ++n2;
            }
            rootList.validate();
            SynchronizationArtifact synchronizationArtifact = SynchronizationArtifact.create(rootList);
            synchronizationArtifact.build();
            InputStream inputStream = synchronizationArtifact.serialize();
            return inputStream;
        }
        catch (BadDocumentRootException | UnknownSynchronizationArtifactTypeException e) {
            throw new BadRequestException(this.buildExceptionMessage(e), Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        catch (Exception e) {
            throw new ServerErrorException(this.buildExceptionMessage(e), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    public void importSynchronizationArtifact(ImportRequest importRequest, InputStream inputStream) {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream reqIfInputStream = inputStream;){
                try {
                    this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
                }
                catch (OseeAccessDeniedException e) {
                    throw new NotAuthorizedException(this.buildExceptionMessage(e), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                }
                if (Objects.isNull(importRequest) || !importRequest.isValid()) {
                    throw new BadRequestException(this.buildBadInputMessage("importRequest", importRequest), Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
                }
                if (Objects.isNull(inputStream)) {
                    throw new BadRequestException(this.buildBadInputMessage("inputStream", inputStream), Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
                }
                String synchronizationArtifactType = importRequest.getSynchronizationArtifactType();
                ImportMapping[] importMappingsArray = importRequest.getImportMappings();
                RootList rootList = RootList.create(this.orcsApi, synchronizationArtifactType);
                ImportMapping[] importMappingArray = importMappingsArray;
                int n = importMappingsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportMapping importMapping = importMappingArray[n2];
                    rootList.add(importMapping.getRoot());
                    ++n2;
                }
                SynchronizationArtifact synchronizationArtifact = SynchronizationArtifact.create(rootList);
                synchronizationArtifact.deserialize(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BadDocumentRootException | UnknownSynchronizationArtifactTypeException e) {
            throw new BadRequestException(this.buildExceptionMessage(e), Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        catch (Exception e) {
            throw new ServerErrorException(this.buildExceptionMessage(e), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
    }
}

