/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;

public class PublishingUtils {
    private final OrcsTokenService orcsTokenService;
    private final QueryFactory queryFactory;

    public PublishingUtils(OrcsApi orcsApi) {
        this.queryFactory = Objects.requireNonNull(orcsApi.getQueryFactory());
        this.orcsTokenService = Objects.requireNonNull(orcsApi.tokenService());
    }

    public Optional<ArtifactReadable> getArtifactReadableByTypeAndName(BranchId branchId, ArtifactId viewId, ArtifactTypeToken artifactTypeToken, String artifactName) {
        try {
            return Optional.ofNullable(this.queryFactory.fromBranch(branchId, viewId).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).andNameEquals(artifactName).getArtifact());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public Optional<ArtifactReadable> getArtifactReadableByTypeNameAndName(BranchId branchId, ArtifactId viewId, String artifactTypeName, String artifactName) {
        try {
            return this.getArtifactTypeTokenByName(artifactTypeName).flatMap(artifactTypeToken -> this.getArtifactReadableByTypeAndName(branchId, viewId, (ArtifactTypeToken)artifactTypeToken, artifactName));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public Optional<ArtifactTypeToken> getArtifactTypeTokenByName(String artifactTypeName) {
        try {
            return Optional.of(this.orcsTokenService.getArtifactType(artifactTypeName));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public Optional<ArtifactReadable> getChildArtifactReadableByTypeAndName(BranchId branchId, ArtifactId viewId, ArtifactId parent, ArtifactTypeToken artifactTypeToken, String artifactName) {
        try {
            return Optional.ofNullable(this.queryFactory.fromBranch(branchId, viewId).andIsOfType(new ArtifactTypeToken[]{artifactTypeToken}).andNameEquals(artifactName).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, parent).getArtifact());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public Optional<ArtifactReadable> getChildArtifactReadableByTypeNameAndName(BranchId branchId, ArtifactId viewId, ArtifactId parent, String artifactTypeName, String artifactName) {
        try {
            return this.getArtifactTypeTokenByName(artifactTypeName).flatMap(artifactTypeToken -> this.getChildArtifactReadableByTypeAndName(branchId, viewId, parent, (ArtifactTypeToken)artifactTypeToken, artifactName));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public List<ArtifactReadable> getRecursiveChildenArtifactReadablesByAttributeTypeAndAttributeValue(BranchId branchId, ArtifactId viewId, ArtifactReadable parent, AttributeTypeId attributeTypeId, String value) {
        return this.queryFactory.fromBranch(branchId, viewId).andAttributeIs(attributeTypeId, value).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)parent).getResults().getList();
    }
}

