/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.ImportTraceabilityPage;
import org.eclipse.osee.define.ide.traceability.ScriptTraceabilityOperation;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportTraceabilityWizard
extends Wizard
implements IImportWizard {
    private ImportTraceabilityPage mainPage;
    private IStructuredSelection selection;

    public ImportTraceabilityWizard() {
        this.setWindowTitle("Traceability Import Wizard");
    }

    public boolean performFinish() {
        try {
            BranchId branch = this.mainPage.getSelectedBranch();
            File file = this.mainPage.getImportFile();
            boolean isGitBased = this.mainPage.isGitBased();
            boolean includeImpd = this.mainPage.includeImpd();
            LinkedList<TraceUnitExtensionManager.TraceHandler> handlers = new LinkedList<TraceUnitExtensionManager.TraceHandler>();
            String[] stringArray = this.mainPage.getTraceUnitHandlerIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String handlerId = stringArray[n2];
                handlers.add(TraceUnitExtensionManager.getInstance().getTraceUnitHandlerById(handlerId));
                ++n2;
            }
            Operations.executeWorkAndCheckStatus((IOperation)new ScriptTraceabilityOperation(file, branch, true, handlers, isGitBased, ArtifactId.SENTINEL, includeImpd));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Traceability Import Error", (Throwable)ex);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.mainPage = new ImportTraceabilityPage(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }
}

