/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.relation;

import java.io.File;
import java.util.Date;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeViewerTest {
    public static void main(String[] args) {
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FormLayout());
        TreeViewerTestLabelProvider labelProvider1 = new TreeViewerTest().new TreeViewerTestLabelProvider();
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (!(parentElement instanceof File)) {
                    return null;
                }
                File file = (File)parentElement;
                if (file.isDirectory()) {
                    return file.listFiles();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (!(element instanceof File)) {
                    return null;
                }
                File file = (File)element;
                return file.getParentFile();
            }

            public boolean hasChildren(Object element) {
                if (!(element instanceof File)) {
                    return false;
                }
                File file = (File)element;
                return file.isDirectory();
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        ILabelProvider labelProvider2 = new ILabelProvider(){

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                if (!(element instanceof File)) {
                    return null;
                }
                File file = (File)element;
                if (file.isDirectory()) {
                    return display.getSystemImage(8);
                }
                return display.getSystemImage(4);
            }

            public String getText(Object element) {
                if (!(element instanceof File)) {
                    return null;
                }
                File file = (File)element;
                return file.getName();
            }
        };
        final TreeViewer treeViewer1 = new TreeViewer((Composite)shell, 65568);
        Tree tree1 = treeViewer1.getTree();
        tree1.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(tree1, 16384);
        column1.setText("Name");
        column1.setImage(display.getSystemImage(16));
        column1.setWidth(200);
        TreeColumn column2 = new TreeColumn(tree1, 0x1000000);
        column2.setText("Last Modified");
        column2.setImage(display.getSystemImage(2));
        column2.setWidth(200);
        TreeColumn column3 = new TreeColumn(tree1, 0x1000000);
        column3.setText("Hidden");
        column3.setImage(display.getSystemImage(2));
        column3.setWidth(100);
        treeViewer1.setLabelProvider((IBaseLabelProvider)labelProvider1);
        treeViewer1.setContentProvider((IContentProvider)contentProvider);
        final TreeViewer treeViewer2 = new TreeViewer((Composite)shell);
        Tree tree2 = treeViewer2.getTree();
        treeViewer2.setLabelProvider((IBaseLabelProvider)labelProvider2);
        treeViewer2.setContentProvider((IContentProvider)contentProvider);
        Button b = new Button((Composite)shell, 8);
        b.setText("choose root folder");
        b.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                File file;
                DirectoryDialog f = new DirectoryDialog(shell, 4096);
                String root = f.open();
                if (root != null && (file = new File(root)).exists()) {
                    treeViewer1.setInput((Object)file);
                    treeViewer1.refresh();
                    treeViewer2.setInput((Object)file);
                    treeViewer2.refresh();
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, -5);
        data.bottom = new FormAttachment((Control)b, -10);
        tree1.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(50, 5);
        data.top = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment((Control)b, -10);
        tree2.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.bottom = new FormAttachment(100, -10);
        b.setLayoutData((Object)data);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    class TreeViewerTestLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        Font font = null;

        TreeViewerTestLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof File)) {
                return null;
            }
            File file = (File)element;
            switch (columnIndex) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return "" + new Date(file.lastModified());
                }
                case 2: {
                    return "" + file.isHidden();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            if (!(element instanceof File)) {
                return null;
            }
            File file = (File)element;
            if (file.isDirectory()) {
                return Displays.getSystemImage((int)8);
            }
            return Displays.getSystemImage((int)4);
        }

        public void dispose() {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return Displays.getSystemColor((int)3);
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            if (columnIndex == 0) {
                File file = (File)element;
                if (file.isDirectory()) {
                    return Displays.getSystemColor((int)13);
                }
                return Displays.getSystemColor((int)11);
            }
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            if (columnIndex == 2) {
                if (this.font == null) {
                    Display display = Display.getCurrent();
                    this.font = new Font((Device)display, "Times", 12, 2);
                }
                return this.font;
            }
            return null;
        }
    }
}

