/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;

public class ApplicabilityUtility {
    public static HashCollection<String, String> getValidFeatureValuesForBranch(BranchId branch) {
        OseeClient oseeClient = ServiceUtil.getOseeClient();
        List featureDefinitionData = oseeClient.getApplicabilityEndpoint(branch).getFeatureDefinitionData();
        HashCollection validFeatureValues = new HashCollection();
        for (FeatureDefinition feat : featureDefinitionData) {
            validFeatureValues.put((Object)feat.getName().toUpperCase(), (Collection)feat.getValues());
        }
        return validFeatureValues;
    }

    public static HashSet<String> getBranchViewNamesUpperCase(BranchId branch) {
        HashSet<String> names = new HashSet<String>();
        Collection<ArtifactToken> views = ArtifactQuery.getArtifactTokenListFromType(CoreArtifactTypes.BranchView, branch);
        for (ArtifactToken view : views) {
            names.add(view.getName().toUpperCase());
        }
        return names;
    }

    public static HashSet<String> getConfigurationGroupsUpperCase(BranchId branch) {
        HashSet<String> names = new HashSet<String>();
        OseeClient oseeClient = ServiceUtil.getOseeClient();
        oseeClient.getApplicabilityEndpoint(branch).getViews();
        Collection<ArtifactToken> views = ArtifactQuery.getArtifactTokenListFromType(CoreArtifactTypes.GroupArtifact, branch);
        for (ArtifactToken view : views) {
            names.add(view.getName().toUpperCase());
        }
        return names;
    }
}

